/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.logic.messages;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.fortuna.ical4j.model.component.VEvent;
import org.apache.commons.lang.StringUtils;
import org.sakaiproject.signup.logic.SakaiFacade;
import org.sakaiproject.signup.logic.messages.SignupEmailNotification;
import org.sakaiproject.signup.model.MeetingTypes;
import org.sakaiproject.signup.model.SignupMeeting;
import org.sakaiproject.signup.model.SignupTimeslot;
import org.sakaiproject.time.api.Time;
import org.sakaiproject.user.api.User;
import org.sakaiproject.util.ResourceLoader;

public abstract class SignupEmailBase
implements SignupEmailNotification,
MeetingTypes {
    private SakaiFacade sakaiFacade;
    protected SignupMeeting meeting;
    protected static ResourceLoader rb = new ResourceLoader("emailMessage");
    public static final String newline = "<BR>\r\n";
    public static final String space = " ";
    private static final int SITE_DESCRIPTION_DISPLAY_LENGTH = 20;
    protected boolean cancellation = false;
    protected boolean modifyComment = false;
    private static String myServiceName = null;

    protected String getFooter(String newline) {
        if (this.meeting.getCurrentSiteId() == null) {
            return this.getFooterWithAccessUrl(newline);
        }
        return this.getFooterWithNoAccessUrl(newline);
    }

    protected String getFooter(String newline, String targetSiteId) {
        Object[] params = new Object[]{this.getServiceName(), "<a href=\"" + this.getSiteAccessUrl(targetSiteId) + "\">" + this.getSiteAccessUrl(targetSiteId) + "</a>", this.getSiteTitle(targetSiteId), newline};
        String rv = newline + rb.getString("separator") + newline + MessageFormat.format(rb.getString("body.footer.text"), params) + newline;
        return rv;
    }

    private String getFooterWithAccessUrl(String newline) {
        Object[] params = new Object[]{this.getServiceName(), "<a href=\"" + this.getSiteAccessUrl() + "\">" + this.getSiteAccessUrl() + "</a>", this.getSiteTitle(), newline};
        String rv = newline + rb.getString("separator") + newline + MessageFormat.format(rb.getString("body.footer.text"), params) + newline;
        return rv;
    }

    private String getFooterWithNoAccessUrl(String newline) {
        Object[] params = new Object[]{this.getServiceName(), this.getSiteTitle(), newline};
        String rv = newline + rb.getString("separator") + newline + MessageFormat.format(rb.getString("body.footer.text.no.access.link"), params) + newline;
        return rv;
    }

    public abstract List<String> getHeader();

    public abstract String getMessage();

    public abstract String getFromAddress();

    public abstract String getSubject();

    protected String getSiteId() {
        String siteId = this.getSakaiFacade().getCurrentLocationId();
        if ("noLocationAvailable".equals(siteId)) {
            siteId = this.meeting.getCurrentSiteId() != null ? this.meeting.getCurrentSiteId() : "noLocationAvailable";
        }
        return siteId;
    }

    protected String getSiteTitle() {
        return this.getSakaiFacade().getLocationTitle(this.getSiteId());
    }

    protected String getSiteTitle(String targetSiteId) {
        return this.getSakaiFacade().getLocationTitle(targetSiteId);
    }

    protected String getShortSiteTitle(String targetSiteId) {
        return this.getSakaiFacade().getLocationTitle(targetSiteId);
    }

    protected String getSiteTitleWithQuote() {
        return "\"" + this.getSiteTitle() + "\"";
    }

    protected String getSiteTitleWithQuote(String targetSiteId) {
        return "\"" + this.getSiteTitle(targetSiteId) + "\"";
    }

    protected String getShortSiteTitleWithQuote(String targetSiteId) {
        return "\"" + this.getShortSiteTitle(targetSiteId) + "\"";
    }

    protected String getSiteAccessUrl() {
        String siteUrl = this.getSakaiFacade().getServerConfigurationService().getPortalUrl() + "/site/" + this.getSiteId() + "/page/" + this.getSakaiFacade().getCurrentPageId();
        return siteUrl;
    }

    protected String getSiteAccessUrl(String targetSiteId) {
        String siteUrl = this.getSakaiFacade().getServerConfigurationService().getPortalUrl() + "/site/" + targetSiteId + "/page/" + this.getSakaiFacade().getSiteSignupPageId(targetSiteId);
        return siteUrl;
    }

    protected String getAbbreviatedMeetingTitle() {
        return StringUtils.abbreviate((String)this.meeting.getTitle(), (int)30);
    }

    protected Time getTime(Date date) {
        Time time = this.getSakaiFacade().getTimeService().newTime(date.getTime());
        return time;
    }

    protected String makeFirstCapLetter(String st) {
        return StringUtils.capitalize((String)st);
    }

    protected String getServiceName() {
        if (myServiceName == null) {
            try {
                myServiceName = rb.keySet().contains("ui.service") ? rb.getString("ui.service") : this.getSakaiFacade().getServerConfigurationService().getString("ui.service", "Sakai Service");
            }
            catch (Exception e) {
                myServiceName = this.getSakaiFacade().getServerConfigurationService().getString("ui.service", "Sakai Service");
            }
        }
        return myServiceName;
    }

    protected String getRepeatTypeMessage(SignupMeeting meeting) {
        String recurFrqs = "";
        recurFrqs = "daily".equals(meeting.getRepeatType()) ? rb.getString("body.meeting.repeatDaily") : ("wkdays_mon-fri".equals(meeting.getRepeatType()) ? rb.getString("body.meeting.repeatWeekdays") : ("weekly".equals(meeting.getRepeatType()) ? rb.getString("body.meeting.repeatWeekly") : ("biweekly".equals(meeting.getRepeatType()) ? rb.getString("body.meeting.repeatBiWeekly") : rb.getString("body.meeting.unknown.repeatType"))));
        return recurFrqs;
    }

    protected String getServerFromAddress() {
        return this.getServiceName() + " <" + this.getSakaiFacade().getServerConfigurationService().getString("setup.request", rb.getString("no-reply@") + this.getSakaiFacade().getServerConfigurationService().getServerName()) + ">";
    }

    protected boolean userIsAttendingTimeslot(User user, SignupTimeslot timeslot) {
        return timeslot.getAttendee(user.getId()) != null;
    }

    protected List<VEvent> eventsWhichUserIsAttending(User user) {
        List timeslots = this.meeting.getSignupTimeSlots();
        ArrayList<VEvent> events = new ArrayList<VEvent>();
        for (SignupTimeslot timeslot : timeslots) {
            VEvent event;
            if (!this.userIsAttendingTimeslot(user, timeslot) || (event = timeslot.getVevent()) == null) continue;
            events.add(event);
        }
        return events;
    }

    public boolean isCancellation() {
        return this.cancellation;
    }

    public boolean isModifyComment() {
        return this.modifyComment;
    }

    public void setModifyComment(boolean modifyComment) {
        this.modifyComment = modifyComment;
    }

    public SakaiFacade getSakaiFacade() {
        return this.sakaiFacade;
    }

    public void setSakaiFacade(SakaiFacade sakaiFacade) {
        this.sakaiFacade = sakaiFacade;
    }

    public SignupMeeting getMeeting() {
        return this.meeting;
    }
}

