/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.logic.messages;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sakaiproject.signup.logic.SakaiFacade;
import org.sakaiproject.signup.logic.SignupTrackingItem;
import org.sakaiproject.signup.logic.messages.AttendeeEmailBase;
import org.sakaiproject.signup.model.SignupMeeting;
import org.sakaiproject.user.api.User;

public class AddAttendeeEmail
extends AttendeeEmailBase {
    private final User organizer;
    private final User attendee;
    private final SignupTrackingItem item;
    private String emailReturnSiteId;

    public AddAttendeeEmail(User organizer, User attendee, SignupTrackingItem item, SignupMeeting meeting, SakaiFacade sakaiFacade) {
        this.organizer = organizer;
        this.attendee = attendee;
        this.item = item;
        this.meeting = meeting;
        this.setSakaiFacade(sakaiFacade);
        this.emailReturnSiteId = item.getAttendee().getSignupSiteId();
    }

    @Override
    public List<String> getHeader() {
        ArrayList<String> rv = new ArrayList<String>();
        rv.add("Content-Type: text/html; charset=UTF-8");
        rv.add("Subject: " + this.getSubject());
        rv.add("From: " + this.getFromAddress());
        rv.add("To: " + this.attendee.getEmail());
        return rv;
    }

    @Override
    public String getMessage() {
        StringBuilder message = new StringBuilder();
        message.append(MessageFormat.format(rb.getString("body.top.greeting.part"), this.makeFirstCapLetter(this.attendee.getDisplayName())));
        Object[] params = new Object[]{this.makeFirstCapLetter(this.organizer.getDisplayName()), this.getSiteTitleWithQuote(this.emailReturnSiteId), this.getServiceName()};
        message.append("<BR>\r\n<BR>\r\n" + MessageFormat.format(rb.getString("body.assigned.new.appointment.part"), params));
        message.append("<BR>\r\n<BR>\r\n" + MessageFormat.format(rb.getString("body.meetingTopic.part"), this.meeting.getTitle()));
        if (!this.meeting.isMeetingCrossDays()) {
            Object[] paramsTimeframe = new Object[]{this.getTime(this.item.getAddToTimeslot().getStartTime()).toStringLocalTime(), this.getTime(this.item.getAddToTimeslot().getEndTime()).toStringLocalTime(), this.getTime(this.item.getAddToTimeslot().getStartTime()).toStringLocalDate(), this.getSakaiFacade().getTimeService().getLocalTimeZone().getID()};
            message.append("<BR>\r\n" + MessageFormat.format(rb.getString("body.attendee.meeting.timeslot"), paramsTimeframe));
        } else {
            Object[] paramsTimeframe = new Object[]{this.getTime(this.item.getAddToTimeslot().getStartTime()).toStringLocalTime(), this.getTime(this.item.getAddToTimeslot().getStartTime()).toStringLocalShortDate(), this.getTime(this.item.getAddToTimeslot().getEndTime()).toStringLocalTime(), this.getTime(this.item.getAddToTimeslot().getEndTime()).toStringLocalShortDate(), this.getSakaiFacade().getTimeService().getLocalTimeZone().getID()};
            message.append("<BR>\r\n" + MessageFormat.format(rb.getString("body.attendee.meeting.crossdays.timeslot"), paramsTimeframe));
        }
        message.append("<BR>\r\n<BR>\r\n" + MessageFormat.format(rb.getString("body.attendeeCheck.meetingStatus.B"), this.getServiceName()));
        message.append("<BR>\r\n" + this.getFooter("<BR>\r\n", this.emailReturnSiteId));
        return message.toString();
    }

    @Override
    public String getFromAddress() {
        return StringUtils.defaultIfEmpty((String)this.organizer.getEmail(), (String)this.getServerFromAddress());
    }

    @Override
    public String getSubject() {
        return MessageFormat.format(rb.getString("subject.new.appointment.field"), this.organizer.getDisplayName(), this.getTime(this.meeting.getStartTime()).toStringLocalDate(), this.getAbbreviatedMeetingTitle());
    }
}

