/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.logic;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.sakaiproject.email.api.EmailService;
import org.sakaiproject.signup.dao.SignupMeetingDao;
import org.sakaiproject.signup.logic.SakaiFacade;
import org.sakaiproject.signup.logic.messages.AutoReminderEmail;
import org.sakaiproject.signup.logic.messages.SignupEmailNotification;
import org.sakaiproject.signup.model.SignupAttendee;
import org.sakaiproject.signup.model.SignupMeeting;
import org.sakaiproject.signup.model.SignupTimeslot;
import org.sakaiproject.user.api.User;
import org.sakaiproject.user.api.UserDirectoryService;
import org.sakaiproject.user.api.UserNotDefinedException;

public class SignupNotifyJob
implements Job {
    private static final Log LOGGER = LogFactory.getLog(SignupNotifyJob.class);
    private EmailService emailService;
    private SignupMeetingDao signupMeetingDao;
    private SakaiFacade sakaiFacade;
    private UserDirectoryService userDirectoryService;
    private static final int HOURS_IN_ADVANCE = 24;
    private static final int ONE_DAY_INTERVAL = 24;
    private static final int MAX_EVENTS_LIMITS = 2000;
    private List<User> userlist = new ArrayList<User>();

    public void init() {
    }

    public void destroy() {
    }

    public EmailService getEmailService() {
        return this.emailService;
    }

    public void setEmailService(EmailService emailService) {
        this.emailService = emailService;
    }

    public void execute(JobExecutionContext arg0) throws JobExecutionException {
        LOGGER.warn((Object)"Starting Signup Auto Reminder Notification job");
        List<SignupMeeting> signupMeetings = null;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        int currentHour = calendar.get(11);
        int currentMinutes = calendar.get(12);
        calendar.add(10, -1 * currentHour);
        calendar.add(12, -1 * currentMinutes);
        if (currentHour > 20) {
            calendar.add(10, 24);
        }
        calendar.add(10, 24);
        Date searchStarDate = calendar.getTime();
        calendar.add(10, 24);
        Date searchEndDate = calendar.getTime();
        int totalCounts = this.signupMeetingDao.getAutoReminderTotalEventCounts(searchStarDate, searchEndDate);
        if (totalCounts == 0) {
            LOGGER.info((Object)"There is no upcoming event today for Signup Auto Reminder Notification");
            return;
        }
        if (totalCounts > 2000) {
            LOGGER.error((Object)("Notification will not be processed. The total upcoming events:" + totalCounts + " exceed the maximum process limits:" + 2000 + ". Please check the DB errors or increase the maximum limit for notifiction process."));
            return;
        }
        int totalEmails = 0;
        signupMeetings = this.signupMeetingDao.getAutoReminderSignupMeetings(searchStarDate, searchEndDate);
        if (signupMeetings != null) {
            for (SignupMeeting sm : signupMeetings) {
                List tsList = sm.getSignupTimeSlots();
                if (tsList == null) continue;
                for (SignupTimeslot tsItem : tsList) {
                    List attendees;
                    if (tsItem == null || !tsItem.getStartTime().before(searchEndDate) || !tsItem.getStartTime().after(searchStarDate) || (attendees = tsItem.getAttendees()) == null) continue;
                    for (SignupAttendee att : attendees) {
                        String userId = att.getAttendeeUserId();
                        String siteId = att.getSignupSiteId();
                        User user = null;
                        try {
                            user = this.userDirectoryService.getUser(userId);
                            AutoReminderEmail email = new AutoReminderEmail(user, tsItem, sm, siteId, this.getSakaiFacade());
                            this.sendEmail(user, email);
                            ++totalEmails;
                        }
                        catch (UserNotDefinedException e) {
                            LOGGER.warn((Object)("User is not found for userId: " + userId));
                        }
                    }
                }
            }
        }
        LOGGER.warn((Object)("Completed Signup Auto Reminder Notification job with total events:" + totalCounts + " and outgoing emails:" + totalEmails + "."));
    }

    private void sendEmail(User user, SignupEmailNotification email) {
        this.userlist.clear();
        this.userlist.add(user);
        this.emailService.sendToUsers(this.userlist, (Collection)email.getHeader(), email.getMessage());
    }

    public SignupMeetingDao getSignupMeetingDao() {
        return this.signupMeetingDao;
    }

    public void setSignupMeetingDao(SignupMeetingDao signupMeetingDao) {
        this.signupMeetingDao = signupMeetingDao;
    }

    public SakaiFacade getSakaiFacade() {
        return this.sakaiFacade;
    }

    public void setSakaiFacade(SakaiFacade sakaiFacade) {
        this.sakaiFacade = sakaiFacade;
    }

    public UserDirectoryService getUserDirectoryService() {
        return this.userDirectoryService;
    }

    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }
}

