/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.logic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.authz.api.SecurityAdvisor;
import org.sakaiproject.calendar.api.Calendar;
import org.sakaiproject.calendar.api.CalendarEventEdit;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.signup.dao.SignupMeetingDao;
import org.sakaiproject.signup.logic.Permission;
import org.sakaiproject.signup.logic.Retry;
import org.sakaiproject.signup.logic.SakaiFacade;
import org.sakaiproject.signup.logic.SignupCacheService;
import org.sakaiproject.signup.logic.SignupEmailFacade;
import org.sakaiproject.signup.logic.SignupMeetingService;
import org.sakaiproject.signup.logic.SignupMessageTypes;
import org.sakaiproject.signup.logic.SignupUserActionException;
import org.sakaiproject.signup.logic.messages.SignupEventTrackingInfo;
import org.sakaiproject.signup.model.MeetingTypes;
import org.sakaiproject.signup.model.SignupAttendee;
import org.sakaiproject.signup.model.SignupGroup;
import org.sakaiproject.signup.model.SignupMeeting;
import org.sakaiproject.signup.model.SignupSite;
import org.sakaiproject.signup.model.SignupTimeslot;
import org.sakaiproject.signup.restful.SignupTargetSiteEventInfo;
import org.sakaiproject.signup.util.PlainTextFormat;
import org.sakaiproject.site.api.Group;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.time.api.Time;
import org.sakaiproject.time.api.TimeRange;
import org.sakaiproject.time.api.TimeService;
import org.springframework.dao.OptimisticLockingFailureException;

public class SignupMeetingServiceImpl
implements SignupMeetingService,
Retry,
MeetingTypes,
SignupMessageTypes {
    private static Log log = LogFactory.getLog(SignupMeetingServiceImpl.class);
    private SignupMeetingDao signupMeetingDao;
    private SakaiFacade sakaiFacade;
    private SignupCacheService signupCacheService;
    private SignupEmailFacade signupEmailFacade;

    public void init() {
        log.debug((Object)"init");
    }

    public List<SignupMeeting> getAllSignupMeetings(String currentSiteId, String userId) {
        List<SignupMeeting> meetings = this.signupMeetingDao.getAllSignupMeetings(currentSiteId);
        return this.screenAllowableMeetings(currentSiteId, userId, meetings);
    }

    public List<SignupMeeting> getSignupMeetings(String currentSiteId, String userId, Date searchEndDate) {
        List<SignupMeeting> meetings = this.signupMeetingDao.getSignupMeetings(currentSiteId, searchEndDate);
        return this.screenAllowableMeetings(currentSiteId, userId, meetings);
    }

    public List<SignupMeeting> getSignupMeetings(String currentSiteId, String userId, Date startDate, Date endDate) {
        List<SignupMeeting> meetings = this.signupMeetingDao.getSignupMeetings(currentSiteId, startDate, endDate);
        return this.screenAllowableMeetings(currentSiteId, userId, meetings);
    }

    public List<SignupMeeting> getSignupMeetingsInSiteWithCache(String siteId, Date startDate, int timeFrameInDays) {
        List meetings = this.signupCacheService.getAllSignupMeetingsInSite(siteId, startDate, timeFrameInDays);
        return meetings;
    }

    public List<SignupMeeting> getSignupMeetingsInSitesWithCache(List<String> siteIds, Date startDate, int timeFrameInDays) {
        List meetings = this.signupCacheService.getAllSignupMeetingsInSites(siteIds, startDate, timeFrameInDays);
        return meetings;
    }

    public List<SignupMeeting> getSignupMeetingsInSite(String siteId, Date startDate, Date endDate) {
        List<SignupMeeting> meetings = this.signupMeetingDao.getSignupMeetingsInSite(siteId, startDate, endDate);
        return meetings;
    }

    public List<SignupMeeting> getSignupMeetingsInSites(List<String> siteIds, Date startDate, Date endDate) {
        List<SignupMeeting> meetings = this.signupMeetingDao.getSignupMeetingsInSites(siteIds, startDate, endDate);
        return meetings;
    }

    public List<SignupMeeting> getRecurringSignupMeetings(String currentSiteId, String userId, Long recurrenceId, Date startDate) {
        List<SignupMeeting> meetings = this.signupMeetingDao.getRecurringSignupMeetings(currentSiteId, recurrenceId, startDate);
        return this.screenAllowableMeetings(currentSiteId, userId, meetings);
    }

    private List<SignupMeeting> screenAllowableMeetings(String currentSiteId, String userId, List<SignupMeeting> meetings) {
        ArrayList<SignupMeeting> allowedMeetings = new ArrayList<SignupMeeting>();
        for (SignupMeeting meeting : meetings) {
            if (!this.isAllowedToView(meeting, userId, currentSiteId)) continue;
            allowedMeetings.add(meeting);
        }
        this.updatePermissions(userId, currentSiteId, meetings);
        return allowedMeetings;
    }

    private void updatePermissions(String userId, String siteId, List<SignupMeeting> meetings) {
        for (SignupMeeting meeting : meetings) {
            boolean attend = this.isAllowToAttend(userId, siteId, meeting);
            boolean update = this.isAllowToUpdate(userId, siteId, meeting);
            boolean delete = this.isAllowToDelete(userId, siteId, meeting);
            Permission permission = new Permission(attend, update, delete);
            meeting.setPermission(permission);
        }
    }

    private String assignPermission(String userId, String siteId, SignupMeeting meeting) {
        String targetSiteId = siteId;
        if (targetSiteId == null) {
            targetSiteId = this.findSiteWithHighestPermissionLevel(userId, meeting);
        }
        if (targetSiteId != null) {
            boolean attend = this.isAllowToAttend(userId, targetSiteId, meeting);
            boolean update = this.isAllowToUpdate(userId, targetSiteId, meeting);
            boolean delete = this.isAllowToDelete(userId, targetSiteId, meeting);
            Permission permission = new Permission(attend, update, delete);
            meeting.setPermission(permission);
        }
        return targetSiteId;
    }

    private String findSiteWithHighestPermissionLevel(String userId, SignupMeeting meeting) {
        boolean update;
        String sId;
        List sites = meeting.getSignupSites();
        for (SignupSite site : sites) {
            sId = site.getSiteId();
            update = this.isAllowToUpdate(userId, sId, meeting);
            boolean delete = this.isAllowToDelete(userId, sId, meeting);
            if (!update || !delete) continue;
            return sId;
        }
        for (SignupSite site : sites) {
            sId = site.getSiteId();
            update = this.isAllowToUpdate(userId, sId, meeting);
            if (!update) continue;
            return sId;
        }
        for (SignupSite site : sites) {
            sId = site.getSiteId();
            boolean attend = this.isAllowToAttend(userId, sId, meeting);
            if (!attend) continue;
            return sId;
        }
        return null;
    }

    private boolean isAllowToDelete(String userId, String siteId, SignupMeeting meeting) {
        if (this.sakaiFacade.isUserAdmin(userId)) {
            return true;
        }
        SignupSite site = this.currentSite(meeting, siteId);
        if (site != null) {
            if (site.isSiteScope()) {
                return this.sakaiFacade.isAllowedSite(userId, "signup.delete.site", site.getSiteId());
            }
            if (this.sakaiFacade.isAllowedSite(userId, "signup.delete.group.all", site.getSiteId()) || this.sakaiFacade.isAllowedSite(userId, "signup.delete.site", site.getSiteId())) {
                return true;
            }
            boolean allowedTodelete = true;
            List signupGroups = site.getSignupGroups();
            for (SignupGroup group : signupGroups) {
                if (this.sakaiFacade.isAllowedGroup(userId, "signup.delete.group", site.getSiteId(), group.getGroupId()) || this.sakaiFacade.isAllowedGroup(userId, "signup.delete.group.all", siteId, group.getGroupId())) continue;
                allowedTodelete = false;
                break;
            }
            return allowedTodelete;
        }
        return false;
    }

    private boolean isAllowToUpdate(String userId, String siteId, SignupMeeting meeting) {
        if (this.sakaiFacade.isUserAdmin(userId)) {
            return true;
        }
        SignupSite site = this.currentSite(meeting, siteId);
        if (site != null) {
            if (site.isSiteScope() && this.sakaiFacade.isAllowedSite(userId, "signup.update.site", site.getSiteId())) {
                return true;
            }
            if (this.sakaiFacade.isAllowedSite(userId, "signup.update.group.all", site.getSiteId()) || this.sakaiFacade.isAllowedSite(userId, "signup.update.site", site.getSiteId())) {
                return true;
            }
            List signupGroups = site.getSignupGroups();
            for (SignupGroup group : signupGroups) {
                if (!this.sakaiFacade.isAllowedGroup(userId, "signup.update.group", site.getSiteId(), group.getGroupId()) && !this.sakaiFacade.isAllowedGroup(userId, "signup.update.group.all", siteId, group.getGroupId())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isAllowToAttend(String userId, String siteId, SignupMeeting meeting) {
        if (this.sakaiFacade.isUserAdmin(userId)) {
            return true;
        }
        if (this.sakaiFacade.isAllowedSite(userId, "signup.attend.all", siteId)) {
            return true;
        }
        SignupSite site = this.currentSite(meeting, siteId);
        if (site != null) {
            if (site.isSiteScope()) {
                return this.sakaiFacade.isAllowedSite(userId, "signup.attend", siteId);
            }
            List signupGroups = site.getSignupGroups();
            for (SignupGroup group : signupGroups) {
                if (!this.sakaiFacade.isAllowedGroup(userId, "signup.attend", siteId, group.getGroupId()) && !this.sakaiFacade.isAllowedGroup(userId, "signup.attend.all", siteId, group.getGroupId())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isAllowedToView(SignupMeeting meeting, String userId, String siteId) {
        if (this.sakaiFacade.isUserAdmin(userId)) {
            return true;
        }
        if (this.sakaiFacade.isAllowedSite(userId, "signup.view.all", siteId)) {
            return true;
        }
        SignupSite site = this.currentSite(meeting, siteId);
        if (site != null) {
            if (site.isSiteScope()) {
                return this.sakaiFacade.isAllowedSite(userId, "signup.view", siteId);
            }
            List signupGroups = site.getSignupGroups();
            for (SignupGroup group : signupGroups) {
                if (!this.sakaiFacade.isAllowedGroup(userId, "signup.view", siteId, group.getGroupId()) && !this.sakaiFacade.isAllowedGroup(userId, "signup.view.all", siteId, group.getGroupId())) continue;
                return true;
            }
        }
        return false;
    }

    private SignupSite currentSite(SignupMeeting meeting, String siteId) {
        List signupSites = meeting.getSignupSites();
        for (SignupSite site : signupSites) {
            if (!site.getSiteId().equals(siteId)) continue;
            return site;
        }
        return null;
    }

    public Long saveMeeting(SignupMeeting signupMeeting, String userId) throws PermissionException {
        if (this.isAllowedToCreate(userId, signupMeeting)) {
            return this.signupMeetingDao.saveMeeting(signupMeeting);
        }
        throw new PermissionException(userId, "signup.create", "signup tool");
    }

    public void saveMeetings(List<SignupMeeting> signupMeetings, String userId) throws PermissionException {
        if (signupMeetings == null || signupMeetings.isEmpty()) {
            return;
        }
        if (!this.isAllowedToCreate(userId, signupMeetings.get(0))) {
            throw new PermissionException(userId, "signup.create", "signup tool");
        }
        this.signupMeetingDao.saveMeetings(signupMeetings);
    }

    private boolean isAllowedToCreate(String userId, SignupMeeting signupMeeting) {
        if (this.sakaiFacade.isUserAdmin(userId)) {
            return true;
        }
        List signupSites = signupMeeting.getSignupSites();
        for (SignupSite site : signupSites) {
            if (site.isSiteScope()) {
                if (this.sakaiFacade.isAllowedSite(userId, "signup.create.site", site.getSiteId())) continue;
                return false;
            }
            if (this.sakaiFacade.isAllowedSite(userId, "signup.create.site", site.getSiteId()) || this.sakaiFacade.isAllowedSite(userId, "signup.create.group.all", site.getSiteId())) continue;
            List signupGroups = site.getSignupGroups();
            for (SignupGroup group : signupGroups) {
                if (this.sakaiFacade.isAllowedGroup(userId, "signup.create.group", site.getSiteId(), group.getGroupId()) || this.sakaiFacade.isAllowedGroup(userId, "signup.create.group.all", site.getSiteId(), group.getGroupId())) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isAllowedToCreateinGroup(String userId, String siteId, String groupId) {
        return this.sakaiFacade.isAllowedSite(userId, "signup.create.group.all", siteId) || this.sakaiFacade.isAllowedGroup(userId, "signup.create.group", siteId, groupId);
    }

    public boolean isAllowedToCreateinSite(String userId, String siteId) {
        return this.sakaiFacade.isAllowedSite(userId, "signup.create.site", siteId);
    }

    public boolean isAllowedToCreateAnyInSite(String userId, String siteId) {
        if (this.sakaiFacade.isUserAdmin(userId)) {
            return true;
        }
        if (this.sakaiFacade.isAllowedSite(userId, "signup.create.site", siteId)) {
            return true;
        }
        Site site = null;
        try {
            site = this.sakaiFacade.getSiteService().getSite(siteId);
        }
        catch (IdUnusedException e) {
            log.info((Object)("IdUnusedException for siteId: siteId  -- " + e.getMessage()));
            return false;
        }
        Collection groups = site.getGroups();
        if (groups == null || groups.isEmpty()) {
            return false;
        }
        for (Group gp : groups) {
            if (!this.isAllowedToCreateinGroup(userId, siteId, gp.getId())) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateSignupMeeting(SignupMeeting meeting, boolean isOrganizer) throws Exception {
        Permission permission = meeting.getPermission();
        if (permission == null) {
            if (!this.isAllowToUpdate(this.sakaiFacade.getCurrentUserId(), this.sakaiFacade.getCurrentLocationId(), meeting)) throw new PermissionException(this.sakaiFacade.getCurrentUserId(), "signup.update", "SignupTool");
            this.signupMeetingDao.updateMeeting(meeting);
            return;
        }
        if (isOrganizer) {
            if (!permission.isUpdate()) throw new PermissionException(this.sakaiFacade.getCurrentUserId(), "signup.update", "SignupTool");
            this.signupMeetingDao.updateMeeting(meeting);
            return;
        } else {
            if (!permission.isAttend()) throw new PermissionException(this.sakaiFacade.getCurrentUserId(), "signup.attend", "SignupTool");
            this.signupMeetingDao.updateMeeting(meeting);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateSignupMeetings(List<SignupMeeting> meetings, boolean isOrganizer) throws Exception {
        if (meetings == null || meetings.isEmpty()) {
            return;
        }
        SignupMeeting oneMeeting = meetings.get(0);
        Permission permission = oneMeeting.getPermission();
        if (permission == null) {
            if (!this.isAllowToUpdate(this.sakaiFacade.getCurrentUserId(), this.sakaiFacade.getCurrentLocationId(), oneMeeting)) throw new PermissionException(this.sakaiFacade.getCurrentUserId(), "signup.update", "SignupTool");
            this.signupMeetingDao.updateMeetings(meetings);
            return;
        }
        if (isOrganizer) {
            if (!permission.isUpdate()) throw new PermissionException(this.sakaiFacade.getCurrentUserId(), "signup.update", "SignupTool");
            this.signupMeetingDao.updateMeetings(meetings);
            return;
        } else {
            if (!permission.isAttend()) throw new PermissionException(this.sakaiFacade.getCurrentUserId(), "signup.attend", "SignupTool");
            this.signupMeetingDao.updateMeetings(meetings);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateModifiedMeetings(List<SignupMeeting> meetings, List<SignupTimeslot> removedTimeslots, boolean isOrganizer) throws Exception {
        if (meetings == null || meetings.isEmpty()) {
            return;
        }
        SignupMeeting oneMeeting = meetings.get(0);
        Permission permission = oneMeeting.getPermission();
        if (permission == null) {
            if (!this.isAllowToUpdate(this.sakaiFacade.getCurrentUserId(), this.sakaiFacade.getCurrentLocationId(), oneMeeting)) throw new PermissionException(this.sakaiFacade.getCurrentUserId(), "signup.update", "SignupTool");
            this.signupMeetingDao.updateModifiedMeetings(meetings, removedTimeslots);
            return;
        }
        if (isOrganizer) {
            if (!permission.isUpdate()) throw new PermissionException(this.sakaiFacade.getCurrentUserId(), "signup.update", "SignupTool");
            this.signupMeetingDao.updateModifiedMeetings(meetings, removedTimeslots);
            return;
        } else {
            if (!permission.isAttend()) throw new PermissionException(this.sakaiFacade.getCurrentUserId(), "signup.attend", "SignupTool");
            this.signupMeetingDao.updateModifiedMeetings(meetings, removedTimeslots);
        }
    }

    public SignupMeeting loadSignupMeeting(Long meetingId, String userId, String siteId) {
        SignupMeeting meeting = this.signupMeetingDao.loadSignupMeeting(meetingId);
        ArrayList<SignupMeeting> temp = new ArrayList<SignupMeeting>();
        temp.add(meeting);
        this.updatePermissions(userId, siteId, temp);
        return meeting;
    }

    public SignupTargetSiteEventInfo loadSignupMeetingWithAutoSelectedSite(Long meetingId, String userId, String siteId) {
        SignupMeeting meeting = this.signupMeetingDao.loadSignupMeeting(meetingId);
        String sId = this.assignPermission(userId, siteId, meeting);
        SignupTargetSiteEventInfo defaultSiteEvent = new SignupTargetSiteEventInfo(meeting, sId);
        return defaultSiteEvent;
    }

    public void postToCalendar(SignupMeeting meeting) throws Exception {
        this.modifyCalendar(meeting);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyCalendar(SignupMeeting meeting) throws Exception {
        boolean hasMulptleBlock;
        List signupSites = meeting.getSignupSites();
        boolean saveMeeting = false;
        List<SignupTimeslot> calendarBlocks = this.scanDivideCalendarBlocks(meeting);
        boolean bl = hasMulptleBlock = calendarBlocks.size() > 1;
        if (meeting.getPermission() != null && meeting.getPermission().isUpdate() && "custom_ts".equals(meeting.getMeetingType())) {
            ArrayList<SignupMeeting> smList = new ArrayList<SignupMeeting>();
            smList.add(meeting);
            this.removeCalendarEvents(smList);
        }
        int sequence = 1;
        boolean firstBlockLoop = true;
        int calBlock = 0;
        for (SignupTimeslot calendarBlock : calendarBlocks) {
            for (SignupSite site : signupSites) {
                try {
                    boolean isNew;
                    CalendarEventEdit eventEdit;
                    Calendar calendar;
                    block24: {
                        calendar = this.chooseCalendar(site);
                        if (calendar == null) continue;
                        String eventId = null;
                        if (site.isSiteScope()) {
                            eventId = site.getCalendarEventId();
                        } else {
                            List signupGroups = site.getSignupGroups();
                            Iterator iterator = signupGroups.iterator();
                            if (iterator.hasNext()) {
                                SignupGroup group = (SignupGroup)iterator.next();
                                eventId = group.getCalendarEventId();
                            }
                        }
                        eventEdit = null;
                        if (meeting.getPermission() != null && !meeting.getPermission().isUpdate() && "custom_ts".equals(meeting.getMeetingType())) {
                            eventId = this.retrieveCustomCalendarEventId(calBlock, eventId);
                        } else if ("custom_ts".equals(meeting.getMeetingType())) {
                            eventId = null;
                        }
                        isNew = true;
                        if (eventId != null && eventId.trim().length() > 1) {
                            SecurityAdvisor advisor = this.sakaiFacade.pushAllowCalendarEdit(calendar);
                            try {
                                eventEdit = calendar.getEditEvent(eventId, "calendar.revise");
                                isNew = false;
                                if (!calendar.allowEditEvent(eventId)) {
                                    continue;
                                }
                                break block24;
                            }
                            catch (IdUnusedException e) {
                                log.debug((Object)("IdUnusedException: " + e.getMessage()));
                                eventEdit = this.calendarEvent(calendar, meeting, site);
                                break block24;
                            }
                            finally {
                                this.sakaiFacade.popSecurityAdvisor(advisor);
                                continue;
                            }
                        }
                        eventEdit = this.calendarEvent(calendar, meeting, site);
                    }
                    if (eventEdit == null) continue;
                    String title_suffix = "";
                    if (hasMulptleBlock) {
                        title_suffix = " (part " + sequence + ")";
                        ++sequence;
                    }
                    this.populateDataForEventEditObject(eventEdit, meeting, title_suffix, calendarBlock.getStartTime(), calendarBlock.getEndTime());
                    calendar.commitEvent(eventEdit);
                    if (!isNew) continue;
                    saveMeeting = true;
                    if (site.isSiteScope()) {
                        if (firstBlockLoop) {
                            site.setCalendarEventId(eventEdit.getId());
                            site.setCalendarId(calendar.getId());
                            continue;
                        }
                        String lastEventId = site.getCalendarEventId();
                        site.setCalendarEventId(lastEventId + "|" + eventEdit.getId());
                        continue;
                    }
                    List signupGroups = site.getSignupGroups();
                    for (SignupGroup group : signupGroups) {
                        if (firstBlockLoop) {
                            group.setCalendarEventId(eventEdit.getId());
                            group.setCalendarId(calendar.getId());
                            continue;
                        }
                        String lastEventId = group.getCalendarEventId();
                        group.setCalendarEventId(lastEventId + "|" + eventEdit.getId());
                    }
                }
                catch (PermissionException pe) {
                    log.info((Object)("PermissionException for calendar-modification: " + pe.getMessage()));
                    throw pe;
                }
            }
            firstBlockLoop = false;
            ++calBlock;
        }
        if (saveMeeting) {
            this.updateMeetingWithVersionHandling(meeting);
        }
    }

    private void populateDataForEventEditObject(CalendarEventEdit eventEdit, SignupMeeting meeting, String title_suffix, Date startTime, Date endTime) {
        TimeService timeService = this.getSakaiFacade().getTimeService();
        Time start = timeService.newTime(startTime.getTime());
        Time end = timeService.newTime(endTime.getTime());
        TimeRange timeRange = timeService.newTimeRange(start, end, true, false);
        eventEdit.setRange(timeRange);
        String attendeeNamesMarkup = "";
        int num = 0;
        if (meeting.getSignupTimeSlots().size() > 0) {
            attendeeNamesMarkup = attendeeNamesMarkup + "<br /><br /><span style=\"font-weight: bold\"><b>Attendees:</b></span><br />";
        }
        boolean displayAttendeeName = false;
        for (SignupTimeslot ts : meeting.getSignupTimeSlots()) {
            displayAttendeeName = ts.isDisplayAttendees();
            if (startTime.getTime() > ts.getStartTime().getTime() || endTime.getTime() < ts.getEndTime().getTime()) continue;
            num += ts.getAttendees().size();
            if (!ts.isDisplayAttendees() || ts.getAttendees().isEmpty()) continue;
            for (SignupAttendee attendee : ts.getAttendees()) {
                attendeeNamesMarkup = attendeeNamesMarkup + "<span style=\"font-weight: italic\"><i>" + this.sakaiFacade.getUserDisplayName(attendee.getAttendeeUserId()) + "</i></span><br />";
            }
        }
        if (!displayAttendeeName || num < 1) {
            attendeeNamesMarkup = attendeeNamesMarkup + "<span style=\"font-weight: italic\"><i> Currently, " + num + " attendees have been signed up.</i></span><br />";
        }
        String desc = meeting.getDescription() + attendeeNamesMarkup;
        eventEdit.setDescription(PlainTextFormat.convertFormattedHtmlTextToPlaintext(desc));
        eventEdit.setLocation(meeting.getLocation());
        eventEdit.setDisplayName(meeting.getTitle() + title_suffix + " (" + num + " attendees)");
        eventEdit.setRange(timeRange);
    }

    private String retrieveCustomCalendarEventId(int blockNum, String eventIds) {
        StringTokenizer token = new StringTokenizer(eventIds, "|");
        int index = 0;
        while (token.hasMoreTokens()) {
            if (blockNum == index++) {
                return token.nextToken().trim();
            }
            token.nextToken();
        }
        return null;
    }

    private boolean hasMeetingWithMultipleCalendarBlocks(SignupMeeting meeting) {
        if (!"custom_ts".equals(meeting.getMeetingType())) {
            return false;
        }
        boolean hasMultipleBlocks = false;
        List sites = meeting.getSignupSites();
        if (sites == null || sites.isEmpty()) {
            return false;
        }
        for (SignupSite site : sites) {
            String eventId = null;
            if (site.isSiteScope()) {
                eventId = site.getCalendarEventId();
                if (eventId == null || !eventId.contains("|")) continue;
                return true;
            }
            List signupGroups = site.getSignupGroups();
            for (SignupGroup group : signupGroups) {
                eventId = group.getCalendarEventId();
                if (eventId == null || !eventId.contains("|")) continue;
                return true;
            }
        }
        return hasMultipleBlocks;
    }

    private List<SignupTimeslot> scanDivideCalendarBlocks(SignupMeeting meeting) {
        int timeApart = 0x6DDD00;
        ArrayList<SignupTimeslot> tsList = new ArrayList<SignupTimeslot>();
        if ("custom_ts".equals(meeting.getMeetingType()) && (meeting.isInMultipleCalendarBlocks() || this.hasMeetingWithMultipleCalendarBlocks(meeting))) {
            List tsLs = meeting.getSignupTimeSlots();
            if (tsLs != null && !tsLs.isEmpty()) {
                Date startTime = ((SignupTimeslot)tsLs.get(0)).getStartTime();
                int cursor = 0;
                for (int i = 0; i < tsLs.size() - 1; ++i) {
                    long nextBlockStartTime;
                    long firstBlockEndTime = ((SignupTimeslot)tsLs.get(cursor)).getEndTime().getTime();
                    long secondBlockEndTime = ((SignupTimeslot)tsLs.get(i + 1)).getEndTime().getTime();
                    if (secondBlockEndTime - firstBlockEndTime >= 0L) {
                        cursor = i + 1;
                    }
                    if ((nextBlockStartTime = ((SignupTimeslot)tsLs.get(i + 1)).getStartTime().getTime()) - firstBlockEndTime <= 0x6DDD00L) continue;
                    SignupTimeslot newTs = new SignupTimeslot();
                    newTs.setStartTime(startTime);
                    newTs.setEndTime(((SignupTimeslot)tsLs.get(i)).getEndTime());
                    tsList.add(newTs);
                    startTime = ((SignupTimeslot)tsLs.get(i + 1)).getStartTime();
                }
                SignupTimeslot newTs = new SignupTimeslot();
                newTs.setStartTime(startTime);
                newTs.setEndTime(meeting.getEndTime());
                tsList.add(newTs);
            }
        } else {
            SignupTimeslot newTs = new SignupTimeslot();
            newTs.setStartTime(meeting.getStartTime());
            newTs.setEndTime(meeting.getEndTime());
            tsList.add(newTs);
        }
        return tsList;
    }

    public void removeCalendarEvents(List<SignupMeeting> meetings) throws Exception {
        if (meetings == null || meetings.isEmpty()) {
            return;
        }
        for (SignupMeeting meeting : meetings) {
            List sites = meeting.getSignupSites();
            if (sites == null || sites.isEmpty()) continue;
            for (SignupSite site : sites) {
                try {
                    Calendar calendar = this.chooseCalendar(site);
                    if (calendar == null) continue;
                    String eventIds = null;
                    if (site.isSiteScope()) {
                        eventIds = site.getCalendarEventId();
                    } else {
                        List signupGroups = site.getSignupGroups();
                        Iterator iterator = signupGroups.iterator();
                        if (iterator.hasNext()) {
                            SignupGroup group = (SignupGroup)iterator.next();
                            eventIds = group.getCalendarEventId();
                        }
                    }
                    if (eventIds == null || eventIds.trim().length() < 1) continue;
                    StringTokenizer token = new StringTokenizer(eventIds, "|");
                    ArrayList<String> evtIds = new ArrayList<String>();
                    while (token.hasMoreTokens()) {
                        evtIds.add(token.nextToken().trim());
                    }
                    for (String evtId : evtIds) {
                        CalendarEventEdit eventEdit = calendar.getEditEvent(evtId, "calendar.delete");
                        if (eventEdit == null || !calendar.allowEditEvent(evtId)) continue;
                        calendar.removeEvent(eventEdit);
                    }
                }
                catch (PermissionException e) {
                    log.info((Object)("PermissionException for removal of calendar: " + e.getMessage()));
                }
            }
        }
    }

    private Calendar chooseCalendar(SignupSite site) throws PermissionException {
        Calendar calendar = this.sakaiFacade.getAdditionalCalendar(site.getSiteId());
        if (calendar == null) {
            calendar = this.sakaiFacade.getCalendar(site.getSiteId());
        }
        return calendar;
    }

    public void removeCalendarEventsOnModifiedMeeting(List<SignupMeeting> meetings) throws Exception {
        try {
            this.removeCalendarEvents(meetings);
            for (SignupMeeting sm : meetings) {
                List sites = sm.getSignupSites();
                if (sites != null && !sites.isEmpty()) {
                    for (SignupSite s : sites) {
                        List grps;
                        if (s.getCalendarEventId() != null) {
                            s.setCalendarEventId(null);
                            s.setCalendarId(null);
                        }
                        if ((grps = s.getSignupGroups()) == null || grps.isEmpty()) continue;
                        for (SignupGroup g : grps) {
                            if (g.getCalendarEventId() == null) continue;
                            g.setCalendarEventId(null);
                            g.setCalendarId(null);
                        }
                    }
                }
                this.updateMeetingWithVersionHandling(sm);
            }
        }
        catch (Exception e) {
            log.warn((Object)("Exception for removal of calendar and calendar info may not be removed from events objects: " + e.getMessage()));
        }
    }

    private CalendarEventEdit calendarEvent(Calendar calendar, SignupMeeting meeting, SignupSite site) throws IdUnusedException, PermissionException {
        CalendarEventEdit addEvent = calendar.addEvent();
        addEvent.setType("Meeting");
        if (!site.isSiteScope()) {
            List<Group> groups = this.groupIds(site);
            addEvent.setGroupAccess(groups, true);
        }
        return addEvent;
    }

    private void updateMeetingWithVersionHandling(SignupMeeting meeting) throws Exception {
        for (int i = 0; i < 10; ++i) {
            try {
                this.updateSignupMeeting(meeting, true);
                return;
            }
            catch (OptimisticLockingFailureException optimisticLockingFailureException) {
                continue;
            }
        }
        throw new SignupUserActionException("Some one updated the meeting before your update. Please try again.");
    }

    private List<Group> groupIds(SignupSite site) {
        ArrayList<Group> groups = new ArrayList<Group>();
        List signupGroups = site.getSignupGroups();
        for (SignupGroup group : signupGroups) {
            try {
                groups.add(this.sakaiFacade.getGroup(site.getSiteId(), group.getGroupId()));
            }
            catch (IdUnusedException e) {
                log.info((Object)("IdUnusedException: " + e.getMessage()));
            }
        }
        return groups;
    }

    public void sendEmail(SignupMeeting signupMeeting, String messageType) throws Exception {
        this.signupEmailFacade.sendEmailAllUsers(signupMeeting, messageType);
    }

    public void sendEmailToOrganizer(SignupEventTrackingInfo signupEventTrackingInfo) throws Exception {
        this.signupEmailFacade.sendEmailToOrganizer(signupEventTrackingInfo);
    }

    public void sendCancellationEmail(SignupEventTrackingInfo signupEventTrackingInfo) throws Exception {
        this.signupEmailFacade.sendCancellationEmail(signupEventTrackingInfo);
    }

    public void sendUpdateCommentEmail(SignupEventTrackingInfo signupEventTrackingInfo) throws Exception {
        this.signupEmailFacade.sendUpdateCommentEmail(signupEventTrackingInfo);
    }

    public void removeMeetings(List<SignupMeeting> meetings) throws Exception {
        this.signupMeetingDao.removeMeetings(meetings);
        for (SignupMeeting m : meetings) {
            if (m.isMeetingExpired()) continue;
            log.info((Object)"Meeting is still available, email notifications will be sent");
            m.setSendEmailToSelectedPeopleOnly("signup_only");
            this.signupEmailFacade.sendEmailAllUsers(m, "signup.email.cancel.meeting");
        }
    }

    public void sendEmailToParticipantsByOrganizerAction(SignupEventTrackingInfo signupEventTrackingInfo) throws Exception {
        this.signupEmailFacade.sendEmailToParticipantsByOrganizerAction(signupEventTrackingInfo);
    }

    public boolean isEventExisted(Long eventId) {
        return this.signupMeetingDao.isEventExisted(eventId);
    }

    public void sendEmailToAttendee(SignupEventTrackingInfo signupEventTrackingInfo) throws Exception {
        this.signupEmailFacade.sendEmailToAttendee(signupEventTrackingInfo);
    }

    public List<String> getAllLocations(String siteId) throws Exception {
        return this.signupMeetingDao.getAllLocations(siteId);
    }

    public List<String> getAllCategories(String siteId) throws Exception {
        return this.signupMeetingDao.getAllCategories(siteId);
    }

    public SignupMeetingDao getSignupMeetingDao() {
        return this.signupMeetingDao;
    }

    public void setSignupMeetingDao(SignupMeetingDao signupMeetingDao) {
        this.signupMeetingDao = signupMeetingDao;
    }

    public SakaiFacade getSakaiFacade() {
        return this.sakaiFacade;
    }

    public void setSakaiFacade(SakaiFacade sakaiFacade) {
        this.sakaiFacade = sakaiFacade;
    }

    public SignupCacheService getSignupCacheService() {
        return this.signupCacheService;
    }

    public void setSignupCacheService(SignupCacheService signupCacheService) {
        this.signupCacheService = signupCacheService;
    }

    public SignupEmailFacade getSignupEmailFacade() {
        return this.signupEmailFacade;
    }

    public void setSignupEmailFacade(SignupEmailFacade signupEmailFacade) {
        this.signupEmailFacade = signupEmailFacade;
    }
}

