/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.dao;

import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.sakaiproject.genericdao.hibernate.HibernateGeneralGenericDao;
import org.sakaiproject.signup.dao.SignupMeetingDao;
import org.sakaiproject.signup.model.SignupMeeting;
import org.sakaiproject.signup.model.SignupTimeslot;
import org.springframework.dao.DataAccessException;

public class SignupMeetingDaoImpl
extends HibernateGeneralGenericDao
implements SignupMeetingDao {
    private static Log log = LogFactory.getLog(SignupMeetingDaoImpl.class);

    public void init() {
        log.debug((Object)"init");
    }

    @Override
    public List<SignupMeeting> getAllSignupMeetings(String siteId) {
        DetachedCriteria criteria = DetachedCriteria.forClass(SignupMeeting.class).addOrder(Order.asc((String)"startTime")).setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY).createCriteria("signupSites").add((Criterion)Restrictions.eq((String)"siteId", (Object)siteId));
        return this.getHibernateTemplate().findByCriteria(criteria);
    }

    @Override
    public List<SignupMeeting> getSignupMeetings(String siteId, Date searchEndDate) {
        DetachedCriteria criteria = DetachedCriteria.forClass(SignupMeeting.class).add((Criterion)Restrictions.le((String)"startTime", (Object)searchEndDate)).addOrder(Order.asc((String)"startTime")).createCriteria("signupSites").add((Criterion)Restrictions.eq((String)"siteId", (Object)siteId));
        return this.getHibernateTemplate().findByCriteria(criteria);
    }

    @Override
    public List<SignupMeeting> getSignupMeetings(String siteId, Date startDate, Date endDate) {
        DetachedCriteria criteria = DetachedCriteria.forClass(SignupMeeting.class).setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY).add((Criterion)Restrictions.ge((String)"endTime", (Object)startDate)).add((Criterion)Restrictions.lt((String)"startTime", (Object)endDate)).addOrder(Order.asc((String)"startTime")).createCriteria("signupSites").add((Criterion)Restrictions.eq((String)"siteId", (Object)siteId));
        return this.getHibernateTemplate().findByCriteria(criteria);
    }

    @Override
    public List<SignupMeeting> getSignupMeetingsInSite(String siteId, Date startDate, Date endDate) {
        DetachedCriteria criteria = DetachedCriteria.forClass(SignupMeeting.class).setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY).add((Criterion)Restrictions.ge((String)"endTime", (Object)startDate)).add((Criterion)Restrictions.lt((String)"startTime", (Object)endDate)).addOrder(Order.asc((String)"startTime")).createCriteria("signupSites").add((Criterion)Restrictions.eq((String)"siteId", (Object)siteId));
        return this.getHibernateTemplate().findByCriteria(criteria);
    }

    @Override
    public List<SignupMeeting> getSignupMeetingsInSites(List<String> siteIds, Date startDate, Date endDate) {
        DetachedCriteria criteria = DetachedCriteria.forClass(SignupMeeting.class).setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY).add((Criterion)Restrictions.ge((String)"endTime", (Object)startDate)).add((Criterion)Restrictions.lt((String)"startTime", (Object)endDate)).addOrder(Order.asc((String)"startTime")).createCriteria("signupSites").add(Restrictions.in((String)"siteId", siteIds));
        return this.getHibernateTemplate().findByCriteria(criteria);
    }

    @Override
    public List<SignupMeeting> getRecurringSignupMeetings(String siteId, Long recurrenceId, Date currentTime) {
        DetachedCriteria criteria = DetachedCriteria.forClass(SignupMeeting.class).setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY).add((Criterion)Restrictions.eq((String)"recurrenceId", (Object)recurrenceId)).add((Criterion)Restrictions.gt((String)"endTime", (Object)currentTime)).addOrder(Order.asc((String)"startTime")).createCriteria("signupSites").add((Criterion)Restrictions.eq((String)"siteId", (Object)siteId));
        return this.getHibernateTemplate().findByCriteria(criteria);
    }

    @Override
    public Long saveMeeting(SignupMeeting signupMeeting) {
        return (Long)this.getHibernateTemplate().save((Object)signupMeeting);
    }

    @Override
    public void saveMeetings(List<SignupMeeting> signupMeetings) {
        if (signupMeetings != null && signupMeetings.size() > 0) {
            SignupMeeting sm = signupMeetings.get(0);
            if (sm.isRecurredMeeting()) {
                Long reRecurId = (Long)this.getHibernateTemplate().save((Object)sm);
                for (SignupMeeting sMeeting : signupMeetings) {
                    sMeeting.setRecurrenceId(reRecurId);
                }
            }
            for (SignupMeeting signupMeeting : signupMeetings) {
                this.getHibernateTemplate().saveOrUpdate((Object)signupMeeting);
            }
        }
    }

    @Override
    public SignupMeeting loadSignupMeeting(Long meetingId) {
        DetachedCriteria criteria = DetachedCriteria.forClass(SignupMeeting.class).setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY).add((Criterion)Restrictions.eq((String)"id", (Object)meetingId));
        List ls = this.getHibernateTemplate().findByCriteria(criteria);
        if (ls == null || ls.isEmpty()) {
            return null;
        }
        return (SignupMeeting)ls.get(0);
    }

    @Override
    public void updateMeeting(SignupMeeting meeting) throws DataAccessException {
        this.getHibernateTemplate().update((Object)meeting);
    }

    @Override
    public void updateMeetings(List<SignupMeeting> meetings) throws DataAccessException {
        for (SignupMeeting meeting : meetings) {
            this.getHibernateTemplate().saveOrUpdate((Object)meeting);
        }
    }

    @Override
    public void updateModifiedMeetings(List<SignupMeeting> meetings, List<SignupTimeslot> removedTimeslots) throws DataAccessException {
        for (SignupMeeting meeting : meetings) {
            this.getHibernateTemplate().saveOrUpdate((Object)meeting);
        }
        if (removedTimeslots != null && removedTimeslots.size() > 0) {
            for (SignupTimeslot ts : removedTimeslots) {
                long tsId = ts.getId();
                SignupTimeslot sTimeslot = this.loadSignupTimeslot(tsId);
                this.getHibernateTemplate().delete((Object)sTimeslot);
            }
        }
    }

    private SignupTimeslot loadSignupTimeslot(Long timeslotId) {
        DetachedCriteria criteria = DetachedCriteria.forClass(SignupTimeslot.class).setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY).add((Criterion)Restrictions.eq((String)"id", (Object)timeslotId));
        List ls = this.getHibernateTemplate().findByCriteria(criteria);
        if (ls == null || ls.isEmpty()) {
            return null;
        }
        return (SignupTimeslot)ls.get(0);
    }

    @Override
    public void removeMeetings(List<SignupMeeting> meetings) {
        this.getHibernateTemplate().deleteAll(meetings);
    }

    @Override
    public boolean isEventExisted(Long eventId) {
        SignupMeeting ls = this.loadSignupMeeting(eventId);
        return ls != null;
    }

    @Override
    public int getAutoReminderTotalEventCounts(Date startDate, Date endDate) {
        DetachedCriteria criteria = DetachedCriteria.forClass(SignupMeeting.class).setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY).add((Criterion)Restrictions.eq((String)"autoReminder", (Object)true)).add(Restrictions.between((String)"startTime", (Object)startDate, (Object)endDate)).setProjection(Projections.rowCount());
        List ls = this.getHibernateTemplate().findByCriteria(criteria);
        if (ls == null || ls.isEmpty()) {
            return 0;
        }
        Integer rowCount = (Integer)ls.get(0);
        return rowCount != null ? rowCount : 0;
    }

    @Override
    public List<SignupMeeting> getAutoReminderSignupMeetings(Date startDate, Date endDate) {
        DetachedCriteria criteria = DetachedCriteria.forClass(SignupMeeting.class).setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY).add((Criterion)Restrictions.eq((String)"autoReminder", (Object)true)).add((Criterion)Restrictions.le((String)"startTime", (Object)endDate)).add((Criterion)Restrictions.ge((String)"endTime", (Object)startDate)).addOrder(Order.asc((String)"startTime"));
        return this.getHibernateTemplate().findByCriteria(criteria);
    }

    @Override
    public List<String> getAllCategories(String siteId) throws DataAccessException {
        DetachedCriteria criteria = DetachedCriteria.forClass(SignupMeeting.class).setProjection(Projections.distinct((Projection)Projections.projectionList().add((Projection)Projections.property((String)"category"), "category"))).setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY).addOrder(Order.asc((String)"category")).createCriteria("signupSites").add((Criterion)Restrictions.eq((String)"siteId", (Object)siteId));
        List categorys = this.getHibernateTemplate().findByCriteria(criteria);
        if (categorys != null && !categorys.isEmpty()) {
            return categorys;
        }
        return null;
    }

    @Override
    public List<String> getAllLocations(String siteId) throws DataAccessException {
        DetachedCriteria criteria = DetachedCriteria.forClass(SignupMeeting.class).setProjection(Projections.distinct((Projection)Projections.projectionList().add((Projection)Projections.property((String)"location"), "location"))).setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY).addOrder(Order.asc((String)"location")).createCriteria("signupSites").add((Criterion)Restrictions.eq((String)"siteId", (Object)siteId));
        List locations = this.getHibernateTemplate().findByCriteria(criteria);
        if (locations != null && !locations.isEmpty()) {
            return locations;
        }
        return null;
    }
}

