/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.logic.messages;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sakaiproject.signup.logic.SakaiFacade;
import org.sakaiproject.signup.logic.messages.SignupEmailBase;
import org.sakaiproject.signup.model.SignupMeeting;
import org.sakaiproject.signup.model.SignupTimeslot;
import org.sakaiproject.user.api.User;

public class OrganizerPreAssignEmail
extends SignupEmailBase {
    private final User organizer;
    private final SignupTimeslot timeslot;
    private final User user;
    private final String emailReturnSiteId;

    public OrganizerPreAssignEmail(User currentUser, SignupMeeting signupMeeting, SignupTimeslot timeslot, User user, SakaiFacade sakaiFacade, String emailReturnSiteId) {
        this.organizer = currentUser;
        this.meeting = signupMeeting;
        this.timeslot = timeslot;
        this.user = user;
        this.emailReturnSiteId = emailReturnSiteId;
        this.setSakaiFacade(sakaiFacade);
    }

    @Override
    public List<String> getHeader() {
        ArrayList<String> rv = new ArrayList<String>();
        rv.add("Content-Type: text/html; charset=UTF-8");
        rv.add("Subject: " + this.getSubject());
        rv.add("From: " + this.getFromAddress());
        rv.add("To: " + this.getSakaiFacade().getServerConfigurationService().getString("setup.request", "no-reply@" + this.getSakaiFacade().getServerConfigurationService().getServerName()));
        return rv;
    }

    @Override
    public String getMessage() {
        StringBuilder message = new StringBuilder();
        message.append(MessageFormat.format(rb.getString("body.top.greeting.part"), this.makeFirstCapLetter(this.user.getDisplayName())));
        Object[] params = new Object[]{this.getSiteTitleWithQuote(this.emailReturnSiteId), this.getServiceName(), this.organizer.getDisplayName()};
        message.append("<BR>\r\n<BR>\r\n" + MessageFormat.format(rb.getString("body.organizerPreAssign.appointment.part"), params));
        message.append("<BR>\r\n<BR>\r\n" + MessageFormat.format(rb.getString("body.meetingTopic.part"), this.meeting.getTitle()));
        if (!this.meeting.isMeetingCrossDays()) {
            Object[] paramsTimeframe = new Object[]{this.getTime(this.timeslot.getStartTime()).toStringLocalTime(), this.getTime(this.timeslot.getEndTime()).toStringLocalTime(), this.getTime(this.timeslot.getStartTime()).toStringLocalDate(), this.getSakaiFacade().getTimeService().getLocalTimeZone().getID()};
            message.append("<BR>\r\n" + MessageFormat.format(rb.getString("body.organizer.preassigned.attendee.meeting.timeframe"), paramsTimeframe));
        } else {
            Object[] paramsTimeframe1 = new Object[]{this.getTime(this.timeslot.getStartTime()).toStringLocalTime(), this.getTime(this.timeslot.getStartTime()).toStringLocalShortDate(), this.getTime(this.timeslot.getEndTime()).toStringLocalTime(), this.getTime(this.timeslot.getEndTime()).toStringLocalShortDate(), this.getSakaiFacade().getTimeService().getLocalTimeZone().getID()};
            message.append("<BR>\r\n" + MessageFormat.format(rb.getString("body.organizer.preassigned.attendee.meeting.crossdays.timeframe"), paramsTimeframe1));
        }
        message.append("<BR>\r\n" + rb.getString("body.meeting.place") + " " + this.meeting.getLocation());
        if (this.meeting.isRecurredMeeting()) {
            message.append("<BR>\r\n" + rb.getString("body.meeting.recurrence") + " ");
            String recurFrqs = this.getRepeatTypeMessage(this.meeting);
            Object[] paramsRecur = new Object[]{recurFrqs, this.getTime(this.meeting.getRepeatUntil()).toStringLocalDate()};
            message.append(MessageFormat.format(rb.getString("body.recurrence.meeting.status"), paramsRecur));
            if (this.meeting.isApplyToAllRecurMeetings()) {
                message.append("<BR>\r\n<BR>\r\n" + rb.getString("body.meeting.assigned.all.recurringMeetings"));
            } else {
                message.append("<BR>\r\n<BR>\r\n" + rb.getString("body.meeting.assigned.to.firstOne.recurringMeetings"));
            }
        }
        message.append("<BR>\r\n<BR>\r\n" + this.meeting.getDescription());
        message.append("<BR>\r\n<BR>\r\n" + MessageFormat.format(rb.getString("body.attendeeCheck.meetingStatus"), this.getServiceName()));
        message.append("<BR>\r\n" + this.getFooter("<BR>\r\n", this.emailReturnSiteId));
        return message.toString();
    }

    @Override
    public String getFromAddress() {
        return StringUtils.defaultIfEmpty((String)this.organizer.getEmail(), (String)this.getServerFromAddress());
    }

    @Override
    public String getSubject() {
        return MessageFormat.format(rb.getString("subject.organizerPreAssign.appointment.field"), this.organizer.getDisplayName(), this.getTime(this.meeting.getStartTime()).toStringLocalDate(), this.getAbbreviatedMeetingTitle());
    }
}

