/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.logic.messages;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.sakaiproject.signup.logic.SakaiFacade;
import org.sakaiproject.signup.logic.SignupTrackingItem;
import org.sakaiproject.signup.logic.messages.SignupEmailBase;
import org.sakaiproject.signup.logic.messages.SignupTimeslotChanges;
import org.sakaiproject.signup.model.SignupMeeting;
import org.sakaiproject.signup.model.SignupTimeslot;
import org.sakaiproject.user.api.User;

public class CancellationEmail
extends SignupEmailBase
implements SignupTimeslotChanges {
    private final SignupTrackingItem item;
    private final User attendee;
    private String organizer;
    private String emailReturnSiteId;
    private List<SignupTimeslot> removed;

    public CancellationEmail(User attendee, SignupTrackingItem item, SignupMeeting meeting, SakaiFacade sakaiFacade) {
        this.attendee = attendee;
        this.item = item;
        this.meeting = meeting;
        this.setSakaiFacade(sakaiFacade);
        this.emailReturnSiteId = item.getAttendee().getSignupSiteId();
        this.removed = item.getRemovedFromTimeslot();
    }

    public CancellationEmail(User organizer, User attendee, SignupTrackingItem item, SignupMeeting meeting, SakaiFacade sakaiFacade) {
        this.attendee = attendee;
        this.organizer = organizer.getDisplayName();
        this.item = item;
        this.meeting = meeting;
        this.setSakaiFacade(sakaiFacade);
        this.emailReturnSiteId = item.getAttendee().getSignupSiteId();
        this.removed = item.getRemovedFromTimeslot();
    }

    @Override
    public List<String> getHeader() {
        ArrayList<String> rv = new ArrayList<String>();
        rv.add("Content-Type: text/html; charset=UTF-8");
        rv.add("Subject: " + this.getSubject());
        rv.add("From: " + this.getServerFromAddress());
        rv.add("To: " + this.attendee.getEmail());
        return rv;
    }

    @Override
    public String getMessage() {
        StringBuilder message = new StringBuilder();
        message.append(MessageFormat.format(rb.getString("body.top.greeting.part"), this.makeFirstCapLetter(this.attendee.getDisplayName())));
        Object[] params = new Object[]{this.makeFirstCapLetter(this.getOrganizer()), this.getSiteTitleWithQuote(this.emailReturnSiteId), this.getServiceName()};
        message.append("<BR>\r\n<BR>\r\n" + MessageFormat.format(rb.getString("body.organizerCancel.appointment.part"), params));
        message.append("<BR>\r\n<BR>\r\n" + MessageFormat.format(rb.getString("body.meetingTopic.part"), this.meeting.getTitle()));
        message.append("<BR>\r\n" + rb.getString("body.timeslot") + " ");
        List removedFromTimeslots = this.item.getRemovedFromTimeslot();
        if (!removedFromTimeslots.isEmpty()) {
            for (SignupTimeslot timeslot : removedFromTimeslots) {
                Object[] paramsTimeframe;
                if (!this.meeting.isMeetingCrossDays()) {
                    paramsTimeframe = new Object[]{this.getTime(timeslot.getStartTime()).toStringLocalTime(), this.getTime(timeslot.getEndTime()).toStringLocalTime(), this.getTime(timeslot.getStartTime()).toStringLocalDate(), this.getSakaiFacade().getTimeService().getLocalTimeZone().getID()};
                    message.append(MessageFormat.format(rb.getString("body.meeting.timeslot.timeframe"), paramsTimeframe) + "<BR>\r\n");
                    continue;
                }
                paramsTimeframe = new Object[]{this.getTime(timeslot.getStartTime()).toStringLocalTime(), this.getTime(timeslot.getStartTime()).toStringLocalShortDate(), this.getTime(timeslot.getEndTime()).toStringLocalTime(), this.getTime(timeslot.getEndTime()).toStringLocalShortDate(), this.getSakaiFacade().getTimeService().getLocalTimeZone().getID()};
                message.append(MessageFormat.format(rb.getString("body.meeting.crossdays.timeslot.timeframe"), paramsTimeframe) + "<BR>\r\n");
            }
        }
        message.append("<BR>\r\n<BR>\r\n" + MessageFormat.format(rb.getString("body.attendeeCheck.meetingStatus.B"), this.getServiceName()));
        message.append("<BR>\r\n" + this.getFooter("<BR>\r\n", this.emailReturnSiteId));
        return message.toString();
    }

    private String getOrganizer() {
        if (this.organizer == null || this.organizer.length() < 1) {
            this.setOrganizer(this.getSakaiFacade().getUserDisplayName(this.meeting.getCreatorUserId()));
        }
        return this.organizer;
    }

    private void setOrganizer(String organizer) {
        this.organizer = organizer;
    }

    @Override
    public String getFromAddress() {
        return this.getServerFromAddress();
    }

    @Override
    public String getSubject() {
        return MessageFormat.format(rb.getString("subject.Cancel.appointment.field"), this.getTime(this.meeting.getStartTime()).toStringLocalDate(), this.getSakaiFacade().getUserDisplayName(this.meeting.getCreatorUserId()), this.getAbbreviatedMeetingTitle());
    }

    public List<SignupTimeslot> getRemoved() {
        return this.removed;
    }

    public List<SignupTimeslot> getAdded() {
        return Collections.EMPTY_LIST;
    }
}

