/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.logic.messages;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sakaiproject.signup.logic.SakaiFacade;
import org.sakaiproject.signup.logic.messages.SignupEmailBase;
import org.sakaiproject.signup.model.SignupMeeting;
import org.sakaiproject.signup.model.SignupTimeslot;
import org.sakaiproject.user.api.User;

public class NewMeetingEmail
extends SignupEmailBase {
    private final User creator;
    private String emailReturnSiteId;

    public NewMeetingEmail(User creator, SignupMeeting meeting, SakaiFacade sakaiFacade, String emailReturnSiteId) {
        this.creator = creator;
        this.meeting = meeting;
        this.setSakaiFacade(sakaiFacade);
        this.emailReturnSiteId = emailReturnSiteId;
    }

    @Override
    public List<String> getHeader() {
        ArrayList<String> rv = new ArrayList<String>();
        rv.add("Content-Type: text/html; charset=UTF-8");
        rv.add("Subject: " + this.getSubject());
        rv.add("From: " + this.getFromAddress());
        rv.add("To: " + rb.getString("noReply@") + this.getSakaiFacade().getServerConfigurationService().getServerName());
        return rv;
    }

    @Override
    public String getMessage() {
        StringBuilder message = new StringBuilder();
        Object[] params = new Object[]{this.getSiteTitleWithQuote(this.emailReturnSiteId), this.getServiceName(), this.makeFirstCapLetter(this.creator.getDisplayName())};
        message.append("<BR>\r\n" + MessageFormat.format(rb.getString("body.organizerCreate.meeting.announ"), params));
        message.append("<BR>\r\n<BR>\r\n" + MessageFormat.format(rb.getString("body.meetingTopic.part"), this.meeting.getTitle()));
        if (!this.meeting.isMeetingCrossDays()) {
            Object[] paramsTimeframe = new Object[]{this.getTime(this.meeting.getStartTime()).toStringLocalDate(), this.getTime(this.meeting.getStartTime()).toStringLocalTime(), this.getTime(this.meeting.getEndTime()).toStringLocalTime(), this.getSakaiFacade().getTimeService().getLocalTimeZone().getID()};
            message.append("<BR>\r\n" + MessageFormat.format(rb.getString("body.organizer.meeting.timeframe"), paramsTimeframe));
        } else {
            Object[] paramsTimeframe1 = new Object[]{this.getTime(this.meeting.getStartTime()).toStringLocalTime(), this.getTime(this.meeting.getStartTime()).toStringLocalShortDate(), this.getTime(this.meeting.getEndTime()).toStringLocalTime(), this.getTime(this.meeting.getEndTime()).toStringLocalShortDate(), this.getSakaiFacade().getTimeService().getLocalTimeZone().getID()};
            message.append("<BR>\r\n" + MessageFormat.format(rb.getString("body.organizer.meeting.crossdays.timeframe"), paramsTimeframe1));
        }
        message.append("<BR>\r\n" + rb.getString("body.meeting.place") + " " + this.meeting.getLocation());
        if (this.meeting.isRecurredMeeting()) {
            message.append("<BR>\r\n" + rb.getString("body.meeting.recurrence") + " ");
            String recurFrqs = this.getRepeatTypeMessage(this.meeting);
            Object[] paramsRecur = new Object[]{recurFrqs, this.getTime(this.meeting.getRepeatUntil()).toStringLocalDate()};
            message.append(MessageFormat.format(rb.getString("body.recurrence.meeting.status"), paramsRecur));
        }
        if (this.meeting.getMeetingType().equals("custom_ts")) {
            List tsList = this.meeting.getSignupTimeSlots();
            message.append("<BR>\r\n<BR>\r\n" + rb.getString("body.meeting.timeslot.detail.title"));
            if (tsList != null) {
                int i = 1;
                for (SignupTimeslot ts : tsList) {
                    Object[] oneTsDateParam;
                    if (!this.meeting.isMeetingCrossDays()) {
                        oneTsDateParam = new Object[]{this.getTime(ts.getStartTime()).toStringLocalTime(), this.getTime(ts.getEndTime()).toStringLocalTime()};
                        message.append("<BR>\r\n<BR>\r\n" + MessageFormat.format(rb.getString("body.attendee.custom.defined.meeting.timeslot"), i));
                        message.append("<BR>\r\n" + MessageFormat.format(rb.getString("body.attendee.custom.defined.meeting.timeslot.timeframe"), oneTsDateParam));
                        message.append("<BR>\r\n" + MessageFormat.format(rb.getString("body.attendee.custom.defined.meeting.timeslot.max.participants"), ts.getMaxNoOfAttendees()));
                        ++i;
                        continue;
                    }
                    oneTsDateParam = new Object[]{this.getTime(ts.getStartTime()).toStringLocalTime(), this.getTime(ts.getStartTime()).toStringLocalShortDate(), this.getTime(ts.getEndTime()).toStringLocalTime(), this.getTime(ts.getEndTime()).toStringLocalShortDate()};
                    message.append("<BR>\r\n<BR>\r\n" + MessageFormat.format(rb.getString("body.attendee.custom.defined.meeting.timeslot"), i));
                    message.append("<BR>\r\n" + MessageFormat.format(rb.getString("body.attendee.custom.defined.meeting.timeslot.timeframe.crossdays"), oneTsDateParam));
                    message.append("<BR>\r\n" + MessageFormat.format(rb.getString("body.attendee.custom.defined.meeting.timeslot.max.participants"), ts.getMaxNoOfAttendees()));
                    ++i;
                }
            }
        } else if (this.meeting.getMeetingType().equals("individual")) {
            Object[] params2 = new Object[]{this.meeting.getNoOfTimeSlots(), this.getTimeSlotLength(this.meeting), this.meeting.getMaxNumberOfAttendees()};
            message.append("<BR>\r\n<BR>\r\n" + MessageFormat.format(rb.getString("body.new.inidivual.type.message.detail"), params2));
        } else if (this.meeting.getMeetingType().equals("announcement")) {
            message.append("<BR>\r\n<BR>\r\n" + rb.getString("body.new.announce.type.message"));
        } else if (this.meeting.getMeetingType().equals("group") && !this.isUnlimited(this.meeting)) {
            Object[] params3 = new Object[]{this.meeting.getMaxNumberOfAttendees()};
            message.append("<BR>\r\n<BR>\r\n" + MessageFormat.format(rb.getString("body.new.group.limited.type.message.detail"), params3));
        } else {
            message.append("<BR>\r\n<BR>\r\n" + rb.getString("body.new.group.unlimited.type.message"));
        }
        message.append("<BR>\r\n<BR>\r\n" + this.meeting.getDescription());
        message.append("<BR>\r\n<BR>\r\n" + MessageFormat.format(rb.getString("body.attendeeCheck.meetingStatus"), this.getServiceName()));
        message.append("<BR>\r\n" + this.getFooter("<BR>\r\n", this.emailReturnSiteId));
        return message.toString();
    }

    private int getTimeSlotLength(SignupMeeting meeting) {
        List signupTimeSlots = meeting.getSignupTimeSlots();
        if (signupTimeSlots == null || signupTimeSlots.isEmpty()) {
            return 0;
        }
        SignupTimeslot ts = (SignupTimeslot)signupTimeSlots.get(0);
        int duration = (int)(ts.getEndTime().getTime() - ts.getStartTime().getTime()) / 60000;
        return duration;
    }

    private boolean isUnlimited(SignupMeeting meeting) {
        List signupTimeSlots = meeting.getSignupTimeSlots();
        if (signupTimeSlots == null || signupTimeSlots.isEmpty()) {
            return false;
        }
        SignupTimeslot ts = (SignupTimeslot)signupTimeSlots.get(0);
        return ts.isUnlimitedAttendee();
    }

    @Override
    public String getFromAddress() {
        return StringUtils.defaultIfEmpty((String)this.creator.getEmail(), (String)this.getServerFromAddress());
    }

    @Override
    public String getSubject() {
        return MessageFormat.format(rb.getString("subject.newMeeting.field"), this.creator.getDisplayName(), this.getTime(this.meeting.getStartTime()).toStringLocalDate(), this.getAbbreviatedMeetingTitle());
    }
}

