/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.logic.messages;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sakaiproject.signup.logic.SakaiFacade;
import org.sakaiproject.signup.logic.messages.SignupEmailBase;
import org.sakaiproject.signup.model.SignupMeeting;
import org.sakaiproject.user.api.User;

public class CancelMeetingEmail
extends SignupEmailBase {
    private final User organizer;
    private final String emailReturnSiteId;

    public CancelMeetingEmail(User orgainzer, SignupMeeting meeting, SakaiFacade sakaiFacade, String emailReturnSiteId) {
        this.organizer = orgainzer;
        this.meeting = meeting;
        this.emailReturnSiteId = emailReturnSiteId;
        this.setSakaiFacade(sakaiFacade);
    }

    @Override
    public List<String> getHeader() {
        ArrayList<String> rv = new ArrayList<String>();
        rv.add("Content-Type: text/html; charset=UTF-8");
        rv.add("Subject: " + this.getSubject());
        rv.add("From: " + this.getFromAddress());
        rv.add("To: " + rb.getString("noReply@") + this.getSakaiFacade().getServerConfigurationService().getServerName());
        return rv;
    }

    @Override
    public String getMessage() {
        StringBuilder message = new StringBuilder();
        Object[] params = new Object[]{this.makeFirstCapLetter(this.organizer.getDisplayName()), this.meeting.getTitle(), this.getSiteTitleWithQuote(this.emailReturnSiteId), this.getServiceName()};
        message.append("<BR>\r\n<BR>\r\n" + MessageFormat.format(rb.getString("body.organizerCancel.meeting.part"), params));
        message.append("<BR>\r\n" + this.getFooter("<BR>\r\n", this.emailReturnSiteId));
        return message.toString();
    }

    @Override
    public String getFromAddress() {
        return StringUtils.defaultIfEmpty((String)this.organizer.getEmail(), (String)this.getServerFromAddress());
    }

    @Override
    public String getSubject() {
        return MessageFormat.format(rb.getString("subject.meeting.cancel.field"), this.getAbbreviatedMeetingTitle(), this.getSiteTitle(this.emailReturnSiteId));
    }
}

