/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.logic.messages;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sakaiproject.signup.logic.SakaiFacade;
import org.sakaiproject.signup.logic.messages.SignupEmailBase;
import org.sakaiproject.signup.model.SignupMeeting;
import org.sakaiproject.signup.model.SignupTimeslot;
import org.sakaiproject.user.api.User;

public class AttendeeSignupEmail
extends SignupEmailBase {
    private final User currentUser;
    private final SignupTimeslot timeslot;
    private final User creator;

    public AttendeeSignupEmail(User creator, User currentUser, SignupMeeting signupMeeting, SignupTimeslot timeslot, SakaiFacade sakaiFacade) {
        this.creator = creator;
        this.currentUser = currentUser;
        this.meeting = signupMeeting;
        this.timeslot = timeslot;
        this.setSakaiFacade(sakaiFacade);
    }

    @Override
    public List<String> getHeader() {
        ArrayList<String> rv = new ArrayList<String>();
        rv.add("Content-Type: text/html; charset=UTF-8");
        rv.add("Subject: " + this.getSubject());
        rv.add("From: " + this.getFromAddress());
        rv.add("To: " + this.creator.getEmail());
        return rv;
    }

    @Override
    public String getMessage() {
        StringBuilder message = new StringBuilder();
        message.append(MessageFormat.format(rb.getString("body.top.greeting.part"), this.makeFirstCapLetter(this.creator.getDisplayName())));
        Object[] params = new Object[]{this.makeFirstCapLetter(this.currentUser.getDisplayName()), this.getSiteTitleWithQuote(), this.getServiceName()};
        message.append("<BR>\r\n<BR>\r\n" + MessageFormat.format(rb.getString("body.attendee.hasSignup.part"), params));
        message.append("<BR>\r\n<BR>\r\n" + MessageFormat.format(rb.getString("body.meetingTopic.part"), this.meeting.getTitle()));
        if (!this.meeting.isMeetingCrossDays()) {
            Object[] paramsTimeframe = new Object[]{this.getTime(this.timeslot.getStartTime()).toStringLocalTime(), this.getTime(this.timeslot.getEndTime()).toStringLocalTime(), this.getTime(this.timeslot.getStartTime()).toStringLocalDate(), this.getSakaiFacade().getTimeService().getLocalTimeZone().getID()};
            message.append("<BR>\r\n" + MessageFormat.format(rb.getString("body.attendee.meeting.timeslot"), paramsTimeframe));
        } else {
            Object[] paramsTimeframe = new Object[]{this.getTime(this.timeslot.getStartTime()).toStringLocalTime(), this.getTime(this.timeslot.getStartTime()).toStringLocalShortDate(), this.getTime(this.timeslot.getEndTime()).toStringLocalTime(), this.getTime(this.timeslot.getEndTime()).toStringLocalShortDate(), this.getSakaiFacade().getTimeService().getLocalTimeZone().getID()};
            message.append("<BR>\r\n" + MessageFormat.format(rb.getString("body.attendee.meeting.crossdays.timeslot"), paramsTimeframe));
        }
        if (this.timeslot.getAttendee(this.currentUser.getId()) != null && this.timeslot.getAttendee(this.currentUser.getId()).getComments() != null && this.timeslot.getAttendee(this.currentUser.getId()).getComments().length() > 0 && !"&nbsp;".equals(this.timeslot.getAttendee(this.currentUser.getId()).getComments())) {
            message.append("<BR>\r\n<BR>\r\n" + MessageFormat.format(rb.getString("body.commentBy"), this.makeFirstCapLetter(this.currentUser.getDisplayName()), this.timeslot.getAttendee(this.currentUser.getId()).getComments()));
        }
        message.append("<BR>\r\n" + this.getFooter("<BR>\r\n"));
        return message.toString();
    }

    @Override
    public String getFromAddress() {
        return StringUtils.defaultIfEmpty((String)this.currentUser.getEmail(), (String)this.getServerFromAddress());
    }

    @Override
    public String getSubject() {
        return MessageFormat.format(rb.getString("subject.attendee.signup.field"), this.getTime(this.meeting.getStartTime()).toStringLocalDate(), this.currentUser.getDisplayName(), this.getSiteTitle(), this.getAbbreviatedMeetingTitle());
    }
}

