/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.logic;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.StringTokenizer;
import net.fortuna.ical4j.model.component.VEvent;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.LogFactoryImpl;
import org.apache.commons.validator.EmailValidator;
import org.sakaiproject.email.api.AddressValidationException;
import org.sakaiproject.email.api.Attachment;
import org.sakaiproject.email.api.EmailAddress;
import org.sakaiproject.email.api.EmailMessage;
import org.sakaiproject.email.api.EmailService;
import org.sakaiproject.email.api.NoRecipientsException;
import org.sakaiproject.signup.logic.SakaiFacade;
import org.sakaiproject.signup.logic.SignupCalendarHelper;
import org.sakaiproject.signup.logic.SignupEmailFacade;
import org.sakaiproject.signup.logic.SignupTrackingItem;
import org.sakaiproject.signup.logic.SignupUser;
import org.sakaiproject.signup.logic.messages.AddAttendeeEmail;
import org.sakaiproject.signup.logic.messages.AttendeeCancellationEmail;
import org.sakaiproject.signup.logic.messages.AttendeeCancellationOwnEmail;
import org.sakaiproject.signup.logic.messages.AttendeeSignupEmail;
import org.sakaiproject.signup.logic.messages.AttendeeSignupOwnEmail;
import org.sakaiproject.signup.logic.messages.CancelMeetingEmail;
import org.sakaiproject.signup.logic.messages.CancellationEmail;
import org.sakaiproject.signup.logic.messages.EmailDeliverer;
import org.sakaiproject.signup.logic.messages.ModifyMeetingEmail;
import org.sakaiproject.signup.logic.messages.MoveAttendeeEmail;
import org.sakaiproject.signup.logic.messages.NewMeetingEmail;
import org.sakaiproject.signup.logic.messages.OrganizerPreAssignEmail;
import org.sakaiproject.signup.logic.messages.PromoteAttendeeEmail;
import org.sakaiproject.signup.logic.messages.SignupEmailBase;
import org.sakaiproject.signup.logic.messages.SignupEmailNotification;
import org.sakaiproject.signup.logic.messages.SignupEventTrackingInfo;
import org.sakaiproject.signup.logic.messages.SwapAttendeeEmail;
import org.sakaiproject.signup.model.SignupAttendee;
import org.sakaiproject.signup.model.SignupMeeting;
import org.sakaiproject.signup.model.SignupTimeslot;
import org.sakaiproject.user.api.User;
import org.sakaiproject.user.api.UserDirectoryService;
import org.sakaiproject.user.api.UserNotDefinedException;

public class SignupEmailFacadeImpl
implements SignupEmailFacade {
    private EmailService emailService;
    private UserDirectoryService userDirectoryService;
    private SakaiFacade sakaiFacade;
    private SignupCalendarHelper calendarHelper;
    private Log logger = LogFactoryImpl.getLog(this.getClass());

    public void sendEmailAllUsers(SignupMeeting meeting, String messageType) throws Exception {
        if (messageType.equals("signup.email.new.meeting") || messageType.equals("signup.email.meeting.modified") || messageType.equals("signup.email.cancel.meeting")) {
            this.sendEmailToAllUsers(meeting, messageType);
            return;
        }
    }

    public void sendEmailToOrganizer(SignupEventTrackingInfo signupEventTrackingInfo) throws Exception {
        boolean isException = false;
        this.generateVEvents(signupEventTrackingInfo.getMeeting());
        List sigupTList = signupEventTrackingInfo.getAttendeeTransferInfos();
        for (SignupTrackingItem item : sigupTList) {
            if (!item.getMessageType().equals("signup.email.attendee.signup")) continue;
            User participant = null;
            try {
                List<User> OwnerAndCoordinators = this.getMeetingOwnerAndCoordinators(signupEventTrackingInfo.getMeeting());
                if (OwnerAndCoordinators.isEmpty()) {
                    throw new Exception("No Organizer/Coordinator is not found and Email is not sent away for oraginzer");
                }
                participant = this.userDirectoryService.getUser(item.getAttendee().getAttendeeUserId());
                for (User organizer : OwnerAndCoordinators) {
                    AttendeeSignupEmail email = new AttendeeSignupEmail(organizer, participant, signupEventTrackingInfo.getMeeting(), item.getAddToTimeslot(), this.sakaiFacade);
                    this.sendEmail(organizer, (SignupEmailNotification)email);
                }
            }
            catch (UserNotDefinedException e) {
                isException = true;
            }
        }
        if (isException) {
            throw new Exception("Email may not be sent out due to error.");
        }
    }

    private List<User> getMeetingOwnerAndCoordinators(SignupMeeting meeting) {
        LinkedHashSet<User> organizerCoordinators = new LinkedHashSet<User>();
        try {
            User creator = this.userDirectoryService.getUser(meeting.getCreatorUserId());
            organizerCoordinators.add(creator);
        }
        catch (UserNotDefinedException e) {
            this.logger.warn((Object)("User is not found and Email is not sent away for oraginzer userId:" + meeting.getCreatorUserId()));
        }
        List<String> coordinatorIds = this.getExistingCoordinatorIds(meeting);
        for (String cId : coordinatorIds) {
            try {
                User coUser = this.userDirectoryService.getUser(cId);
                organizerCoordinators.add(coUser);
            }
            catch (UserNotDefinedException e) {
                this.logger.warn((Object)("User is not found and Email is not sent away for coordinator userId:" + cId));
            }
        }
        return new ArrayList<User>(organizerCoordinators);
    }

    private List<String> getExistingCoordinatorIds(SignupMeeting meeting) {
        ArrayList<String> coUsers = new ArrayList<String>();
        String coUserIdsString = meeting.getCoordinatorIds();
        if (coUserIdsString != null && coUserIdsString.trim().length() > 0) {
            StringTokenizer userIdTokens = new StringTokenizer(coUserIdsString, "|");
            while (userIdTokens.hasMoreTokens()) {
                String uId = userIdTokens.nextToken();
                coUsers.add(uId);
            }
        }
        return coUsers;
    }

    public void sendCancellationEmail(SignupEventTrackingInfo signupEventTrackingInfo) throws Exception {
        this.generateVEvents(signupEventTrackingInfo.getMeeting());
        List sigupTList = signupEventTrackingInfo.getAttendeeTransferInfos();
        for (SignupTrackingItem item : sigupTList) {
            if (!item.getMessageType().equals("signup.email.attedee.promote")) continue;
            User attendee = null;
            try {
                attendee = this.userDirectoryService.getUser(item.getAttendee().getAttendeeUserId());
                PromoteAttendeeEmail email = new PromoteAttendeeEmail(attendee, item, signupEventTrackingInfo.getMeeting(), this.sakaiFacade);
                this.sendEmail(attendee, (SignupEmailNotification)email);
            }
            catch (UserNotDefinedException e) {
                throw new Exception("User is not found and Email is not sent away for attendee userId: " + item.getAttendee().getAttendeeUserId());
            }
        }
        User initiator = null;
        try {
            List<User> OwnerAndCoordinators = this.getMeetingOwnerAndCoordinators(signupEventTrackingInfo.getMeeting());
            if (OwnerAndCoordinators.isEmpty()) {
                throw new Exception("No Organizer/Coordinator is not found and Email is not sent away for oraginzer");
            }
            initiator = this.userDirectoryService.getUser(signupEventTrackingInfo.getInitiatorAllocationInfo().getAttendee().getAttendeeUserId());
            if (signupEventTrackingInfo.getMeeting().isReceiveEmailByOwner()) {
                for (User organizer : OwnerAndCoordinators) {
                    try {
                        AttendeeCancellationEmail email = new AttendeeCancellationEmail(organizer, initiator, sigupTList, signupEventTrackingInfo.getMeeting(), this.sakaiFacade);
                        this.sendEmail(organizer, (SignupEmailNotification)email);
                    }
                    catch (Exception e) {}
                }
            }
            AttendeeCancellationOwnEmail attendeeEmail = new AttendeeCancellationOwnEmail(initiator, sigupTList, signupEventTrackingInfo.getMeeting(), this.sakaiFacade);
            this.sendEmail(initiator, (SignupEmailNotification)attendeeEmail);
        }
        catch (UserNotDefinedException e) {
            throw new Exception("User is not found for userId: " + signupEventTrackingInfo.getMeeting().getCreatorUserId());
        }
    }

    public void sendEmailToParticipantsByOrganizerAction(SignupEventTrackingInfo signupEventTrackingInfo) throws Exception {
        this.generateVEvents(signupEventTrackingInfo.getMeeting());
        List sigupTList = signupEventTrackingInfo.getAttendeeTransferInfos();
        for (SignupTrackingItem item : sigupTList) {
            User organizer = null;
            User participant = null;
            User participant2 = null;
            try {
                organizer = this.userDirectoryService.getUser(this.getSakaiFacade().getCurrentUserId());
                participant = this.userDirectoryService.getUser(item.getAttendee().getAttendeeUserId());
                if (item.getMessageType().equals("signup.email.attendee.swap") || item.getMessageType().equals("signup.email.attendee.replace")) {
                    participant2 = this.userDirectoryService.getUser(item.getReplacedAttendde().getAttendeeUserId());
                }
                SignupEmailBase email = null;
                if (item.getMessageType().equals("signup.email.attendee.move")) {
                    email = new MoveAttendeeEmail(organizer, participant, item, signupEventTrackingInfo.getMeeting(), this.sakaiFacade);
                } else if (item.getMessageType().equals("signup.email.attendee.swap")) {
                    email = new SwapAttendeeEmail(organizer, participant, participant2, item, signupEventTrackingInfo.getMeeting(), this.sakaiFacade);
                } else if (item.getMessageType().equals("signup.email.attendee.cancel")) {
                    email = new CancellationEmail(organizer, participant, item, signupEventTrackingInfo.getMeeting(), this.sakaiFacade);
                } else if (item.getMessageType().equals("signup.email.attendee.replace") || item.getMessageType().equals("signup.email.attendee.signup")) {
                    email = new AddAttendeeEmail(organizer, participant, item, signupEventTrackingInfo.getMeeting(), this.sakaiFacade);
                } else if (item.getMessageType().equals("signup.email.attedee.promote")) {
                    email = new PromoteAttendeeEmail(participant, item, signupEventTrackingInfo.getMeeting(), this.sakaiFacade);
                } else {
                    this.logger.warn((Object)("For attendee(Eid):" + participant.getEid() + " - No such message type:" + item.getMessageType() + " was found and no email was able to send away"));
                    return;
                }
                this.sendEmail(participant, (SignupEmailNotification)email);
            }
            catch (UserNotDefinedException e) {
                throw new Exception("User is not found and Email is not sent away for oraginzer userId:" + signupEventTrackingInfo.getMeeting().getCreatorUserId());
            }
        }
    }

    public void sendEmailToAttendee(SignupEventTrackingInfo signupEventTrackingInfo) throws Exception {
        this.generateVEvents(signupEventTrackingInfo.getMeeting());
        List sigupTList = signupEventTrackingInfo.getAttendeeTransferInfos();
        for (SignupTrackingItem item : sigupTList) {
            if (!item.getMessageType().equals("signup.email.attendee.signup")) continue;
            User participant = null;
            try {
                participant = this.userDirectoryService.getUser(item.getAttendee().getAttendeeUserId());
                AttendeeSignupOwnEmail email = new AttendeeSignupOwnEmail(participant, signupEventTrackingInfo.getMeeting(), item.getAddToTimeslot(), this.sakaiFacade);
                this.sendEmail(participant, (SignupEmailNotification)email);
            }
            catch (UserNotDefinedException e) {
                throw new Exception("User is not found and email has not been sent for participant: " + signupEventTrackingInfo.getMeeting().getCreatorUserId());
            }
        }
    }

    private void sendEmail(User user, SignupEmailNotification email) {
        this.logger.debug((Object)("sendMail called for user:" + user.getEid()));
        try {
            EmailMessage message = this.convertSignupEmail(email, user);
            if (message != null) {
                this.emailService.send(message);
            }
        }
        catch (NoRecipientsException e) {
            this.logger.error((Object)("Cannot send mail. No recipient." + e.getMessage()));
        }
        catch (AddressValidationException e) {
            this.logger.warn((Object)("Cannot send mail to user: " + user.getEid() + ". Invalid email address." + EmailAddress.toString((List)e.getInvalidEmailAddresses())));
        }
    }

    private void sendEmail(List<User> users, SignupEmailNotification email) {
        for (User u : users) {
            this.sendEmail(u, email);
        }
    }

    private List<EmailUserSiteGroup> getUserSiteEmailGroups(List<SignupUser> signupUsers) {
        ArrayList<EmailUserSiteGroup> userSiteGroupList = new ArrayList<EmailUserSiteGroup>();
        for (SignupUser signupUser : signupUsers) {
            String siteId = signupUser.getMainSiteId();
            boolean found = false;
            for (EmailUserSiteGroup userSiteGroup : userSiteGroupList) {
                if (!siteId.equals(userSiteGroup.getSiteId())) continue;
                userSiteGroup.addSignupUser(signupUser);
                found = true;
                break;
            }
            if (found) continue;
            EmailUserSiteGroup usg = new EmailUserSiteGroup(siteId, signupUser);
            userSiteGroupList.add(usg);
        }
        return userSiteGroupList;
    }

    private void sendEmailToAllUsers(SignupMeeting meeting, String messageType) throws Exception {
        this.generateVEvents(meeting);
        List signupUsers = this.sakaiFacade.getAllUsers(meeting);
        List<EmailUserSiteGroup> userSiteGroupList = this.getUserSiteEmailGroups(signupUsers);
        boolean isException = false;
        boolean isAlreadyEmailedToOrganizerCoordinators = false;
        for (EmailUserSiteGroup emailUserSiteGroup : userSiteGroupList) {
            if (!emailUserSiteGroup.isPublishedSite()) continue;
            List<String> userIds = null;
            List<User> sakaiUsers = null;
            User organizer = null;
            try {
                SignupEmailBase email;
                block27: {
                    block25: {
                        block26: {
                            email = null;
                            if (!messageType.equals("signup.email.new.meeting")) break block25;
                            organizer = this.userDirectoryService.getUser(meeting.getCreatorUserId());
                            email = new NewMeetingEmail(organizer, meeting, this.sakaiFacade, emailUserSiteGroup.getSiteId());
                            try {
                                this.sendEmailToPreAssignedAttendee(emailUserSiteGroup, meeting);
                            }
                            catch (Exception e) {
                                isException = true;
                            }
                            if (!"all".equals(meeting.getSendEmailToSelectedPeopleOnly())) break block26;
                            userIds = emailUserSiteGroup.getUserInternalIds();
                            sakaiUsers = this.userDirectoryService.getUsers(userIds);
                            break block27;
                        }
                        if (isAlreadyEmailedToOrganizerCoordinators) break block27;
                        sakaiUsers = this.getMeetingOwnerAndCoordinators(meeting);
                        isAlreadyEmailedToOrganizerCoordinators = true;
                        break block27;
                    }
                    if (messageType.equals("signup.email.meeting.modified") || messageType.equals("signup.email.cancel.meeting")) {
                        organizer = this.userDirectoryService.getUser(this.getSakaiFacade().getCurrentUserId());
                        if (messageType.equals("signup.email.meeting.modified")) {
                            email = new ModifyMeetingEmail(organizer, meeting, this.sakaiFacade, emailUserSiteGroup.getSiteId());
                        } else if (messageType.equals("signup.email.cancel.meeting")) {
                            email = new CancelMeetingEmail(organizer, meeting, this.sakaiFacade, emailUserSiteGroup.getSiteId());
                        }
                        if ("all".equals(meeting.getSendEmailToSelectedPeopleOnly())) {
                            userIds = emailUserSiteGroup.getUserInternalIds();
                            sakaiUsers = this.userDirectoryService.getUsers(userIds);
                        } else if ("organizers_only".equals(meeting.getSendEmailToSelectedPeopleOnly())) {
                            if (!isAlreadyEmailedToOrganizerCoordinators) {
                                sakaiUsers = this.getMeetingOwnerAndCoordinators(meeting);
                                isAlreadyEmailedToOrganizerCoordinators = true;
                            }
                        } else if ("signup_only".equals(meeting.getSendEmailToSelectedPeopleOnly())) {
                            List tsList = meeting.getSignupTimeSlots();
                            User user = null;
                            List<SignupUser> sgpUsers = emailUserSiteGroup.getSignupUsers();
                            sakaiUsers = new ArrayList<User>();
                            if (!isAlreadyEmailedToOrganizerCoordinators && messageType.equals("signup.email.cancel.meeting")) {
                                sakaiUsers = this.getMeetingOwnerAndCoordinators(meeting);
                                isAlreadyEmailedToOrganizerCoordinators = true;
                            }
                            if (tsList != null) {
                                for (SignupTimeslot ts : tsList) {
                                    List attList = ts.getAttendees();
                                    if (attList == null) continue;
                                    block9: for (SignupAttendee att : attList) {
                                        for (SignupUser spgUser : sgpUsers) {
                                            if (!att.getAttendeeUserId().equals(spgUser.getInternalUserId())) continue;
                                            try {
                                                user = this.userDirectoryService.getUser(att.getAttendeeUserId());
                                            }
                                            catch (UserNotDefinedException e) {
                                                this.logger.warn((Object)("User is not found for userId: " + att.getAttendeeUserId()));
                                                isException = true;
                                            }
                                            sakaiUsers.add(user);
                                            continue block9;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                if (email == null) continue;
                if (sakaiUsers.size() > 400) {
                    EmailDeliverer deliverer = new EmailDeliverer(sakaiUsers, email.getHeader(), email.getMessage(), this.emailService);
                    Thread t = new Thread(deliverer);
                    t.start();
                    continue;
                }
                this.sendEmail(sakaiUsers, (SignupEmailNotification)email);
            }
            catch (UserNotDefinedException ue) {
                isException = true;
                this.logger.warn((Object)("User is not found for userId: " + meeting.getCreatorUserId()));
            }
            catch (Exception e) {
                isException = true;
                this.logger.error((Object)("Exception: " + e.getClass() + ": " + e.getMessage()));
            }
        }
        if (isException) {
            throw new Exception("Some emails may not be sent out due to error.");
        }
    }

    private void sendEmailToPreAssignedAttendee(EmailUserSiteGroup emailUserSiteGroup, SignupMeeting meeting) throws Exception {
        List<SignupUser> sgpUsers = emailUserSiteGroup.getSignupUsers();
        List signupTimeSlots = meeting.getSignupTimeSlots();
        if (signupTimeSlots == null) {
            return;
        }
        boolean isExcepiotn = false;
        User currentUser = this.userDirectoryService.getCurrentUser();
        for (SignupTimeslot timeslot : signupTimeSlots) {
            List attendees = timeslot.getAttendees();
            if (attendees == null) continue;
            block3: for (SignupAttendee attendee : attendees) {
                Iterator<SignupUser> iter = sgpUsers.iterator();
                while (iter.hasNext()) {
                    SignupUser spUser = iter.next();
                    if (!spUser.getInternalUserId().equals(attendee.getAttendeeUserId())) continue;
                    try {
                        User user = this.userDirectoryService.getUser(attendee.getAttendeeUserId());
                        OrganizerPreAssignEmail email = new OrganizerPreAssignEmail(currentUser, meeting, timeslot, user, this.sakaiFacade, emailUserSiteGroup.getSiteId());
                        this.sendEmail(user, (SignupEmailNotification)email);
                    }
                    catch (UserNotDefinedException e) {
                        this.logger.warn((Object)("User is not found for userId: " + attendee.getAttendeeUserId()));
                        isExcepiotn = true;
                    }
                    iter.remove();
                    continue block3;
                }
            }
        }
        if (isExcepiotn) {
            throw new Exception("User is not found and email may not be sent out.");
        }
    }

    private void excludPreAssignedAttendee(List<User> sakaiUsers, SignupMeeting meeting) {
        List signupTimeSlots = meeting.getSignupTimeSlots();
        if (signupTimeSlots == null) {
            return;
        }
        for (SignupTimeslot timeslot : signupTimeSlots) {
            List attendees = timeslot.getAttendees();
            if (attendees == null) continue;
            User preAssignedUser = null;
            for (SignupAttendee attendee : attendees) {
                try {
                    preAssignedUser = this.userDirectoryService.getUser(attendee.getAttendeeUserId());
                    Iterator<User> iter = sakaiUsers.iterator();
                    while (iter.hasNext()) {
                        User sakaiUser = iter.next();
                        if (!sakaiUser.getEid().equals(preAssignedUser.getEid())) continue;
                        iter.remove();
                    }
                }
                catch (UserNotDefinedException e) {
                    this.logger.warn((Object)("User is not found for userId: " + attendee.getAttendeeUserId()));
                }
            }
        }
    }

    private EmailMessage convertSignupEmail(SignupEmailNotification email, User recipient) {
        EmailMessage message = new EmailMessage();
        message.setHeaders(email.getHeader());
        message.setBody(email.getMessage());
        message.setSubject(email.getSubject());
        this.logger.debug((Object)("email.getFromAddress(): " + email.getFromAddress()));
        message.setFrom(email.getFromAddress());
        message.setContentType("text/html; charset=UTF-8");
        for (Attachment a : this.collectAttachments(email, recipient)) {
            message.addAttachment(a);
        }
        String emailAddress = recipient.getEmail();
        if (!StringUtils.isNotBlank((String)emailAddress) || !EmailValidator.getInstance().isValid(emailAddress)) {
            this.logger.error((Object)("Invalid email for user:" + recipient.getDisplayId() + ". No email will be sent to this user"));
            return null;
        }
        message.addRecipient(EmailAddress.RecipientType.TO, recipient.getDisplayName(), emailAddress);
        return message;
    }

    private List<Attachment> collectAttachments(SignupEmailNotification email, User user) {
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        attachments.addAll(this.generateICS(email, user));
        return attachments;
    }

    private List<Attachment> generateICS(SignupEmailNotification email, User user) {
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        SignupMeeting meeting = email.getMeeting();
        if (email instanceof NewMeetingEmail || email instanceof ModifyMeetingEmail || email instanceof CancelMeetingEmail) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"NewMeetingEmail/ModifyMeetingEmail/CancelMeetingEmail");
            }
            boolean cancel = false;
            if (email instanceof CancelMeetingEmail) {
                cancel = true;
            }
            String organiserUuid = meeting.getCreatorUserId();
            List<String> organizerCoordinatorsUuid = this.getExistingCoordinatorIds(meeting);
            organizerCoordinatorsUuid.add(organiserUuid);
            if (organizerCoordinatorsUuid.contains(user.getId())) {
                VEvent v = meeting.getVevent();
                if (v == null) {
                    return attachments;
                }
                if (cancel) {
                    v = this.calendarHelper.cancelVEvent(v);
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Organiser: " + organiserUuid + " matches user, ICS for overall meeting will be attached."));
                }
                attachments.add(this.formatICSAttachment(Collections.singletonList(v)));
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("User: " + user.getId() + " is not organiser, no ICS for overall meeting will be attached, but updated signed-up timeslots will be attached"));
                }
                ArrayList<VEvent> vevents = new ArrayList<VEvent>();
                for (SignupTimeslot ts : meeting.getSignupTimeSlots()) {
                    VEvent v;
                    if (ts.getAttendee(user.getId()) == null || (v = ts.getVevent()) == null) continue;
                    if (cancel) {
                        v = this.calendarHelper.cancelVEvent(v);
                    }
                    vevents.add(v);
                }
                if (vevents.size() > 0) {
                    attachments.add(this.formatICSAttachment(vevents));
                }
            }
        } else if (email instanceof AddAttendeeEmail || email instanceof PromoteAttendeeEmail || email instanceof OrganizerPreAssignEmail || email instanceof AttendeeSignupOwnEmail) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"AddAttendeeEmail/PromoteAttendeeEmail/OrganizerPreAssignEmail/AttendeeSignupOwnEmail");
            }
            ArrayList<VEvent> vevents = new ArrayList<VEvent>();
            for (SignupTimeslot ts : meeting.getSignupTimeSlots()) {
                VEvent v;
                if (ts.getAttendee(user.getId()) == null || (v = ts.getVevent()) == null) continue;
                vevents.add(v);
            }
            if (vevents.size() > 0) {
                attachments.add(this.formatICSAttachment(vevents));
            }
        } else if (email instanceof AttendeeCancellationOwnEmail) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"AttendeeCancellationOwnEmail");
            }
            List<SignupTimeslot> cancelled = ((AttendeeCancellationOwnEmail)email).getRemoved();
            ArrayList<VEvent> vevents = new ArrayList<VEvent>();
            for (SignupTimeslot ts : cancelled) {
                VEvent vEvent = ts.getVevent();
                if (vEvent == null) continue;
                vevents.add(this.calendarHelper.cancelVEvent(vEvent));
            }
            if (vevents.size() > 0) {
                attachments.add(this.formatICSAttachment(vevents));
            }
        } else if (email instanceof AttendeeSignupEmail || email instanceof AttendeeCancellationEmail) {
            VEvent v;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"AttendeeSignupEmail/AttendeeCancellationEmail");
            }
            if ((v = meeting.getVevent()) == null) {
                return attachments;
            }
            ArrayList attendees = new ArrayList();
            for (SignupTimeslot ts : meeting.getSignupTimeSlots()) {
                attendees.addAll(ts.getAttendees());
            }
            ArrayList<User> users = new ArrayList<User>();
            for (SignupAttendee signupAttendee : attendees) {
                User u = this.sakaiFacade.getUser(signupAttendee.getAttendeeUserId());
                if (u == null) continue;
                users.add(u);
            }
            VEvent vevent = this.calendarHelper.addAttendeesToVEvent(v, users);
            attachments.add(this.formatICSAttachment(Collections.singletonList(vevent)));
        } else if (email instanceof CancellationEmail) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"CancellationEmail");
            }
            List<SignupTimeslot> cancelled = ((CancellationEmail)email).getRemoved();
            ArrayList<VEvent> vevents = new ArrayList<VEvent>();
            for (SignupTimeslot ts : cancelled) {
                VEvent vEvent = ts.getVevent();
                if (vEvent == null) continue;
                vevents.add(this.calendarHelper.cancelVEvent(vEvent));
            }
            if (vevents.size() > 0) {
                attachments.add(this.formatICSAttachment(vevents));
            }
        } else if (email instanceof MoveAttendeeEmail || email instanceof SwapAttendeeEmail) {
            VEvent v;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"MoveAttendeeEmail/SwapAttendeeEmail");
            }
            List<Object> removed = new ArrayList();
            List<Object> added = new ArrayList();
            if (email instanceof MoveAttendeeEmail) {
                removed = ((MoveAttendeeEmail)email).getRemoved();
                added = ((MoveAttendeeEmail)email).getAdded();
            } else if (email instanceof SwapAttendeeEmail) {
                removed = ((SwapAttendeeEmail)email).getRemoved();
                added = ((SwapAttendeeEmail)email).getAdded();
            }
            ArrayList<VEvent> vevents = new ArrayList<VEvent>();
            for (SignupTimeslot signupTimeslot : removed) {
                v = this.ensureVEventForTimeslot(meeting, signupTimeslot);
                if (v == null) continue;
                vevents.add(this.calendarHelper.cancelVEvent(v));
            }
            for (SignupTimeslot signupTimeslot : added) {
                v = this.ensureVEventForTimeslot(meeting, signupTimeslot);
                if (v == null) continue;
                vevents.add(v);
            }
            if (vevents.size() > 0) {
                attachments.add(this.formatICSAttachment(vevents));
            }
        }
        return attachments;
    }

    private SignupMeeting generateVEvents(SignupMeeting meeting) {
        meeting.setVevent(this.calendarHelper.generateVEventForMeeting(meeting));
        for (SignupTimeslot ts : meeting.getSignupTimeSlots()) {
            ts.setVevent(this.calendarHelper.generateVEventForTimeslot(meeting, ts));
        }
        return meeting;
    }

    private VEvent ensureVEventForTimeslot(SignupMeeting meeting, SignupTimeslot ts) {
        return this.calendarHelper.generateVEventForTimeslot(meeting, ts);
    }

    private Attachment formatICSAttachment(List<VEvent> vevents) {
        String path = this.calendarHelper.createCalendarFile(vevents);
        return new Attachment(new File(path), StringUtils.substringAfterLast((String)path, (String)File.separator));
    }

    public EmailService getEmailService() {
        return this.emailService;
    }

    public void setEmailService(EmailService emailService) {
        this.emailService = emailService;
    }

    public UserDirectoryService getUserDirectoryService() {
        return this.userDirectoryService;
    }

    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    public SakaiFacade getSakaiFacade() {
        return this.sakaiFacade;
    }

    public void setSakaiFacade(SakaiFacade sakaiFacade) {
        this.sakaiFacade = sakaiFacade;
    }

    public void setCalendarHelper(SignupCalendarHelper calendarHelper) {
        this.calendarHelper = calendarHelper;
    }

    private class EmailUserSiteGroup {
        private String siteId;
        private boolean publishedSite;
        private List<SignupUser> signupUsers = new ArrayList<SignupUser>();

        public EmailUserSiteGroup(String siteId, SignupUser user) {
            this.siteId = siteId;
            this.signupUsers.add(user);
            this.publishedSite = user.isPublishedSite();
        }

        public void addSignupUser(SignupUser user) {
            this.signupUsers.add(user);
        }

        public String getSiteId() {
            return this.siteId;
        }

        public void setSiteId(String siteId) {
            this.siteId = siteId;
        }

        public List<SignupUser> getSignupUsers() {
            return this.signupUsers;
        }

        public void setSignupUsers(List<SignupUser> signupUsers) {
            this.signupUsers = signupUsers;
        }

        public List<String> getUserInternalIds() {
            ArrayList<String> userIds = new ArrayList<String>();
            for (SignupUser signupUser : this.signupUsers) {
                userIds.add(signupUser.getInternalUserId());
            }
            return userIds;
        }

        public boolean isPublishedSite() {
            return this.publishedSite;
        }

        public void setPublishedSite(boolean publishedSite) {
            this.publishedSite = publishedSite;
        }
    }
}

