/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.logic;

import java.util.Date;
import java.util.List;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.component.VEvent;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.authz.api.SecurityAdvisor;
import org.sakaiproject.calendar.api.CalendarEvent;
import org.sakaiproject.calendar.api.CalendarEventEdit;
import org.sakaiproject.calendaring.api.ExternalCalendaringService;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.signup.logic.SakaiFacade;
import org.sakaiproject.signup.logic.SignupCalendarHelper;
import org.sakaiproject.signup.model.SignupMeeting;
import org.sakaiproject.signup.model.SignupSite;
import org.sakaiproject.signup.model.SignupTimeslot;
import org.sakaiproject.signup.util.PlainTextFormat;
import org.sakaiproject.time.api.Time;
import org.sakaiproject.time.api.TimeRange;
import org.sakaiproject.time.api.TimeService;
import org.sakaiproject.user.api.User;
import org.sakaiproject.util.ResourceLoader;

public class SignupCalendarHelperImpl
implements SignupCalendarHelper {
    private static final Log log = LogFactory.getLog(SignupCalendarHelperImpl.class);
    protected static ResourceLoader rb = new ResourceLoader("emailMessage");
    public static final String newline = "<br />";
    private SakaiFacade sakaiFacade;
    private ExternalCalendaringService externalCalendaringService;

    public CalendarEventEdit generateEvent(SignupMeeting m) {
        return this.generateEvent(m, null);
    }

    public CalendarEventEdit generateEvent(SignupMeeting m, SignupTimeslot ts) {
        Date end;
        Date start;
        String siteId = ((SignupSite)m.getSignupSites().get(0)).getSiteId();
        if (ts == null) {
            start = m.getStartTime();
            end = m.getEndTime();
        } else {
            start = ts.getStartTime();
            end = ts.getEndTime();
        }
        String title = m.getTitle();
        String description = m.getDescription();
        String location = m.getLocation();
        return this.generateEvent(siteId, start, end, title, description, location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VEvent generateVEventForTimeslot(SignupMeeting meeting, SignupTimeslot ts) {
        if (meeting == null) {
            log.error((Object)"Meeting was null. Cannot generate VEvent.");
            return null;
        }
        if (ts == null) {
            log.error((Object)"Timeslot was null. Cannot generate VEvent.");
            return null;
        }
        VEvent v = ts.getVevent();
        if (v == null) {
            SecurityAdvisor advisor = this.sakaiFacade.pushSecurityAdvisor();
            try {
                CalendarEventEdit tsEvent = this.generateEvent(meeting, ts);
                if (tsEvent == null) {
                    VEvent vEvent = null;
                    return vEvent;
                }
                tsEvent.setField("vevent_uuid", ts.getUuid());
                tsEvent.setField("vevent_sequence", String.valueOf(ts.getVersion()));
                v = this.externalCalendaringService.createEvent((CalendarEvent)tsEvent);
            }
            finally {
                this.sakaiFacade.popSecurityAdvisor(advisor);
            }
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VEvent generateVEventForMeeting(SignupMeeting meeting) {
        if (meeting == null) {
            log.error((Object)"Meeting was null. Cannot generate VEvent.");
            return null;
        }
        VEvent v = meeting.getVevent();
        if (v == null) {
            SecurityAdvisor advisor = this.sakaiFacade.pushSecurityAdvisor();
            try {
                CalendarEventEdit mEvent = this.generateEvent(meeting);
                if (mEvent == null) {
                    VEvent vEvent = null;
                    return vEvent;
                }
                mEvent.setField("vevent_uuid", meeting.getUuid());
                v = this.externalCalendaringService.createEvent((CalendarEvent)mEvent);
            }
            finally {
                this.sakaiFacade.popSecurityAdvisor(advisor);
            }
        }
        return v;
    }

    public String createCalendarFile(List<VEvent> vevents) {
        Calendar cal = this.externalCalendaringService.createCalendar(vevents);
        return this.externalCalendaringService.toFile(cal);
    }

    public VEvent cancelVEvent(VEvent vevent) {
        return this.externalCalendaringService.cancelEvent(vevent);
    }

    public VEvent addAttendeesToVEvent(VEvent vevent, List<User> users) {
        return this.externalCalendaringService.addAttendeesToEvent(vevent, users);
    }

    public boolean isIcsEnabled() {
        return this.externalCalendaringService.isIcsEnabled();
    }

    private CalendarEventEdit generateEvent(String siteId, Date startTime, Date endTime, String title, String description, String location) {
        CalendarEventEdit event = null;
        try {
            org.sakaiproject.calendar.api.Calendar calendar = this.sakaiFacade.getCalendar(siteId);
            if (calendar == null) {
                return null;
            }
            event = calendar.addEvent();
            event.setType("Meeting");
            TimeService timeService = this.sakaiFacade.getTimeService();
            Time start = timeService.newTime(startTime.getTime());
            Time end = timeService.newTime(endTime.getTime());
            TimeRange timeRange = timeService.newTimeRange(start, end, true, false);
            event.setRange(timeRange);
            event.setDisplayName(title);
            event.setDescription(PlainTextFormat.convertFormattedHtmlTextToICalText(this.addWarningMessageForCancellation(description, siteId)));
            event.setLocation(location);
            String url = this.getSiteAccessUrl(siteId);
            if (StringUtils.isNotBlank((String)url)) {
                event.setField("vevent_url", url);
            }
        }
        catch (PermissionException e) {
            log.error((Object)("SignupCalendarHelperImpl.generateEvent: " + (Object)((Object)e)));
            return null;
        }
        return event;
    }

    private String addWarningMessageForCancellation(String meetingDesc, String siteId) {
        meetingDesc = meetingDesc == null ? " " : meetingDesc;
        StringBuffer sb = new StringBuffer(meetingDesc);
        sb.append("<br /><br />");
        sb.append(rb.getString("ical.footer.separator"));
        sb.append(newline + rb.getString("ical.footer.text"));
        return sb.toString();
    }

    private String getSiteAccessUrl(String siteId) {
        if (StringUtils.isNotBlank((String)siteId)) {
            return this.sakaiFacade.getServerConfigurationService().getPortalUrl() + "/site/" + siteId + "/page/" + this.sakaiFacade.getCurrentPageId();
        }
        return null;
    }

    public void setSakaiFacade(SakaiFacade sakaiFacade) {
        this.sakaiFacade = sakaiFacade;
    }

    public void setExternalCalendaringService(ExternalCalendaringService externalCalendaringService) {
        this.externalCalendaringService = externalCalendaringService;
    }
}

