/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.metaobj.worksite.mgt.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.authz.api.AuthzGroup;
import org.sakaiproject.authz.api.GroupNotDefinedException;
import org.sakaiproject.authz.cover.AuthzGroupService;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.metaobj.shared.mgt.IdManager;
import org.sakaiproject.metaobj.shared.model.Id;
import org.sakaiproject.metaobj.shared.model.OspException;
import org.sakaiproject.metaobj.worksite.mgt.WorksiteManager;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SitePage;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.site.api.ToolConfiguration;
import org.sakaiproject.site.cover.SiteService;
import org.sakaiproject.tool.api.Placement;
import org.sakaiproject.tool.api.ToolSession;
import org.sakaiproject.tool.cover.SessionManager;
import org.sakaiproject.tool.cover.ToolManager;

public class WorksiteManagerImpl
implements WorksiteManager {
    protected final transient Log logger = LogFactory.getLog(this.getClass());
    private IdManager idManager = null;

    public List getUserSites() {
        return this.getUserSites(null);
    }

    public List getUserSites(Map properties) {
        return this.getUserSites(properties, null);
    }

    public List getUserSites(Map properties, List siteTypes) {
        List mySites = !(properties != null && !properties.isEmpty() || siteTypes != null && !siteTypes.isEmpty()) ? SiteService.getUserSites() : SiteService.getSites((SiteService.SelectionType)SiteService.SelectionType.ACCESS, (Object)siteTypes, null, (Map)properties, (SiteService.SortType)SiteService.SortType.NONE, null);
        if (mySites.size() > 0) {
            Collections.sort(mySites);
        }
        return mySites;
    }

    public Id getCurrentWorksiteId() {
        Placement currentPlacement = ToolManager.getCurrentPlacement();
        if (currentPlacement == null && (currentPlacement = this.getToolSessionPlacement()) == null) {
            return null;
        }
        String id = currentPlacement.getContext();
        if (id != null) {
            return this.getIdManager().getId(id);
        }
        return null;
    }

    protected Placement getToolSessionPlacement() {
        ToolSession session = SessionManager.getCurrentToolSession();
        if (session == null) {
            return null;
        }
        String placementId = session.getPlacementId();
        return this.getTool(placementId);
    }

    public List getSiteTools(String toolId, Site site) {
        ArrayList<ToolConfiguration> tools = new ArrayList<ToolConfiguration>();
        List pages = site.getPages();
        for (SitePage page : pages) {
            for (ToolConfiguration tool : page.getTools()) {
                if (toolId == null) {
                    tools.add(tool);
                    continue;
                }
                if (!toolId.equals(tool.getToolId())) continue;
                tools.add(tool);
            }
        }
        return tools;
    }

    public Site getSite(String siteId) {
        try {
            return SiteService.getSite((String)siteId);
        }
        catch (IdUnusedException e) {
            this.logger.error((Object)"", (Throwable)e);
            throw new OspException((Throwable)e);
        }
    }

    public AuthzGroup getSiteRealm(String siteId) {
        AuthzGroup siteRealm = null;
        try {
            siteRealm = AuthzGroupService.getAuthzGroup((String)("/site/" + siteId));
        }
        catch (GroupNotDefinedException e) {
            this.logger.error((Object)"", (Throwable)e);
            throw new OspException((Throwable)e);
        }
        return siteRealm;
    }

    public ToolConfiguration getTool(String id) {
        return SiteService.findTool((String)id);
    }

    public boolean isUserInSite(String siteId) {
        return SiteService.allowAccessSite((String)siteId);
    }

    public IdManager getIdManager() {
        return this.idManager;
    }

    public void setIdManager(IdManager idManager) {
        this.idManager = idManager;
    }
}

