/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.metaobj.utils.xml.impl;

import java.net.URI;
import java.net.URISyntaxException;
import org.jdom.Element;
import org.jdom.Namespace;
import org.sakaiproject.metaobj.utils.xml.NormalizationException;
import org.sakaiproject.metaobj.utils.xml.SchemaNode;
import org.sakaiproject.metaobj.utils.xml.impl.BaseElementType;

public class UriElementType
extends BaseElementType {
    private static final String SAKAI_REF_SCHEME = "sakairef";

    public UriElementType(String typeName, Element schemaElement, SchemaNode parentNode, Namespace xsdNamespace) {
        super(typeName, schemaElement, parentNode, xsdNamespace);
    }

    @Override
    public Class getObjectType() {
        return URI.class;
    }

    @Override
    public Object getActualNormalizedValue(String value) {
        try {
            if (value.startsWith("/")) {
                return new URI(SAKAI_REF_SCHEME, value, null);
            }
            return new URI(value);
        }
        catch (URISyntaxException e) {
            throw new NormalizationException("Invalid URI", "INVALID_URI", new Object[]{value});
        }
    }

    @Override
    public String getSchemaNormalizedValue(String value) throws NormalizationException {
        return this.getSchemaNormalizedValue(this.getActualNormalizedValue(value));
    }

    @Override
    public String getSchemaNormalizedValue(Object value) throws NormalizationException {
        if (value != null) {
            URI uri = (URI)value;
            if (uri.getScheme().equals(SAKAI_REF_SCHEME)) {
                return uri.getSchemeSpecificPart();
            }
            return uri.toString();
        }
        return null;
    }
}

