/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.metaobj.utils.xml.impl;

import java.util.List;
import org.jdom.Attribute;
import org.jdom.Element;
import org.sakaiproject.metaobj.utils.xml.ElementType;
import org.sakaiproject.metaobj.utils.xml.NormalizationException;
import org.sakaiproject.metaobj.utils.xml.SchemaInvalidException;
import org.sakaiproject.metaobj.utils.xml.ValidatedNode;
import org.sakaiproject.metaobj.utils.xml.ValidationError;
import org.sakaiproject.metaobj.utils.xml.impl.BaseElementType;
import org.sakaiproject.metaobj.utils.xml.impl.ElementTypeFactory;
import org.sakaiproject.metaobj.utils.xml.impl.SchemaNodeImpl;
import org.sakaiproject.metaobj.utils.xml.impl.ValidatedNodeImpl;

public class SimpleSchemaNodeImpl
extends SchemaNodeImpl {
    private BaseElementType type;
    private boolean isAttribute = false;

    public SimpleSchemaNodeImpl(Element schemaElement, SchemaNodeImpl.GlobalMaps globalMaps, boolean isAttribute) throws SchemaInvalidException {
        super(schemaElement, globalMaps);
        this.isAttribute = isAttribute;
    }

    @Override
    protected void initSchemaElement() {
        super.initSchemaElement();
        this.type = ElementTypeFactory.getInstance().createElementType(this.getSchemaElement(), this, this.xsdNamespace);
    }

    @Override
    public ValidatedNode validateAndNormalize(Element node) {
        return this.type.validateAndNormalize(node);
    }

    @Override
    public ValidatedNode validateAndNormalize(Attribute node) {
        ValidatedNodeImpl validatedNode = new ValidatedNodeImpl(this, null);
        if (!this.isAttribute()) {
            validatedNode.getErrors().add(new ValidationError(validatedNode, "not an attribute", new Object[0]));
        }
        return this.type.validateAndNormalize(node);
    }

    @Override
    public String getSchemaNormalizedValue(Object value) throws NormalizationException {
        if (value instanceof String) {
            return this.type.getSchemaNormalizedValue((String)value);
        }
        return this.type.getSchemaNormalizedValue(value);
    }

    @Override
    public Object getActualNormalizedValue(String value) throws NormalizationException {
        return this.type.getActualNormalizedValue(value);
    }

    @Override
    public Class getObjectType() {
        return this.type.getObjectType();
    }

    public int getMaxLength() {
        return this.type.maxLength;
    }

    @Override
    public ElementType getType() {
        return this.type;
    }

    @Override
    public List getEnumeration() {
        return this.type.getEnumeration();
    }

    @Override
    public boolean isAttribute() {
        return this.isAttribute;
    }

    @Override
    public boolean isDataNode() {
        return true;
    }
}

