/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.metaobj.utils.xml.impl;

import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import org.jdom.Element;
import org.jdom.Namespace;
import org.sakaiproject.metaobj.utils.xml.NormalizationException;
import org.sakaiproject.metaobj.utils.xml.SchemaInvalidException;
import org.sakaiproject.metaobj.utils.xml.SchemaNode;
import org.sakaiproject.metaobj.utils.xml.ValueRange;
import org.sakaiproject.metaobj.utils.xml.impl.FormatterElementType;
import org.sakaiproject.metaobj.utils.xml.impl.NumberValueRange;
import org.sakaiproject.util.ResourceLoader;

public class NumberElementType
extends FormatterElementType {
    protected Number maxIncl = null;
    protected Number minIncl = null;
    protected Number maxExcl = null;
    protected Number minExcl = null;
    protected int totalDigits = -1;
    private ValueRange range = null;
    private Format format = NumberFormat.getIntegerInstance(new ResourceLoader().getLocale());

    public NumberElementType(String typeName, Element schemaElement, SchemaNode parentNode, Namespace xsdNamespace) {
        super(typeName, schemaElement, parentNode, xsdNamespace);
        Element restrictions;
        this.totalDigits = new String("9223372036854775807").length();
        Element simpleType = schemaElement.getChild("simpleType", xsdNamespace);
        if (simpleType != null && (restrictions = simpleType.getChild("restriction", xsdNamespace)) != null) {
            try {
                this.maxIncl = (Number)this.getFormattedRestriction(restrictions, "maxInclusive", xsdNamespace);
                this.minIncl = (Number)this.getFormattedRestriction(restrictions, "minInclusive", xsdNamespace);
                this.maxExcl = (Number)this.getFormattedRestriction(restrictions, "maxExclusive", xsdNamespace);
                this.minExcl = (Number)this.getFormattedRestriction(restrictions, "minExclusive", xsdNamespace);
            }
            catch (ParseException e) {
                throw new SchemaInvalidException(e);
            }
            this.totalDigits = this.processIntRestriction(restrictions, "totalDigits", xsdNamespace, this.totalDigits);
        }
        if (this.maxIncl != null || this.minIncl != null || this.maxExcl != null || this.minExcl != null) {
            Comparable max;
            Comparable min = (Comparable)((Object)this.minIncl);
            if (min == null) {
                min = (Comparable)((Object)this.minExcl);
            }
            if ((max = (Comparable)((Object)this.maxIncl)) == null) {
                max = (Comparable)((Object)this.maxExcl);
            }
            this.range = new NumberValueRange(max, min, this.maxIncl != null, this.minIncl != null);
        }
    }

    @Override
    protected Format getFormatter() {
        return this.format;
    }

    @Override
    protected Object checkConstraints(Object o) {
        int i = ((Number)o).intValue();
        if (this.maxIncl != null && i > this.maxIncl.intValue()) {
            throw new NormalizationException("Invalid number", "TOO_LARGE_INCLUSIVE_ERROR_CODE", new Object[]{o, this.maxIncl});
        }
        if (this.minIncl != null && i < this.minIncl.intValue()) {
            throw new NormalizationException("Invalid number", "TOO_SMALL_INCLUSIVE_ERROR_CODE", new Object[]{o, this.minIncl});
        }
        if (this.maxExcl != null && i >= this.maxExcl.intValue()) {
            throw new NormalizationException("Invalid number", "TOO_LARGE_ERROR_CODE", new Object[]{o, this.maxExcl});
        }
        if (this.minExcl != null && i <= this.minExcl.intValue()) {
            throw new NormalizationException("Invalid number", "TOO_SMALL_ERROR_CODE", new Object[]{o, this.minExcl});
        }
        if (this.totalDigits != -1 && o.toString().length() > this.totalDigits) {
            throw new NormalizationException("Invalid number", "TOO_MANY_DIGITS_ERROR_CODE", new Object[]{o, new Integer(this.totalDigits)});
        }
        return o;
    }

    @Override
    protected String parserException(String value, ParseException e) {
        throw new NormalizationException("Invalid number", "INVALID_NUMBER_ERROR_CODE", new Object[]{value});
    }

    @Override
    public Class getObjectType() {
        return Number.class;
    }

    @Override
    public int getMaxLength() {
        return this.totalDigits;
    }

    @Override
    public ValueRange getRange() {
        return this.range;
    }
}

