/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.metaobj.utils.xml.impl;

import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jdom.Element;
import org.jdom.Namespace;
import org.sakaiproject.metaobj.utils.xml.NormalizationException;
import org.sakaiproject.metaobj.utils.xml.SchemaInvalidException;
import org.sakaiproject.metaobj.utils.xml.SchemaNode;
import org.sakaiproject.metaobj.utils.xml.ValueRange;
import org.sakaiproject.metaobj.utils.xml.impl.FormatterElementType;

public class DateFormatterElementType
extends FormatterElementType {
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final String TIME_FORMAT = "hh:mm:ss";
    private static final String DATE_TIME_FORMAT = "yyyy-MM-dd'T'hh:mm:ss";
    private static final String DATE_TYPE = "xs:date";
    private static final String TIME_TYPE = "xs:time";
    private static final String DATE_TIME_TYPE = "xs:dateTime";
    private Format formatter = null;
    private String format = null;
    private Date maxIncl = null;
    private Date minIncl = null;
    private Date maxExcl = null;
    private Date minExcl = null;
    private ValueRange range = null;

    public DateFormatterElementType(String typeName, Element schemaElement, SchemaNode parentNode, Namespace xsdNamespace) {
        super(typeName, schemaElement, parentNode, xsdNamespace);
        Element restrictions;
        if (typeName.equals(DATE_TYPE)) {
            this.format = DATE_FORMAT;
        } else if (typeName.equals(TIME_TYPE)) {
            this.format = TIME_FORMAT;
        } else if (typeName.equals(DATE_TIME_TYPE)) {
            this.format = DATE_TIME_FORMAT;
        } else {
            throw new IllegalArgumentException();
        }
        this.formatter = new SimpleDateFormat(this.format);
        Element simpleType = schemaElement.getChild("simpleType", xsdNamespace);
        if (simpleType != null && (restrictions = simpleType.getChild("restriction", xsdNamespace)) != null) {
            try {
                this.maxIncl = (Date)this.getFormattedRestriction(restrictions, "maxInclusive", xsdNamespace);
                this.minIncl = (Date)this.getFormattedRestriction(restrictions, "minInclusive", xsdNamespace);
                this.maxExcl = (Date)this.getFormattedRestriction(restrictions, "maxExclusive", xsdNamespace);
                this.minExcl = (Date)this.getFormattedRestriction(restrictions, "minExclusive", xsdNamespace);
            }
            catch (ParseException e) {
                throw new SchemaInvalidException(e);
            }
        }
        if (this.maxIncl != null || this.minIncl != null || this.maxExcl != null || this.minExcl != null) {
            Date max;
            Date min = this.minIncl;
            if (min == null) {
                min = this.minExcl;
            }
            if ((max = this.maxIncl) == null) {
                max = this.maxExcl;
            }
            this.range = new ValueRange((Comparable)max, (Comparable)min, this.maxIncl != null, this.minIncl != null);
        }
    }

    @Override
    protected Format getFormatter() {
        return this.formatter;
    }

    @Override
    protected Object checkConstraints(Object o) {
        Date date = (Date)o;
        if (this.maxIncl != null && date.after(this.maxIncl)) {
            throw new NormalizationException("Invalid date", "DATE_AFTER_ERROR_CODE", new Object[]{o, this.maxIncl});
        }
        if (this.minIncl != null && date.before(this.minIncl)) {
            throw new NormalizationException("Invalid date", "DATE_BEFORE_ERROR_CODE", new Object[]{o, this.minIncl});
        }
        if (this.maxExcl != null && !date.after(this.maxExcl)) {
            throw new NormalizationException("Invalid date", "DATE_TOO_LATE_ERROR_CODE", new Object[]{o, this.maxExcl});
        }
        if (this.minExcl != null && !date.before(this.minExcl)) {
            throw new NormalizationException("Invalid date", "DATE_TOO_EARLY_ERROR_CODE", new Object[]{o, this.minExcl});
        }
        return o;
    }

    @Override
    protected String parserException(String value, ParseException e) {
        throw new NormalizationException("Invalid date/time", "DATE_INVALID_ERROR_CODE", new Object[]{value, this.format});
    }

    @Override
    public Class getObjectType() {
        return Date.class;
    }

    @Override
    public ValueRange getRange() {
        return this.range;
    }
}

