/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.metaobj.utils.xml.impl;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.jdom.Attribute;
import org.jdom.Element;
import org.sakaiproject.metaobj.utils.xml.NormalizationException;
import org.sakaiproject.metaobj.utils.xml.SchemaInvalidException;
import org.sakaiproject.metaobj.utils.xml.SchemaNode;
import org.sakaiproject.metaobj.utils.xml.ValidatedNode;
import org.sakaiproject.metaobj.utils.xml.ValidationError;
import org.sakaiproject.metaobj.utils.xml.impl.CustomTypeSchemaNodeImpl;
import org.sakaiproject.metaobj.utils.xml.impl.SchemaNodeImpl;
import org.sakaiproject.metaobj.utils.xml.impl.SimpleSchemaNodeImpl;
import org.sakaiproject.metaobj.utils.xml.impl.ValidatedNodeImpl;

public class ComplexSchemaNodeImpl
extends SchemaNodeImpl {
    private String[] childrenElements;
    private Map childrenMap;
    private String[] childrenAttributes;
    private Map childrenAttributeMap;
    private String[] attributeGroupNames;
    private boolean orderDependant = false;
    private boolean attributeGroupsSetup = false;
    private SchemaNode extensionType;

    public ComplexSchemaNodeImpl(Element schemaElement, SchemaNodeImpl.GlobalMaps globalMaps) throws SchemaInvalidException {
        super(schemaElement, globalMaps);
    }

    @Override
    protected void initSchemaElement() {
        Element complexTypeElement;
        super.initSchemaElement();
        this.childrenMap = new Hashtable();
        this.childrenAttributeMap = new Hashtable();
        Element sequenceElement = null;
        Element attributeParentElement = null;
        attributeParentElement = complexTypeElement = this.getSchemaElement().getChild("complexType", this.xsdNamespace);
        sequenceElement = complexTypeElement.getChild("sequence", this.xsdNamespace);
        if (sequenceElement == null) {
            sequenceElement = complexTypeElement.getChild("choice", this.xsdNamespace);
        }
        if (sequenceElement == null) {
            Element content = complexTypeElement.getChild("complexContent", this.xsdNamespace);
            if (content == null) {
                content = complexTypeElement.getChild("simpleContent", this.xsdNamespace);
            }
            Element extension = content.getChild("extension", this.xsdNamespace);
            sequenceElement = extension.getChild("sequence", this.xsdNamespace);
            attributeParentElement = extension;
            String baseType = extension.getAttributeValue("base");
            this.extensionType = baseType.startsWith(this.xsdNamespace.getPrefix()) ? new SimpleSchemaNodeImpl(complexTypeElement, this.getGlobalMaps(), false) : new CustomTypeSchemaNodeImpl(complexTypeElement, this.getGlobalMaps(), baseType, false);
        }
        if (sequenceElement != null) {
            this.processSequence(sequenceElement);
        } else {
            this.childrenElements = new String[0];
        }
        this.processAttributes(attributeParentElement.getChildren("attribute", this.xsdNamespace));
        this.processAttributeGroups(attributeParentElement.getChildren("attributeGroup", this.xsdNamespace));
    }

    private void processAttributeGroups(List childList) {
        this.attributeGroupNames = new String[childList.size()];
        for (int i = 0; i < this.attributeGroupNames.length; ++i) {
            Element currentElement = (Element)childList.get(i);
            this.attributeGroupNames[i] = currentElement.getAttributeValue("ref");
        }
    }

    protected void processAttributes(List childList) {
        this.childrenAttributes = new String[childList.size()];
        for (int i = 0; i < this.childrenAttributes.length; ++i) {
            Element currentElement = (Element)childList.get(i);
            this.childrenAttributes[i] = currentElement.getAttributeValue("name");
            if (this.childrenAttributes[i] == null) {
                this.childrenAttributes[i] = currentElement.getAttributeValue("ref");
            }
            this.childrenAttributeMap.put(this.childrenAttributes[i], this.createNode(currentElement, true));
        }
    }

    protected void processSequence(Element sequenceElement) {
        List childList = sequenceElement.getChildren("element", this.xsdNamespace);
        this.childrenElements = new String[childList.size()];
        for (int i = 0; i < this.childrenElements.length; ++i) {
            Element currentElement = (Element)childList.get(i);
            this.childrenElements[i] = currentElement.getAttributeValue("name");
            if (this.childrenElements[i] == null) {
                this.childrenElements[i] = currentElement.getAttributeValue("ref");
            }
            this.childrenMap.put(this.childrenElements[i], this.createNode(currentElement));
        }
        if (sequenceElement.getName().equals("sequence")) {
            this.orderDependant = true;
        }
    }

    @Override
    public ValidatedNode validateAndNormalize(Element node) {
        SchemaNode currentSchemaNode;
        this.setupAttributeGroups();
        ValidatedNodeImpl validatedNode = new ValidatedNodeImpl(this, node);
        for (int i = 0; i < this.childrenElements.length; ++i) {
            ValidatedNodeImpl validatedChildNode;
            SchemaNode currentSchemaNode2 = (SchemaNode)this.childrenMap.get(this.childrenElements[i]);
            int actualNumberOfElements = node.getChildren(this.childrenElements[i]).size();
            if (actualNumberOfElements == 0 && currentSchemaNode2.getMinOccurs() == 1) {
                validatedChildNode = new ValidatedNodeImpl(currentSchemaNode2, null);
                validatedChildNode.getErrors().add(new ValidationError(validatedChildNode, "Required field: {0}", new Object[]{this.childrenElements[i]}));
                validatedNode.getChildren().add(validatedChildNode);
                continue;
            }
            if (actualNumberOfElements > currentSchemaNode2.getMaxOccurs() && currentSchemaNode2.getMaxOccurs() != -1) {
                validatedChildNode = new ValidatedNodeImpl(currentSchemaNode2, null);
                validatedChildNode.getErrors().add(new ValidationError(validatedChildNode, "Too many elements {0}, {1}", new Object[]{this.childrenElements[i], new Integer(this.getMaxOccurs())}));
                validatedNode.getChildren().add(validatedChildNode);
                continue;
            }
            if (actualNumberOfElements >= currentSchemaNode2.getMinOccurs()) continue;
            validatedChildNode = new ValidatedNodeImpl(currentSchemaNode2, null);
            validatedChildNode.getErrors().add(new ValidationError(validatedChildNode, "Too few elements {0}, {1}", new Object[]{this.childrenElements[i], new Integer(this.getMinOccurs())}));
            validatedNode.getChildren().add(validatedChildNode);
        }
        List children = node.getChildren();
        for (Element currentElement : children) {
            currentSchemaNode = (SchemaNode)this.childrenMap.get(currentElement.getName());
            if (currentSchemaNode == null) {
                validatedNode.getErrors().add(new ValidationError("Unkown node {0}", new Object[]{currentElement.getName()}));
                continue;
            }
            validatedNode.getChildren().add(currentSchemaNode.validateAndNormalize(currentElement));
        }
        children = node.getAttributes();
        for (Attribute currentAttribute : children) {
            currentSchemaNode = (SchemaNode)this.childrenAttributeMap.get(currentAttribute.getName());
            if (currentSchemaNode == null) {
                validatedNode.getErrors().add(new ValidationError("Unkown node {0}", new Object[]{currentAttribute.getName()}));
                continue;
            }
            validatedNode.getChildren().add(currentSchemaNode.validateAndNormalize(currentAttribute));
        }
        return validatedNode;
    }

    protected synchronized void setupAttributeGroups() {
        if (this.attributeGroupsSetup) {
            return;
        }
        this.attributeGroupsSetup = true;
        ArrayList<SchemaNode> newAttributes = new ArrayList<SchemaNode>();
        for (int i = 0; i < this.attributeGroupNames.length; ++i) {
            SchemaNode[] nodes = (SchemaNode[])this.getGlobalMaps().globalAttributeGroups.get(this.attributeGroupNames[i]);
            for (int j = 0; j < nodes.length; ++j) {
                newAttributes.add(nodes[j]);
            }
        }
        String[] newAttributeNames = new String[this.childrenAttributes.length + newAttributes.size()];
        System.arraycopy(this.childrenAttributes, 0, newAttributeNames, 0, this.childrenAttributes.length);
        int index = this.childrenAttributes.length;
        for (SchemaNode node : newAttributes) {
            newAttributeNames[index] = node.getName();
            this.childrenAttributeMap.put(node.getName(), node);
            ++index;
        }
        this.childrenAttributes = newAttributeNames;
    }

    @Override
    public SchemaNode getChild(String elementName) {
        if (this.childrenMap.get(elementName) != null) {
            return (SchemaNode)this.childrenMap.get(elementName);
        }
        if (this.getClass().isInstance(this.extensionType)) {
            return this.extensionType.getChild(elementName);
        }
        this.setupAttributeGroups();
        return (SchemaNode)this.childrenAttributeMap.get(elementName);
    }

    @Override
    public String getSchemaNormalizedValue(Object value) throws NormalizationException {
        if (this.extensionType != null) {
            return this.extensionType.getSchemaNormalizedValue(value);
        }
        throw new UnsupportedOperationException("Cannot call this without this being the document node.");
    }

    @Override
    public Class getObjectType() {
        if (this.getMaxOccurs() > 1) {
            return List.class;
        }
        return Map.class;
    }

    @Override
    public List getChildren() {
        int i;
        this.setupAttributeGroups();
        ArrayList returnedList = new ArrayList();
        if (this.extensionType != null && this.extensionType.getChildren() != null) {
            returnedList.addAll(this.extensionType.getChildren());
        }
        for (i = 0; i < this.childrenElements.length; ++i) {
            returnedList.add(this.childrenMap.get(this.childrenElements[i]));
        }
        for (i = 0; i < this.childrenAttributes.length; ++i) {
            returnedList.add(this.childrenAttributeMap.get(this.childrenAttributes[i]));
        }
        return returnedList;
    }

    @Override
    public boolean isDataNode() {
        if (this.extensionType != null) {
            return this.extensionType.isDataNode();
        }
        return false;
    }

    @Override
    public boolean hasEnumerations() {
        if (this.extensionType != null) {
            return this.extensionType.hasEnumerations();
        }
        return false;
    }

    @Override
    public List getEnumeration() {
        if (this.extensionType != null) {
            return this.extensionType.getEnumeration();
        }
        return super.getEnumeration();
    }

    @Override
    public Object getActualNormalizedValue(String value) throws NormalizationException {
        if (this.extensionType != null) {
            return this.extensionType.getActualNormalizedValue(value);
        }
        return super.getActualNormalizedValue(value);
    }
}

