/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.metaobj.utils.xml.impl;

import org.jdom.Element;
import org.jdom.Namespace;
import org.sakaiproject.metaobj.utils.xml.NormalizationException;
import org.sakaiproject.metaobj.utils.xml.SchemaNode;
import org.sakaiproject.metaobj.utils.xml.impl.BaseElementType;

public class BooleanElementType
extends BaseElementType {
    private boolean required = false;

    public BooleanElementType(String typeName, Element schemaElement, SchemaNode parentNode, Namespace xsdNamespace) {
        super(typeName, schemaElement, parentNode, xsdNamespace);
        this.required = parentNode.getMinOccurs() >= 1;
    }

    @Override
    public String getSchemaNormalizedValue(Object value) throws NormalizationException {
        if (this.required && (value == null || !((Boolean)value).booleanValue())) {
            throw new NormalizationException("Required field", "REQIRED_FIELD_ERROR_CODE", new Object[0]);
        }
        return value.toString();
    }

    @Override
    public String getSchemaNormalizedValue(String value) throws NormalizationException {
        return new Boolean(value).toString();
    }

    @Override
    public Class getObjectType() {
        return Boolean.class;
    }

    @Override
    public Object getActualNormalizedValue(String value) {
        return new Boolean(value);
    }
}

