/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.metaobj.utils.xml.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Namespace;
import org.sakaiproject.metaobj.utils.xml.ElementType;
import org.sakaiproject.metaobj.utils.xml.NormalizationException;
import org.sakaiproject.metaobj.utils.xml.SchemaNode;
import org.sakaiproject.metaobj.utils.xml.ValidatedNode;
import org.sakaiproject.metaobj.utils.xml.ValidationError;
import org.sakaiproject.metaobj.utils.xml.ValueRange;
import org.sakaiproject.metaobj.utils.xml.impl.ValidatedNodeImpl;
import org.sakaiproject.util.FormattedText;

public class BaseElementType
implements ElementType {
    protected static final int WHITE_SPACE_TYPE_NONE = 0;
    protected static final int WHITE_SPACE_TYPE_PRESERVE = 1;
    protected static final int WHITE_SPACE_TYPE_REPLACE = 2;
    protected static final int WHITE_SPACE_TYPE_COLLAPSE = 3;
    protected int length = -1;
    protected int maxLength = -1;
    protected int minLength = -1;
    protected Pattern pattern = null;
    protected int whiteSpaceType = 0;
    protected String defaultValue = "";
    protected String fixedValue = "";
    protected Element schemaElement;
    protected SchemaNode parentNode = null;
    private List enumeration = null;
    private String baseType;
    private boolean richText = false;

    public BaseElementType(String typeName, Element schemaElement, SchemaNode parentNode, Namespace xsdNamespace) {
        this.setBaseType(typeName);
        this.schemaElement = schemaElement;
        this.parentNode = parentNode;
        this.init(xsdNamespace);
    }

    protected void init(Namespace xsdNamespace) {
        Element restrictions;
        Element simpleType = this.schemaElement.getChild("simpleType", xsdNamespace);
        if (simpleType != null && (restrictions = simpleType.getChild("restriction", xsdNamespace)) != null) {
            String whiteSpaceValue;
            this.length = this.processIntRestriction(restrictions, "length", xsdNamespace, this.length);
            this.maxLength = this.processIntRestriction(restrictions, "maxLength", xsdNamespace, this.maxLength);
            this.minLength = this.processIntRestriction(restrictions, "minLength", xsdNamespace, this.minLength);
            String patternValue = this.processStringRestriction(restrictions, "pattern", xsdNamespace);
            if (patternValue != null) {
                this.pattern = Pattern.compile(patternValue);
            }
            if ((whiteSpaceValue = this.processStringRestriction(restrictions, "whiteSpace", xsdNamespace)) != null) {
                if (whiteSpaceValue.equals("preserve")) {
                    this.whiteSpaceType = 1;
                }
                if (whiteSpaceValue.equals("replace")) {
                    this.whiteSpaceType = 2;
                }
                if (whiteSpaceValue.equals("collapse")) {
                    this.whiteSpaceType = 3;
                }
            }
        }
        if (this.schemaElement.getAttribute("default") != null) {
            this.defaultValue = this.schemaElement.getAttributeValue("default");
        }
        if (this.schemaElement.getAttribute("fixed") != null) {
            this.defaultValue = this.fixedValue = this.schemaElement.getAttributeValue("fixed");
        }
        if (this.parentNode.getDocumentAnnotation("ospi.isRichText") != null || this.parentNode.getDocumentAnnotation("sakai.isRichText") != null) {
            this.richText = true;
        }
    }

    protected void processEnumerations(Element restrictions, Namespace xsdNamespace) {
        List enums = restrictions.getChildren("enumeration", xsdNamespace);
        ArrayList<Object> temp = null;
        this.enumeration = null;
        if (enums.size() > 0) {
            temp = new ArrayList<Object>();
        }
        for (Element enumer : enums) {
            String value = enumer.getAttributeValue("value");
            temp.add(this.getActualNormalizedValue(value));
        }
        this.enumeration = temp;
    }

    protected String processStringRestriction(Element restrictions, String s, Namespace xsdNamespace) {
        Element currentRestriction = restrictions.getChild(s, xsdNamespace);
        if (currentRestriction == null) {
            return null;
        }
        return currentRestriction.getAttributeValue("value");
    }

    protected int processIntRestriction(Element restrictions, String s, Namespace xsdNamespace, int defaultValue) {
        String value = this.processStringRestriction(restrictions, s, xsdNamespace);
        if (value == null) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    public ValidatedNode validateAndNormalize(Element node) {
        ValidatedNodeImpl validatedNode = new ValidatedNodeImpl(this.parentNode, node);
        String value = node.getText();
        try {
            value = this.getSchemaNormalizedValue(value);
            node.setText(value);
            validatedNode.setNormalizedValue(this.getActualNormalizedValue(value));
            if (value == null || value.length() == 0) {
                return null;
            }
        }
        catch (NormalizationException exp) {
            validatedNode.getErrors().add(new ValidationError(validatedNode, exp.getErrorCode(), exp.getErrorInfo()));
        }
        return validatedNode;
    }

    public String getSchemaNormalizedValue(Object value) throws NormalizationException {
        if (value == null) {
            return null;
        }
        return this.getSchemaNormalizedValue(value.toString());
    }

    public String getSchemaNormalizedValue(String value) throws NormalizationException {
        if (value == null) {
            return this.defaultValue;
        }
        if (this.fixedValue != null && this.fixedValue.length() > 0) {
            return this.fixedValue;
        }
        String startingValue = this.handleWhiteSpace(value.toString());
        int valueLength = startingValue.length();
        if (this.richText) {
            StringBuilder errors = new StringBuilder();
            String newValue = FormattedText.processFormattedText((String)startingValue, (StringBuilder)errors);
            if (errors.length() > 0) {
                throw new NormalizationException(errors.toString(), "RICH_TEXT_FORMAT_PASSTHROUGH", new Object[]{errors.toString()});
            }
            startingValue = newValue;
        }
        if (this.length != -1 && valueLength != this.length) {
            throw new NormalizationException("Invalid string length", "INVALID_LENGTH_ERROR_CODE", new Object[]{startingValue, new Integer(this.length)});
        }
        if (this.maxLength != -1 && valueLength > this.maxLength) {
            String val = startingValue;
            if (startingValue.length() > 100) {
                val = val.substring(0, 100) + "...";
            }
            throw new NormalizationException("Invalid string length", "INVALID_LENGTH_TOO_LONG_ERROR_CODE", new Object[]{val, new Integer(this.maxLength)});
        }
        if (this.minLength != -1 && valueLength < this.minLength && this.minLength == 1) {
            throw new NormalizationException("Required field", "REQIRED_FIELD_ERROR_CODE", new Object[0]);
        }
        if (this.minLength != -1 && valueLength < this.minLength) {
            throw new NormalizationException("Invalid string length", "INVALID_LENGTH_TOO_SHORT_ERROR_CODE", new Object[]{startingValue, new Integer(this.minLength)});
        }
        if (this.pattern != null && !this.pattern.matcher(startingValue).matches()) {
            throw new NormalizationException("Invalid string pattern", "INVALID_PATTERN_MATCH_ERROR_CODE", new Object[]{startingValue, this.pattern.pattern()});
        }
        return startingValue;
    }

    private String handleWhiteSpace(String s) {
        if (this.whiteSpaceType == 0 || this.whiteSpaceType == 1) {
            return s;
        }
        if (this.whiteSpaceType == 2) {
            s = s.replaceAll("\\s", " ");
        } else if (this.whiteSpaceType == 3) {
            s = s.replaceAll("\\s+", " ");
        }
        return s;
    }

    public Class getObjectType() {
        return String.class;
    }

    public Object getActualNormalizedValue(String value) {
        String returned = this.getSchemaNormalizedValue(value);
        if (this.enumeration != null && !this.enumeration.contains(returned)) {
            throw new NormalizationException("Not enumerated", "NOT_IN_ENUMERATION_ERROR_CODE", new Object[]{returned});
        }
        return returned;
    }

    public int getLength() {
        return this.length;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public ValueRange getRange() {
        return null;
    }

    public int getWhiteSpaceType() {
        return this.whiteSpaceType;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getFixedValue() {
        return this.fixedValue;
    }

    public List getEnumeration() {
        return this.enumeration;
    }

    public BaseElementType postInit(Namespace xsdNamespace) {
        Element restrictions;
        Element simpleType = this.schemaElement.getChild("simpleType", xsdNamespace);
        if (simpleType != null && (restrictions = simpleType.getChild("restriction", xsdNamespace)) != null) {
            this.processEnumerations(restrictions, xsdNamespace);
        }
        return this;
    }

    public ValidatedNode validateAndNormalize(Attribute node) {
        ValidatedNodeImpl validatedNode = new ValidatedNodeImpl(this.parentNode, null);
        String value = node.getValue();
        try {
            value = this.getSchemaNormalizedValue(value);
            node.setValue(value);
            validatedNode.setNormalizedValue(this.getActualNormalizedValue(value));
            if (value == null || value.length() == 0) {
                return null;
            }
        }
        catch (NormalizationException exp) {
            validatedNode.getErrors().add(new ValidationError(validatedNode, exp.getErrorCode(), exp.getErrorInfo()));
        }
        return validatedNode;
    }

    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }
}

