/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.metaobj.utils.xml;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Hashtable;
import org.jdom.Document;
import org.jdom.input.SAXBuilder;
import org.sakaiproject.metaobj.utils.xml.SchemaInvalidException;
import org.sakaiproject.metaobj.utils.xml.SchemaNode;
import org.sakaiproject.metaobj.utils.xml.impl.SchemaNodeImpl;

public class SchemaFactory {
    private static SchemaFactory schemaFactory = new SchemaFactory();
    private Hashtable schemas = new Hashtable();

    private SchemaFactory() {
    }

    public static SchemaFactory getInstance() {
        return schemaFactory;
    }

    public SchemaNode getSchema(File in) {
        if (this.schemas.get(in) != null) {
            return (SchemaNode)this.schemas.get(in);
        }
        SAXBuilder builder = new SAXBuilder();
        builder.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        try {
            Document doc = builder.build(in);
            SchemaNodeImpl node = new SchemaNodeImpl(doc, this, in);
            this.schemas.put(in, node);
            return node;
        }
        catch (Exception e) {
            throw new SchemaInvalidException(e);
        }
    }

    public SchemaNode getSchema(InputStream in) {
        SAXBuilder builder = new SAXBuilder();
        builder.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        try {
            Document doc = builder.build(in);
            SchemaNodeImpl node = new SchemaNodeImpl(doc, this, in);
            return node;
        }
        catch (Exception e) {
            throw new SchemaInvalidException(e);
        }
    }

    public SchemaNode getSchema(InputStream in, String systemId) {
        if (this.schemas.get(systemId) != null) {
            return (SchemaNode)this.schemas.get(systemId);
        }
        SAXBuilder builder = new SAXBuilder();
        builder.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        try {
            Document doc = builder.build(in, systemId);
            SchemaNodeImpl node = new SchemaNodeImpl(doc, this, in);
            this.schemas.put(systemId, node);
            return node;
        }
        catch (Exception e) {
            throw new SchemaInvalidException(e);
        }
    }

    public SchemaNode getSchema(Reader characterStream, String systemId) {
        if (this.schemas.get(systemId) != null) {
            return (SchemaNode)this.schemas.get(systemId);
        }
        SAXBuilder builder = new SAXBuilder();
        builder.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        try {
            Document doc = builder.build(characterStream, systemId);
            SchemaNodeImpl node = new SchemaNodeImpl(doc, this, systemId);
            this.schemas.put(systemId, node);
            return node;
        }
        catch (Exception e) {
            throw new SchemaInvalidException(e);
        }
    }

    public SchemaNode getSchema(String systemId) {
        if (this.schemas.get(systemId) != null) {
            return (SchemaNode)this.schemas.get(systemId);
        }
        SAXBuilder builder = new SAXBuilder();
        builder.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        try {
            Document doc = builder.build(systemId);
            SchemaNodeImpl node = new SchemaNodeImpl(doc, this, systemId);
            this.schemas.put(systemId, node);
            return node;
        }
        catch (Exception e) {
            throw new SchemaInvalidException(e);
        }
    }

    public SchemaNode getSchema(URL url) {
        if (this.schemas.get(url) != null) {
            return (SchemaNode)this.schemas.get(url);
        }
        SAXBuilder builder = new SAXBuilder();
        builder.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        try {
            Document doc = builder.build(url);
            SchemaNodeImpl node = new SchemaNodeImpl(doc, this, url);
            this.schemas.put(url, node);
            return node;
        }
        catch (Exception e) {
            throw new SchemaInvalidException(e);
        }
    }

    public SchemaNode getRelativeSchema(String schemaLocation, Object path) {
        try {
            if (path instanceof URL) {
                URL urlPath = (URL)path;
                URL schemaUrl = new URL(urlPath, schemaLocation);
                return this.getSchema(schemaUrl);
            }
            if (path instanceof File) {
                File filePath = (File)path;
                File schemaFile = new File(filePath.getParentFile(), schemaLocation);
                return this.getSchema(schemaFile);
            }
            URL urlPath = new URL(path.toString());
            URL schemaUrl = new URL(urlPath, schemaLocation);
            return this.getSchema(schemaUrl);
        }
        catch (Exception exp) {
            throw new SchemaInvalidException(exp);
        }
    }

    public void reload() {
        this.schemas = new Hashtable();
    }
}

