/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.metaobj.utils.id.guid;

public class ByteOrder {
    private static final int UNSIGNED_BYTE_MASK = 255;

    public static byte[] reverse(byte[] x) {
        int n = x.length;
        byte[] ret = new byte[n];
        for (int i = 0; i < n; ++i) {
            ret[i] = x[n - i - 1];
        }
        return ret;
    }

    public static short leb2short(byte[] x, int offset) {
        int x0 = x[offset] & 0xFF;
        int x1 = x[offset + 1] << 8;
        return (short)(x1 | x0);
    }

    public static int leb2int(byte[] x, int offset) {
        int x0 = x[offset] & 0xFF;
        int x1 = x[offset + 1] << 8 & 0xFF00;
        int x2 = x[offset + 2] << 16 & 0xFF0000;
        int x3 = x[offset + 3] << 24;
        return x3 | x2 | x1 | x0;
    }

    public static void short2leb(short x, byte[] buf, int offset) {
        buf[offset] = (byte)(x & 0xFF);
        buf[offset + 1] = (byte)((short)(x >> 8) & 0xFF);
    }

    public static void int2leb(int x, byte[] buf, int offset) {
        buf[offset] = (byte)(x & 0xFF);
        buf[offset + 1] = (byte)(x >> 8 & 0xFF);
        buf[offset + 2] = (byte)(x >> 16 & 0xFF);
        buf[offset + 3] = (byte)(x >> 24 & 0xFF);
    }

    public static int ubyte2int(byte x) {
        return x & 0xFF;
    }

    public static int ubytes2int(short x) {
        return x & 0xFFFF;
    }

    public static long ubytes2long(int x) {
        return (long)x & 0xFFFFFFFFL;
    }

    public static int long2int(long l) {
        if (l >= Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (l <= Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)l;
    }
}

