/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.metaobj.shared.mgt.impl;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.sakaiproject.metaobj.shared.mgt.StructuredArtifactValidationService;
import org.sakaiproject.metaobj.shared.model.ElementBean;
import org.sakaiproject.metaobj.shared.model.ElementListBean;
import org.sakaiproject.metaobj.shared.model.ElementListBeanWrapper;
import org.sakaiproject.metaobj.shared.model.ValidationError;
import org.sakaiproject.metaobj.utils.mvc.intf.FieldValueWrapper;
import org.sakaiproject.metaobj.utils.xml.NormalizationException;
import org.sakaiproject.metaobj.utils.xml.SchemaNode;

public class StructuredArtifactValidationServiceImpl
implements StructuredArtifactValidationService {
    public List validate(ElementBean element) {
        ArrayList errors = new ArrayList();
        return this.validate(element, null, errors);
    }

    public List validate(ElementBean element, String parentName) {
        ArrayList errors = new ArrayList();
        return this.validate(element, parentName, errors);
    }

    protected List validate(ElementBean elementBean, String parentName, List errors) {
        SchemaNode currentNode = elementBean.getCurrentSchema();
        Element rootElement = elementBean.currentElement();
        List children = currentNode.getChildren();
        for (SchemaNode childSchema : children) {
            try {
                if (this.checkWrappedField(childSchema, elementBean, errors)) continue;
                Object value = elementBean.get((Object)childSchema.getName());
                if (value instanceof ElementBean) {
                    this.validate((ElementBean)value, this.composeName(parentName, childSchema.getName()), errors);
                    if (!childSchema.isDataNode()) continue;
                    ElementBean bean = (ElementBean)value;
                    if ((value = bean.currentElement().getTextTrim()).toString().length() == 0) {
                        value = null;
                    }
                    this.validateElement(rootElement, childSchema, value, parentName, errors);
                    continue;
                }
                if (value instanceof ElementListBean) {
                    boolean found = false;
                    Iterator iter = ((ElementListBean)value).iterator();
                    while (iter.hasNext()) {
                        found = true;
                        Object currentValue = iter.next();
                        this.validate((ElementBean)currentValue, this.composeName(parentName, childSchema.getName()), errors);
                        if (!childSchema.isDataNode()) continue;
                        ElementBean bean = (ElementBean)currentValue;
                        if ((currentValue = bean.currentElement().getTextTrim()).toString().length() == 0) {
                            currentValue = null;
                        }
                        try {
                            this.validateChildElement(bean.currentElement(), childSchema, currentValue, parentName, errors);
                        }
                        catch (NormalizationException exp) {
                            errors.add(new ValidationError(childSchema.getLabel(), this.composeName(parentName, childSchema.getName()), exp.getErrorCode(), exp.getErrorInfo(), MessageFormat.format(exp.getErrorCode(), exp.getErrorInfo())));
                        }
                    }
                    if (found) continue;
                    try {
                        this.validateChildElement(null, childSchema, null, parentName, errors);
                    }
                    catch (NormalizationException exp) {
                        errors.add(new ValidationError(childSchema.getLabel(), this.composeName(parentName, childSchema.getName()), exp.getErrorCode(), exp.getErrorInfo(), MessageFormat.format(exp.getErrorCode(), exp.getErrorInfo())));
                    }
                    continue;
                }
                if (value instanceof ElementListBeanWrapper) {
                    ((ElementListBeanWrapper)value).validate(errors);
                    if (((ElementListBeanWrapper)value).getList().size() >= childSchema.getMinOccurs()) continue;
                    errors.add(new ValidationError(childSchema.getLabel(), this.composeName(parentName, childSchema.getName()), "REQIRED_FIELD_ERROR_CODE", new Object[0], "REQIRED_FIELD_ERROR_CODE"));
                    continue;
                }
                if (childSchema.isAttribute()) {
                    Attribute childAttribute = rootElement.getAttribute(childSchema.getName());
                    if (childAttribute != null) {
                        String stringValue = null;
                        if (value != null && value instanceof String) {
                            stringValue = (String)value;
                            value = childSchema.getActualNormalizedValue(stringValue);
                        }
                        childAttribute.setValue(childSchema.getSchemaNormalizedValue(value));
                        continue;
                    }
                    if (childSchema.getMinOccurs() <= 0) continue;
                    errors.add(new ValidationError(childSchema.getLabel(), this.composeName(parentName, childSchema.getName()), "REQIRED_FIELD_ERROR_CODE", new Object[0], "REQIRED_FIELD_ERROR_CODE"));
                    continue;
                }
                this.validateElement(rootElement, childSchema, value, parentName, errors);
            }
            catch (NormalizationException exp) {
                errors.add(new ValidationError(childSchema.getLabel(), this.composeName(parentName, childSchema.getName()), exp.getErrorCode(), exp.getErrorInfo(), MessageFormat.format(exp.getErrorCode(), exp.getErrorInfo())));
            }
        }
        return errors;
    }

    protected void validateChildElement(Element parent, Element childElement, SchemaNode childSchema, Object value, String parentName, List errors) {
        if (value instanceof FieldValueWrapper) {
            FieldValueWrapper fieldValueWrapper = (FieldValueWrapper)value;
            fieldValueWrapper.validate(childSchema.getName(), errors, childSchema.getLabel());
            value = fieldValueWrapper.getValue();
            if (value != null && childElement == null) {
                childElement = new Element(childSchema.getName());
                parent.addContent((Content)childElement);
            }
        }
        this.validateChildElement(childElement, childSchema, value, parentName, errors);
    }

    protected void validateChildElement(Element childElement, SchemaNode childSchema, Object value, String parentName, List errors) {
        if (childElement != null) {
            String stringValue = null;
            if (value != null && value instanceof String) {
                stringValue = (String)value;
                value = childSchema.getActualNormalizedValue(stringValue);
            }
            childElement.setText(childSchema.getSchemaNormalizedValue(value));
        } else if (childSchema.getMinOccurs() > 0) {
            errors.add(new ValidationError(childSchema.getLabel(), this.composeName(parentName, childSchema.getName()), "REQIRED_FIELD_ERROR_CODE", new Object[0], "REQIRED_FIELD_ERROR_CODE"));
        }
    }

    protected void validateElement(Element rootElement, SchemaNode childSchema, Object value, String parentName, List errors) {
        this.validateChildElement(rootElement, rootElement.getChild(childSchema.getName()), childSchema, value, parentName, errors);
    }

    protected String composeName(String parentName, String name) {
        if (parentName == null) {
            return name;
        }
        return parentName + "." + name;
    }

    protected boolean checkWrappedField(SchemaNode childSchema, ElementBean elementBean, List errors) {
        return false;
    }
}

