/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.metaobj.shared.mgt.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.exception.ServerOverloadException;
import org.sakaiproject.metaobj.shared.mgt.ContentEntityUtil;
import org.sakaiproject.metaobj.shared.mgt.ContentEntityWrapper;
import org.sakaiproject.metaobj.shared.mgt.ContentHostingUtil;
import org.sakaiproject.metaobj.shared.mgt.HomeFactory;
import org.sakaiproject.metaobj.shared.mgt.IdManager;
import org.sakaiproject.metaobj.shared.mgt.PresentableObjectHome;
import org.sakaiproject.metaobj.shared.mgt.ReadableObjectHome;
import org.sakaiproject.metaobj.shared.mgt.home.StructuredArtifactHomeInterface;
import org.sakaiproject.metaobj.shared.model.Agent;
import org.sakaiproject.metaobj.shared.model.Artifact;
import org.sakaiproject.metaobj.shared.model.ContentResourceArtifact;
import org.sakaiproject.metaobj.shared.model.FinderException;
import org.sakaiproject.metaobj.shared.model.Id;
import org.sakaiproject.metaobj.shared.model.MimeType;
import org.sakaiproject.metaobj.shared.model.PersistenceException;
import org.sakaiproject.metaobj.shared.model.Type;
import org.sakaiproject.metaobj.utils.xml.SchemaNode;

public class ContentResourceHome
implements ReadableObjectHome,
PresentableObjectHome {
    private HomeFactory homeFactory;
    private IdManager idManager;

    public Type getType() {
        return new Type(this.getIdManager().getId("fileArtifact"), "Uploaded File");
    }

    public String getExternalType() {
        return "fileArtifact";
    }

    public Artifact load(Id id) throws PersistenceException {
        throw new UnsupportedOperationException("not implemented");
    }

    public Artifact createInstance() {
        throw new UnsupportedOperationException("not implemented");
    }

    public void prepareInstance(Artifact object) {
        throw new UnsupportedOperationException("not implemented");
    }

    public Artifact createSample() {
        throw new UnsupportedOperationException("not implemented");
    }

    public Collection findByOwner(Agent owner) throws FinderException {
        throw new UnsupportedOperationException("not implemented");
    }

    public boolean isInstance(Artifact testObject) {
        throw new UnsupportedOperationException("not implemented");
    }

    public void refresh() {
        throw new UnsupportedOperationException("not implemented");
    }

    public String getExternalUri(Id artifactId, String name) {
        throw new UnsupportedOperationException("not implemented");
    }

    public InputStream getStream(Id artifactId) {
        throw new UnsupportedOperationException("not implemented");
    }

    public boolean isSystemOnly() {
        throw new UnsupportedOperationException("not implemented");
    }

    public Class getInterface() {
        throw new UnsupportedOperationException("not implemented");
    }

    public Element getArtifactAsXml(Artifact art) {
        return this.getArtifactAsXml(art, null, null, null);
    }

    public Element getArtifactAsXml(Artifact art, String container, String site, String context) {
        ContentResourceArtifact artifact = (ContentResourceArtifact)art;
        Object resource = null;
        resource = container != null ? new ContentEntityWrapper(artifact.getBase(), ContentEntityUtil.getInstance().buildRef(container, site, context, artifact.getBase().getReference())) : artifact.getBase();
        Element root = new Element("artifact");
        root.addContent((Content)this.getMetadata(artifact));
        String type = artifact.getBase().getProperties().getProperty("SAKAI:structobj_type");
        if (type == null) {
            this.addFileContent((ContentResource)resource, root);
        } else {
            this.addStructuredObjectContent(type, (ContentResource)resource, root);
        }
        return root;
    }

    protected void addStructuredObjectContent(String type, ContentResource resource, Element root) {
        Element data = new Element("structuredData");
        Element baseElement = null;
        byte[] bytes = null;
        try {
            bytes = resource.getContent();
        }
        catch (ServerOverloadException e) {
            throw new RuntimeException(e);
        }
        SAXBuilder builder = new SAXBuilder();
        builder.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        Document doc = null;
        try {
            doc = builder.build((InputStream)new ByteArrayInputStream(bytes));
        }
        catch (JDOMException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        baseElement = (Element)doc.getRootElement().detach();
        data.addContent((Content)baseElement);
        root.addContent((Content)data);
        StructuredArtifactHomeInterface home = (StructuredArtifactHomeInterface)this.getHomeFactory().getHome(type);
        Element schemaData = new Element("schema");
        schemaData.addContent((Content)this.createInstructions(home));
        schemaData.addContent((Content)this.addSchemaInfo(home.getRootSchema()));
        root.addContent((Content)schemaData);
    }

    protected Element createInstructions(StructuredArtifactHomeInterface home) {
        Element instructions = new Element("instructions");
        instructions.setContent((Content)new CDATA(home.getInstruction()));
        return instructions;
    }

    protected Element addSchemaInfo(SchemaNode schema) {
        Element simpleType;
        Element schemaElement = new Element("element");
        schemaElement.setAttribute("name", schema.getName());
        if (schema.getType() != null && schema.getType().getBaseType() != null) {
            schemaElement.setAttribute("type", schema.getType().getBaseType());
        }
        schemaElement.setAttribute("minOccurs", schema.getMinOccurs() + "");
        schemaElement.setAttribute("maxOccurs", schema.getMaxOccurs() + "");
        Element annotation = schema.getSchemaElement().getChild("annotation", schema.getSchemaElement().getNamespace());
        if (annotation != null) {
            schemaElement.addContent(annotation.detach());
        }
        if ((simpleType = schema.getSchemaElement().getChild("simpleType", schema.getSchemaElement().getNamespace())) != null) {
            schemaElement.addContent(simpleType.detach());
        }
        List children = schema.getChildren();
        Element childElement = new Element("children");
        boolean found = false;
        Iterator i = children.iterator();
        while (i.hasNext()) {
            childElement.addContent((Content)this.addSchemaInfo((SchemaNode)i.next()));
            found = true;
        }
        if (found) {
            schemaElement.addContent((Content)childElement);
        }
        return schemaElement;
    }

    protected void addFileContent(ContentResource resource, Element root) {
        Element fileData = new Element("fileArtifact");
        Element uri = new Element("uri");
        uri.addContent(resource.getUrl());
        fileData.addContent((Content)uri);
        root.addContent((Content)fileData);
    }

    protected Element getMetadata(ContentResourceArtifact art) {
        Element root = new Element("metaData");
        root.addContent((Content)ContentHostingUtil.createNode("id", art.getId().getValue()));
        root.addContent((Content)ContentHostingUtil.createNode("displayName", art.getDisplayName()));
        Element type = new Element("type");
        root.addContent((Content)type);
        type.addContent((Content)ContentHostingUtil.createNode("id", "file"));
        type.addContent((Content)ContentHostingUtil.createNode("description", "file"));
        ContentResource contentResource = art.getBase();
        Element repositoryNode = ContentHostingUtil.createRepoNode(contentResource);
        root.addContent((Content)repositoryNode);
        repositoryNode.addContent((Content)ContentHostingUtil.createNode("size", "" + contentResource.getContentLength()));
        Element mimeType = new Element("mimeType");
        repositoryNode.addContent((Content)mimeType);
        String mimeTypeString = contentResource.getContentType();
        MimeType mime = new MimeType(mimeTypeString);
        mimeType.addContent((Content)ContentHostingUtil.createNode("primary", mime.getPrimaryType()));
        mimeType.addContent((Content)ContentHostingUtil.createNode("sub", mime.getSubType()));
        return root;
    }

    public HomeFactory getHomeFactory() {
        return this.homeFactory;
    }

    public void setHomeFactory(HomeFactory homeFactory) {
        this.homeFactory = homeFactory;
    }

    public IdManager getIdManager() {
        return this.idManager;
    }

    public void setIdManager(IdManager idManager) {
        this.idManager = idManager;
    }
}

