/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.metaobj.shared.mgt.home;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jdom.xpath.XPath;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.content.api.ContentHostingService;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.content.api.ContentResourceEdit;
import org.sakaiproject.entity.api.ResourcePropertiesEdit;
import org.sakaiproject.exception.IdInvalidException;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.IdUsedException;
import org.sakaiproject.exception.InUseException;
import org.sakaiproject.exception.InconsistentException;
import org.sakaiproject.exception.OverQuotaException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.exception.ServerOverloadException;
import org.sakaiproject.exception.TypeException;
import org.sakaiproject.metaobj.shared.ArtifactFinder;
import org.sakaiproject.metaobj.shared.mgt.AgentManager;
import org.sakaiproject.metaobj.shared.mgt.ContentHostingUtil;
import org.sakaiproject.metaobj.shared.mgt.IdManager;
import org.sakaiproject.metaobj.shared.mgt.PresentableObjectHome;
import org.sakaiproject.metaobj.shared.mgt.ReadableObjectHome;
import org.sakaiproject.metaobj.shared.mgt.StreamableObjectHome;
import org.sakaiproject.metaobj.shared.mgt.home.XmlElementHome;
import org.sakaiproject.metaobj.shared.model.Agent;
import org.sakaiproject.metaobj.shared.model.Artifact;
import org.sakaiproject.metaobj.shared.model.Id;
import org.sakaiproject.metaobj.shared.model.PersistenceException;
import org.sakaiproject.metaobj.shared.model.StructuredArtifact;
import org.sakaiproject.metaobj.utils.Config;
import org.sakaiproject.metaobj.utils.xml.SchemaNode;
import org.sakaiproject.metaobj.worksite.intf.WorksiteAware;
import org.sakaiproject.metaobj.worksite.mgt.WorksiteManager;
import org.sakaiproject.util.ResourceLoader;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class StructuredArtifactHome
extends XmlElementHome
implements WorksiteAware,
ApplicationContextAware,
Comparable,
StreamableObjectHome {
    protected static final Log logger = LogFactory.getLog(StructuredArtifactHome.class);
    private boolean modifiable = false;
    private PresentableObjectHome repositoryHelper;
    private IdManager idManager;
    private String siteId;
    private ArtifactFinder artifactFinder;
    private ResourceLoader rl = new ResourceLoader("org.sakaiproject.metaobj.messages");
    private static final MessageFormat format = new MessageFormat("<META HTTP-EQUIV=\"Refresh\" CONTENT=\"0;URL={0}/member/viewArtifact.osp?artifactId={1}&artifactType={2}&pid={3}\">");

    @Override
    public Artifact store(Artifact object) throws PersistenceException {
        Id id = object.getId();
        if (id == null) {
            return this.addArtifact(object);
        }
        return this.updateArtifact(object);
    }

    protected Artifact updateArtifact(Artifact object) throws PersistenceException {
        StructuredArtifact artifact = (StructuredArtifact)object;
        String resourceId = this.getContentHostingService().resolveUuid(artifact.getId().getValue());
        try {
            ContentResourceEdit resourceEdit = this.getContentHostingService().editResource(resourceId);
            resourceEdit.setContent(this.getInfoBytes(object));
            resourceEdit.getProperties().addProperty("DAV:displayname", object.getDisplayName());
            this.getContentHostingService().commitResource(resourceEdit);
        }
        catch (PermissionException e) {
            throw new PersistenceException((Throwable)e, this.rl.getString("perm_file_err"), null, null);
        }
        catch (IdUnusedException e) {
            throw new PersistenceException((Throwable)e, this.rl.getString("unknown_file_err"), null, null);
        }
        catch (TypeException e) {
            throw new PersistenceException((Throwable)e, this.rl.getString("unknown_file_err"), null, null);
        }
        catch (InUseException e) {
            throw new PersistenceException((Throwable)e, this.rl.getString("unknown_file_err"), null, null);
        }
        catch (ServerOverloadException e) {
            throw new PersistenceException((Throwable)e, this.rl.getString("unknown_file_err"), null, null);
        }
        catch (OverQuotaException e) {
            throw new PersistenceException((Throwable)e, this.rl.getString("quota_file_err"), null, null);
        }
        return object;
    }

    @Override
    public StructuredArtifact load(ContentResource resource, Id artifactId) {
        try {
            Agent resourceOwner = this.getAgentManager().getAgent(resource.getProperties().getProperty("CHEF:creator"));
            SAXBuilder builder = new SAXBuilder();
            builder.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            Document doc = builder.build(resource.streamContent());
            StructuredArtifact xmlObject = new StructuredArtifact(doc.getRootElement(), this.getSchema().getChild(this.getRootNode()));
            xmlObject.setBaseResource(resource);
            xmlObject.setId(artifactId);
            xmlObject.setDisplayName((String)resource.getProperties().get(resource.getProperties().getNamePropDisplayName()));
            xmlObject.setHome((ReadableObjectHome)this);
            xmlObject.setOwner(resourceOwner);
            return xmlObject;
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)e, "", null, null);
        }
    }

    @Override
    public StructuredArtifact load(ContentResource resource) {
        Id artifactId = this.getIdManager().getId(this.getContentHostingService().getUuid(resource.getId()));
        return this.load(resource, artifactId);
    }

    private AgentManager getAgentManager() {
        return (AgentManager)ComponentManager.get((String)"agentManager");
    }

    @Override
    public Artifact load(Id id) throws PersistenceException {
        return null;
    }

    @Override
    public void remove(Artifact object) throws PersistenceException {
    }

    @Override
    public Artifact cloneArtifact(Artifact copy, String newName) throws PersistenceException {
        return null;
    }

    protected Artifact addArtifact(Artifact object) throws PersistenceException {
        StructuredArtifact artifact = (StructuredArtifact)object;
        String newFileId = artifact.getParentFolder() + this.getIdManager().createId().getValue();
        try {
            ContentResourceEdit resource = this.getContentHostingService().addResource(newFileId);
            resource.setResourceType("org.sakaiproject.metaobj.shared.FormHelper");
            ResourcePropertiesEdit resourceProperties = resource.getPropertiesEdit();
            resourceProperties.addProperty("DAV:displayname", object.getDisplayName());
            resourceProperties.addProperty("CHEF:description", object.getDisplayName());
            resourceProperties.addProperty("encoding", "UTF-8");
            resourceProperties.addProperty("SAKAI:structobj_type", this.getTypeId());
            resourceProperties.addProperty("CHEF:is-collection", Boolean.FALSE.toString());
            resourceProperties.addProperty("sakai:reference-root", "metaobj");
            resource.setContent(this.getInfoBytes((Artifact)artifact));
            resource.setContentType("application/x-osp");
            this.getContentHostingService().commitResource(resource);
            artifact.setId(this.getIdManager().getId(this.getContentHostingService().getUuid(newFileId)));
            return object;
        }
        catch (PermissionException e) {
            throw new PersistenceException("No permission to write file", null, null);
        }
        catch (IdUsedException e) {
            throw new PersistenceException("Resource exists {0}", new Object[]{artifact.getDisplayName()}, "displayName");
        }
        catch (IdInvalidException e) {
            throw new PersistenceException("Invalid name {0}", new Object[]{artifact.getDisplayName()}, "displayName");
        }
        catch (InconsistentException e) {
            throw new PersistenceException("Invalid name {0}", new Object[]{artifact.getDisplayName()}, "displayName");
        }
        catch (ServerOverloadException e) {
            throw new PersistenceException((Throwable)e, "Unknown file error", null, null);
        }
        catch (OverQuotaException e) {
            throw new PersistenceException("Over quota", null, null);
        }
    }

    protected byte[] getInfoBytes(Artifact object) throws PersistenceException {
        XMLOutputter outputter = new XMLOutputter();
        StructuredArtifact xmlObject = (StructuredArtifact)object;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            Format format = Format.getPrettyFormat();
            outputter.setFormat(format);
            outputter.output(xmlObject.getBaseElement(), (OutputStream)os);
            return os.toByteArray();
        }
        catch (IOException e) {
            throw new PersistenceException((Throwable)e, "Unable to write object", null, null);
        }
    }

    @Override
    public byte[] getBytes(StructuredArtifact artifact) {
        return this.getInfoBytes((Artifact)artifact);
    }

    protected InputStream getInfoStream(Artifact object) throws PersistenceException {
        return new ByteArrayInputStream(this.getInfoBytes(object));
    }

    public String getHostBaseUrl() {
        return Config.getInstance().getProperties().getProperty("baseUrl");
    }

    @Override
    public Element getArtifactAsXml(Artifact art) {
        StructuredArtifact sa = (StructuredArtifact)art;
        Element root = new Element("artifact");
        root.addContent((Content)this.getMetadata((Artifact)sa));
        Element data = new Element("structuredData");
        Element baseElement = (Element)sa.getBaseElement().clone();
        data.addContent((Content)baseElement);
        root.addContent((Content)data);
        Element schemaData = new Element("schema");
        schemaData.addContent((Content)this.createInstructions());
        try {
            schemaData.addContent((Content)this.addSchemaInfo(this.getRootSchema()));
        }
        catch (JDOMException e) {
            throw new RuntimeException("Invalid schema info");
        }
        root.addContent((Content)schemaData);
        return root;
    }

    protected void replaceFileRefs(Element schemaData, Element data) {
        try {
            XPath fileAttachPath = XPath.newInstance((String)".//element[@type='xs:anyURI']");
            List fileElements = fileAttachPath.selectNodes((Object)schemaData);
            Iterator i = fileElements.iterator();
            while (i.hasNext()) {
                this.processFileElement((Element)i.next(), data);
            }
        }
        catch (JDOMException e) {
            throw new RuntimeException(e);
        }
    }

    protected void processFileElement(Element element, Element data) throws JDOMException {
        String path = "";
        while (element != null) {
            if (path.length() > 0) {
                path = "/" + path;
            }
            path = element.getAttributeValue("name") + path;
            if ((element = element.getParentElement()) == null) continue;
            element = element.getParentElement();
        }
        List fileElements = XPath.selectNodes((Object)data, (String)path);
        for (Element filePath : fileElements) {
            String fileId = filePath.getTextTrim();
            Artifact fileArt = this.getArtifactFinder().load(this.getIdManager().getId(fileId));
            PresentableObjectHome home = (PresentableObjectHome)fileArt.getHome();
            Element file = home.getArtifactAsXml(fileArt);
            file.setName("artifact");
            filePath.addContent((Content)file);
        }
    }

    protected Element getMetadata(Artifact art) {
        Element root = new Element("metaData");
        if (art.getId() != null) {
            root.addContent((Content)this.createNode("id", art.getId().getValue()));
        }
        root.addContent((Content)this.createNode("displayName", art.getDisplayName()));
        Element type = new Element("type");
        root.addContent((Content)type);
        type.addContent((Content)this.createNode("id", "file"));
        type.addContent((Content)this.createNode("description", "file"));
        ContentResource contentResource = ((StructuredArtifact)art).getBaseResource();
        if (contentResource != null) {
            Element repositoryNode = ContentHostingUtil.createRepoNode(contentResource);
            root.addContent((Content)repositoryNode);
        }
        return root;
    }

    protected Element createNode(String name, String value) {
        Element newNode = new Element(name);
        newNode.addContent(value);
        return newNode;
    }

    protected Element createInstructions() {
        Element instructions = new Element("instructions");
        instructions.setContent((Content)new CDATA(this.getInstruction()));
        return instructions;
    }

    protected Element addSchemaInfo(SchemaNode schema) throws JDOMException {
        Element externalType;
        Element simpleType;
        Element schemaElement = new Element("element");
        schemaElement.setAttribute("name", schema.getName());
        if (schema.getType() != null && schema.getType().getBaseType() != null) {
            schemaElement.setAttribute("type", schema.getType().getBaseType());
        }
        schemaElement.setAttribute("minOccurs", schema.getMinOccurs() + "");
        schemaElement.setAttribute("maxOccurs", schema.getMaxOccurs() + "");
        Element annotation = schema.getSchemaElement().getChild("annotation", schema.getSchemaElement().getNamespace());
        if (annotation != null) {
            schemaElement.addContent(this.i18nFilterAnnotations(annotation));
        }
        if ((simpleType = schema.getSchemaElement().getChild("simpleType", schema.getSchemaElement().getNamespace())) != null) {
            schemaElement.addContent((Content)simpleType.clone());
        } else if (schema.getSchemaElement().getAttribute("type") != null && (externalType = this.getSimpleType(schema.getSchemaElement().getAttributeValue("type"), schema.getSchemaElement().getDocument().getRootElement())) != null) {
            schemaElement.addContent((Content)externalType.clone());
        }
        List children = schema.getChildren();
        Element childElement = new Element("children");
        boolean found = false;
        Iterator i = children.iterator();
        while (i.hasNext()) {
            childElement.addContent((Content)this.addSchemaInfo((SchemaNode)i.next()));
            found = true;
        }
        if (found) {
            schemaElement.addContent((Content)childElement);
        }
        return schemaElement;
    }

    protected Element getSimpleType(String attribute, Element rootElement) throws JDOMException {
        XPath docPath = XPath.newInstance((String)("xs:simpleType[@name='" + attribute + "']"));
        List elements = docPath.selectNodes((Object)rootElement);
        if (elements.size() == 0) {
            return null;
        }
        return (Element)elements.get(0);
    }

    protected Content i18nFilterAnnotations(Element content) throws JDOMException {
        Locale locale = this.rl.getLocale();
        Hashtable<String, Element> documentElements = new Hashtable<String, Element>();
        this.filterElements(documentElements, content, null);
        this.filterElements(documentElements, content, locale.getLanguage());
        this.filterElements(documentElements, content, locale.getLanguage() + "_" + locale.getCountry());
        this.filterElements(documentElements, content, locale.getLanguage() + "_" + locale.getCountry() + "_" + locale.getVariant());
        Element returned = (Element)content.clone();
        returned.removeChildren("documentation", content.getNamespace());
        Iterator i = documentElements.values().iterator();
        while (i.hasNext()) {
            returned.addContent((Content)((Element)i.next()).clone());
        }
        return returned;
    }

    protected void filterElements(Map<String, Element> documentElements, Element content, String lang) throws JDOMException {
        XPath docPath = lang == null ? XPath.newInstance((String)"xs:documentation[not(@xml:lang)]") : XPath.newInstance((String)("xs:documentation[lang('" + lang + "')]"));
        List elements = docPath.selectNodes((Object)content);
        for (Element child : elements) {
            String source = child.getAttributeValue("source");
            if (source == null) continue;
            documentElements.put(child.getAttributeValue("source"), child);
        }
    }

    @Override
    public String getSiteId() {
        return this.siteId;
    }

    public void setSiteId(String siteId) {
        this.siteId = siteId;
    }

    public boolean isModifiable() {
        return this.modifiable;
    }

    public boolean isGlobal() {
        return this.getSiteId() == null || this.getSiteId().length() == 0;
    }

    public PresentableObjectHome getRepositoryHelper() {
        return this.repositoryHelper;
    }

    public void setRepositoryHelper(PresentableObjectHome repositoryHelper) {
        this.repositoryHelper = repositoryHelper;
    }

    @Override
    public IdManager getIdManager() {
        if (this.idManager == null) {
            this.setIdManager((IdManager)ComponentManager.get((String)"idManager"));
        }
        return this.idManager;
    }

    @Override
    public void setIdManager(IdManager idManager) {
        this.idManager = idManager;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.setIdManager((IdManager)applicationContext.getBean("idManager"));
        this.setRepositoryHelper((PresentableObjectHome)applicationContext.getBean("repositoryHelper"));
    }

    public int compareTo(Object o) {
        StructuredArtifactHome that = (StructuredArtifactHome)o;
        return this.getType().getDescription().toLowerCase().compareTo(that.getType().getDescription().toLowerCase());
    }

    @Override
    public InputStream getStream(Id artifactId) {
        try {
            StructuredArtifact artifact = (StructuredArtifact)this.load(artifactId);
            return this.getInfoStream((Artifact)artifact);
        }
        catch (PersistenceException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isSystemOnly() {
        return false;
    }

    protected WorksiteManager getWorksiteManager() {
        return (WorksiteManager)ComponentManager.getInstance().get(WorksiteManager.class.getName());
    }

    public ArtifactFinder getArtifactFinder() {
        if (this.artifactFinder == null) {
            this.setArtifactFinder((ArtifactFinder)ComponentManager.get((String)"org.sakaiproject.metaobj.shared.ArtifactFinder.fileArtifact"));
        }
        return this.artifactFinder;
    }

    public void setArtifactFinder(ArtifactFinder artifactFinder) {
        this.artifactFinder = artifactFinder;
    }

    protected ContentHostingService getContentHostingService() {
        return (ContentHostingService)ComponentManager.get((String)"org.sakaiproject.content.api.ContentHostingService");
    }
}

