/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.metaobj.security.impl.sakai;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.authz.api.AuthzGroup;
import org.sakaiproject.authz.api.GroupNotDefinedException;
import org.sakaiproject.authz.api.Role;
import org.sakaiproject.authz.cover.AuthzGroupService;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.metaobj.security.impl.sakai.RoleWrapper;
import org.sakaiproject.metaobj.security.impl.sakai.SecurityBase;
import org.sakaiproject.metaobj.shared.mgt.AgentManager;
import org.sakaiproject.metaobj.shared.model.Agent;
import org.sakaiproject.metaobj.shared.model.Artifact;
import org.sakaiproject.metaobj.shared.model.Id;
import org.sakaiproject.metaobj.shared.model.IdentifiableObject;
import org.sakaiproject.metaobj.shared.model.OspException;
import org.sakaiproject.metaobj.shared.model.StructuredArtifact;
import org.sakaiproject.tool.api.Placement;
import org.sakaiproject.tool.cover.ToolManager;
import org.sakaiproject.user.api.User;
import org.sakaiproject.util.ResourceLoader;

public class AgentWrapper
extends IdentifiableObject
implements Agent {
    protected final transient Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private User sakaiUser = null;
    private Id id = null;
    private Id eid = null;
    private StructuredArtifact profile = null;
    private SecurityBase securityBase;
    private ResourceLoader rb = new ResourceLoader("org/sakaiproject/metaobj/messages");

    public AgentWrapper() {
        this.logger.info((Object)"An AgentWrapper was created without any parameters");
    }

    public AgentWrapper(Id id, Id eid, User sakaiUser, StructuredArtifact profile, SecurityBase securityBase) {
        this.id = id;
        this.eid = eid;
        this.sakaiUser = sakaiUser;
        this.profile = profile;
        this.securityBase = securityBase;
    }

    public Id getId() {
        return this.id;
    }

    public Id getEid() {
        return this.eid;
    }

    public Artifact getProfile() {
        return this.profile;
    }

    public void setProfile(StructuredArtifact profile) {
        this.profile = profile;
    }

    public Object getProperty(String key) {
        return this.profile.get((Object)key);
    }

    public String getDisplayName() {
        if (this.sakaiUser != null) {
            return this.sakaiUser.getDisplayName();
        }
        if (this.eid != null) {
            return this.eid.getValue();
        }
        if (this.id != null) {
            return this.id.getValue();
        }
        return this.rb.getString("user_not_found");
    }

    public boolean isInRole(String role) {
        return role.equals(this.sakaiUser.getType());
    }

    public boolean isInitialized() {
        return true;
    }

    public String getRole() {
        return this.sakaiUser.getType();
    }

    public List getWorksiteRoles(String worksiteId) {
        ArrayList<RoleWrapper> returned = new ArrayList<RoleWrapper>();
        try {
            AuthzGroup siteRealm = AuthzGroupService.getAuthzGroup((String)("/site/" + worksiteId));
            Role role = siteRealm.getUserRole(this.getSakaiUser().getId());
            if (role != null) {
                returned.add(this.getSecurityBase().convertRole(role, siteRealm));
            }
        }
        catch (GroupNotDefinedException e) {
            this.logger.error((Object)"", (Throwable)e);
            throw new OspException((Throwable)e);
        }
        return returned;
    }

    public List getWorksiteRoles() {
        Placement currentPlacement = ToolManager.getCurrentPlacement();
        if (currentPlacement == null) {
            return new ArrayList();
        }
        return this.getWorksiteRoles(currentPlacement.getContext());
    }

    public boolean isRole() {
        return false;
    }

    public User getSakaiUser() {
        return this.sakaiUser;
    }

    public AgentManager getAgentManager() {
        return (AgentManager)ComponentManager.getInstance().get("agentManager");
    }

    public SecurityBase getSecurityBase() {
        return this.securityBase;
    }

    public String getName() {
        return this.getDisplayName();
    }

    public String getPassword() {
        return null;
    }
}

