/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.metaobj.security.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.authz.api.AuthzGroup;
import org.sakaiproject.authz.api.AuthzGroupService;
import org.sakaiproject.authz.api.GroupNotDefinedException;
import org.sakaiproject.metaobj.security.AuthorizationFacade;
import org.sakaiproject.metaobj.security.AuthorizationFailedException;
import org.sakaiproject.metaobj.shared.model.Agent;
import org.sakaiproject.metaobj.shared.model.Id;
import org.sakaiproject.thread_local.cover.ThreadLocalManager;
import org.sakaiproject.tool.cover.ToolManager;
import org.sakaiproject.user.api.UserDirectoryService;

public class AuthzShim
implements AuthorizationFacade {
    protected final transient Log logger = LogFactory.getLog(this.getClass());
    private static final String AUTHZ_GROUPS_LIST = "org.sakaiproject.metaobj.security.impl.AuthzShim.groups";
    private AuthzGroupService realmService;
    private UserDirectoryService userDirectoryService;

    public void checkPermission(String function, Id id) throws AuthorizationFailedException {
        if (!this.isAuthorized(function, id)) {
            throw new AuthorizationFailedException(function, id);
        }
    }

    public void checkPermission(Agent agent, String function, Id id) throws AuthorizationFailedException {
        if (!this.isAuthorized(agent, function, id)) {
            throw new AuthorizationFailedException(agent, function, id);
        }
    }

    public boolean isAuthorized(String function, Id id) {
        return this.isAuthorized(null, function, id);
    }

    public boolean isAuthorized(Agent agent, String function, Id id) {
        String agentId = null;
        agentId = agent == null ? this.getUserDirectoryService().getCurrentUser().getId() : agent.getId().getValue();
        if (function.equals("maintain")) {
            return this.checkMaintain(agentId);
        }
        return this.getRealmService().isAllowed(agentId, function, this.getCurrentRealm());
    }

    protected boolean checkMaintain(String agentId) {
        AuthzGroup siteRealm = null;
        try {
            siteRealm = this.getRealmService().getAuthzGroup(this.getCurrentRealm());
        }
        catch (GroupNotDefinedException e) {
            throw new RuntimeException("unkown realm", e);
        }
        String maintain = siteRealm.getMaintainRole();
        return siteRealm.hasRole(agentId, maintain);
    }

    protected String getCurrentRealm() {
        if (this.getAuthzGroupsList().size() == 0) {
            return "/site/" + ToolManager.getCurrentPlacement().getContext();
        }
        return "/site/" + this.getAuthzGroupsList().get(0);
    }

    protected String getReference(Id id) {
        return null;
    }

    public List getAuthorizations(Agent agent, String function, Id id) {
        return new ArrayList();
    }

    public void createAuthorization(Agent agent, String function, Id id) {
    }

    public void deleteAuthorization(Agent agent, String function, Id id) {
    }

    public void deleteAuthorizations(Id qualifier) {
    }

    public void pushAuthzGroups(Collection authzGroups) {
        List authzGroupList = this.getAuthzGroupsList();
        authzGroupList.addAll(authzGroups);
    }

    public void pushAuthzGroups(String siteId) {
        this.getAuthzGroupsList().add(siteId);
    }

    public AuthzGroupService getRealmService() {
        return this.realmService;
    }

    public void setRealmService(AuthzGroupService realmService) {
        this.realmService = realmService;
    }

    public UserDirectoryService getUserDirectoryService() {
        return this.userDirectoryService;
    }

    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    protected List getAuthzGroupsList() {
        ArrayList returned = (ArrayList)ThreadLocalManager.get((String)AUTHZ_GROUPS_LIST);
        if (returned == null) {
            returned = new ArrayList();
            ThreadLocalManager.set((String)AUTHZ_GROUPS_LIST, returned);
        }
        return returned;
    }
}

