/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.util;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Xml {
    private static Log M_log = LogFactory.getLog(Xml.class);
    private static SAXParserFactory parserFactory;

    public static Document createDocument() {
        try {
            DocumentBuilder builder = Xml.getDocumentBuilder();
            Document doc = builder.newDocument();
            return doc;
        }
        catch (Exception any) {
            M_log.warn((Object)("createDocument: " + any.toString()));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document readDocument(String name) {
        InputSource inputSource;
        InputStreamReader in;
        DocumentBuilder docBuilder;
        Document doc = null;
        FileInputStream fis = null;
        try {
            docBuilder = Xml.getDocumentBuilder();
            fis = new FileInputStream(name);
            doc = docBuilder.parse(fis);
        }
        catch (Exception e) {
            doc = null;
        }
        finally {
            if (fis != null) {
                try {
                    ((InputStream)fis).close();
                }
                catch (IOException e) {}
            }
        }
        if (doc != null) {
            return doc;
        }
        try {
            docBuilder = Xml.getDocumentBuilder();
            in = new InputStreamReader((InputStream)new FileInputStream(name), "ISO-8859-1");
            inputSource = new InputSource(in);
            doc = docBuilder.parse(inputSource);
        }
        catch (Exception any) {
            doc = null;
        }
        if (doc != null) {
            return doc;
        }
        try {
            docBuilder = Xml.getDocumentBuilder();
            in = new InputStreamReader((InputStream)new FileInputStream(name), "UTF-8");
            inputSource = new InputSource(in);
            doc = docBuilder.parse(inputSource);
        }
        catch (Exception any) {
            M_log.warn((Object)("readDocument failed on file: " + name + " with exception: " + any.toString()));
            doc = null;
        }
        return doc;
    }

    public static Document readDocumentFromString(String in) {
        try {
            DocumentBuilder docBuilder = Xml.getDocumentBuilder();
            InputSource inputSource = new InputSource(new StringReader(in));
            Document doc = docBuilder.parse(inputSource);
            return doc;
        }
        catch (Exception any) {
            M_log.warn((Object)("readDocumentFromString: " + any.toString()));
            return null;
        }
    }

    public static void processString(String in, DefaultHandler dh) throws SAXException, IOException {
        StringReader r = new StringReader(in);
        Xml.processReader(r, dh);
        ((Reader)r).close();
    }

    public static void processStream(InputStream in, DefaultHandler dh) throws SAXException, IOException {
        Xml.processReader(new InputStreamReader(in), dh);
    }

    public static void processReader(Reader in, DefaultHandler dh) throws SAXException, IOException {
        InputSource ss = new InputSource(in);
        SAXParser p = null;
        if (parserFactory == null) {
            parserFactory = SAXParserFactory.newInstance();
            parserFactory.setNamespaceAware(false);
            parserFactory.setValidating(false);
        }
        try {
            p = parserFactory.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            throw new SAXException("Failed to get a parser ", e);
        }
        p.parse(ss, dh);
    }

    public static Document readDocumentFromStream(InputStream in) {
        try {
            DocumentBuilder docBuilder = Xml.getDocumentBuilder();
            InputSource inputSource = new InputSource(in);
            Document doc = docBuilder.parse(inputSource);
            return doc;
        }
        catch (Exception any) {
            M_log.warn((Object)("readDocumentFromStream: " + any.toString()));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeDocument(Document doc, String fileName) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(fileName);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            DOMImplementation impl = builder.getDOMImplementation();
            DOMImplementationLS feature = (DOMImplementationLS)impl.getFeature("LS", "3.0");
            LSSerializer serializer = feature.createLSSerializer();
            LSOutput output = feature.createLSOutput();
            output.setByteStream(out);
            output.setEncoding("UTF-8");
            serializer.write(doc, output);
            ((OutputStream)out).close();
        }
        catch (Exception any) {
            M_log.warn((Object)("writeDocument: " + any.toString()));
        }
        finally {
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static String writeDocumentToString(Document doc) {
        try {
            StringWriter sw = new StringWriter();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            DOMImplementation impl = builder.getDOMImplementation();
            DOMImplementationLS feature = (DOMImplementationLS)impl.getFeature("LS", "3.0");
            LSSerializer serializer = feature.createLSSerializer();
            LSOutput output = feature.createLSOutput();
            output.setCharacterStream(sw);
            output.setEncoding("UTF-8");
            serializer.write(doc, output);
            sw.flush();
            return sw.toString();
        }
        catch (Exception any) {
            M_log.warn((Object)("writeDocumentToString: " + any.toString()));
            return null;
        }
    }

    public static void encodeAttribute(Element el, String tag, String value) {
        if (value == null) {
            return;
        }
        try {
            String encoded = new String(Base64.encodeBase64((byte[])value.getBytes("UTF-8")), "UTF-8");
            el.setAttribute(tag, encoded);
        }
        catch (Exception e) {
            M_log.warn((Object)("encodeAttribute: " + e));
        }
    }

    public static String decodeAttribute(Element el, String tag) {
        String body;
        String charset = StringUtils.trimToNull((String)el.getAttribute("charset"));
        if (charset == null) {
            charset = "UTF-8";
        }
        if ((body = StringUtils.trimToNull((String)el.getAttribute(tag))) != null) {
            try {
                byte[] decoded = Base64.decodeBase64((byte[])body.getBytes("UTF-8"));
                body = new String(decoded, charset);
            }
            catch (Exception e) {
                M_log.warn((Object)("decodeAttribute: " + e));
            }
        }
        if (body == null) {
            body = "";
        }
        return body;
    }

    public static String decode(String charset, String value) {
        String body = StringUtils.trimToNull((String)value);
        if (body != null) {
            try {
                byte[] decoded = Base64.decodeBase64((byte[])body.getBytes("UTF-8"));
                body = new String(decoded, charset);
            }
            catch (Exception e) {
                M_log.warn((Object)("decodeAttribute: " + e));
            }
        }
        if (body == null) {
            body = "";
        }
        return body;
    }

    protected static DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        return dbf.newDocumentBuilder();
    }

    public static Element propertiesToXml(Properties propsToSerialize, Document doc, Stack<Element> stack) {
        Element properties = doc.createElement("properties");
        stack.peek().appendChild(properties);
        Enumeration<?> props = propsToSerialize.propertyNames();
        while (props.hasMoreElements()) {
            String name = (String)props.nextElement();
            String value = propsToSerialize.getProperty(name);
            Element propElement = doc.createElement("property");
            properties.appendChild(propElement);
            propElement.setAttribute("name", name);
            Xml.encodeAttribute(propElement, "value", value);
            propElement.setAttribute("enc", "BASE64");
        }
        return properties;
    }

    public static void xmlToProperties(Properties properties, Element el) {
        NodeList children = el.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Element element;
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !(element = (Element)child).getTagName().equals("property")) continue;
            String name = element.getAttribute("name");
            String enc = StringUtils.trimToNull((String)element.getAttribute("enc"));
            String value = null;
            value = "BASE64".equalsIgnoreCase(enc) ? Xml.decodeAttribute(element, "value") : element.getAttribute("value");
            properties.put(name, value);
        }
    }
}

