/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.util;

import java.io.File;
import java.util.Set;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.tool.cover.ActiveToolManager;

public class ToolListener
implements ServletContextListener {
    private static Log M_log = LogFactory.getLog(ToolListener.class);

    public void contextInitialized(ServletContextEvent event) {
        Set paths = event.getServletContext().getResourcePaths("/tools/");
        String sakaiHomePath = ServerConfigurationService.getSakaiHomePath();
        if (paths == null) {
            return;
        }
        int registered = 0;
        for (String path : paths) {
            if (path.endsWith("/") || !path.endsWith(".xml")) continue;
            File f = new File(sakaiHomePath + path);
            if (f.exists()) {
                ActiveToolManager.register(f, event.getServletContext());
                M_log.info((Object)("overriding tools configuration: registering tools from resource: " + sakaiHomePath + path));
            } else {
                M_log.info((Object)("registering tools from resource: " + path));
                ActiveToolManager.register(event.getServletContext().getResourceAsStream(path), event.getServletContext());
            }
            ++registered;
        }
        if (registered == 0) {
            M_log.warn((Object)"No tools found to be registered.");
        }
        for (String path : paths) {
            if (path.endsWith("/") || !path.endsWith(".properties")) continue;
            File reg = new File(path);
            String tn = reg.getName();
            String tid = null;
            tid = tn.indexOf(95) == -1 ? tn.substring(0, tn.lastIndexOf(46)) : tn.substring(0, tn.indexOf(95));
            String msg = event.getServletContext().getRealPath(path.substring(0, path.lastIndexOf(46)) + ".properties");
            if (tid == null) continue;
            ActiveToolManager.setResourceBundle(tid, msg);
            M_log.info((Object)("Added localization resources for " + tid));
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
    }
}

