/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tomcat.jdbc.pool;

import java.lang.management.ManagementFactory;
import java.sql.SQLException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.apache.tomcat.jdbc.pool.PoolConfiguration;
import org.apache.tomcat.jdbc.pool.PoolProperties;

public class SakaiBasicDataSource
extends DataSource {
    private static Log M_log = LogFactory.getLog(SakaiBasicDataSource.class);
    private MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
    protected boolean m_rollbackOnReturn = false;
    private boolean poolPreparedStatements;
    private int maxOpenPreparedStatements;

    public MBeanServer getMBeanServer() {
        return this.mBeanServer;
    }

    public void setMaxOpenPreparedStatements(int maxOpenPreparedStatements) {
        M_log.info((Object)"MaxOpenPreparedStatments not used");
        this.maxOpenPreparedStatements = maxOpenPreparedStatements;
    }

    public void setPoolPreparedStatements(boolean poolPreparedStatements) {
        M_log.info((Object)"PoolPreparedStatements not used");
        this.poolPreparedStatements = poolPreparedStatements;
    }

    public void setDefaultTransactionIsolationString(String defaultTransactionIsolation) {
        if (defaultTransactionIsolation == null || defaultTransactionIsolation.trim().length() == 0) {
            this.setDefaultTransactionIsolation(-1);
        } else if (defaultTransactionIsolation.trim().equalsIgnoreCase("TRANSACTION_NONE")) {
            this.setDefaultTransactionIsolation(0);
        } else if (defaultTransactionIsolation.trim().equalsIgnoreCase("TRANSACTION_READ_UNCOMMITTED")) {
            this.setDefaultTransactionIsolation(1);
        } else if (defaultTransactionIsolation.trim().equalsIgnoreCase("TRANSACTION_READ_COMMITTED")) {
            this.setDefaultTransactionIsolation(2);
        } else if (defaultTransactionIsolation.trim().equalsIgnoreCase("TRANSACTION_REPEATABLE_READ")) {
            this.setDefaultTransactionIsolation(4);
        } else if (defaultTransactionIsolation.trim().equalsIgnoreCase("TRANSACTION_SERIALIZABLE")) {
            this.setDefaultTransactionIsolation(8);
        } else {
            this.setDefaultTransactionIsolation(-1);
            M_log.warn((Object)("invalid transaction isolation level: " + defaultTransactionIsolation));
        }
    }

    public synchronized void setRollbackOnBorrow(boolean value) {
        this.m_rollbackOnReturn = value;
    }

    protected void init() throws MalformedObjectNameException, MBeanRegistrationException, NotCompliantMBeanException, SQLException, InstanceAlreadyExistsException {
        String password;
        M_log.info((Object)"init()");
        PoolProperties connectionPool = (PoolProperties)this.createPool().getPoolProperties();
        String driverClassName = this.getDriverClassName();
        if (driverClassName != null) {
            try {
                Class.forName(driverClassName);
            }
            catch (Throwable t) {
                String message = "Cannot load JDBC driver class '" + driverClassName + "'";
                M_log.warn((Object)message, t);
                throw new SQLException(message, t);
            }
        }
        if (this.getValidationQuery() == null) {
            connectionPool.setTestOnBorrow(false);
            connectionPool.setTestOnReturn(false);
            connectionPool.setTestWhileIdle(false);
        }
        if (this.getUsername() == null) {
            M_log.warn((Object)"Tomcat DataSource configured without a 'username'");
        }
        if ((password = this.createPool().getPoolProperties().getUsername()) == null) {
            M_log.warn((Object)"Tomcat DataSource configured without a 'password'");
        }
        this.setPoolProperties((PoolConfiguration)connectionPool);
        ObjectName on = new ObjectName("TomcatJDBC:type=statistics,application=TomcatJDBCSakaiPool");
        if (!this.mBeanServer.isRegistered(on)) {
            M_log.info((Object)("Registering Tomcat JDBC pool with JMX " + this.mBeanServer));
            this.mBeanServer.registerMBean(this.getPool().getJmxPool(), on);
        }
    }
}

