/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.memory.api;

import java.util.Properties;
import org.sakaiproject.memory.api.Configuration;

public class SimpleConfiguration
implements Configuration {
    boolean stats = false;
    long maxEntries = -1L;
    long timeToLiveSeconds = -1L;
    long timeToIdleSeconds = -1L;
    boolean eternal = false;

    public SimpleConfiguration(long maxEntries) {
        this.maxEntries = maxEntries;
    }

    public SimpleConfiguration(long maxEntries, long timeToLiveSeconds, long timeToIdleSeconds) {
        this(maxEntries);
        if (timeToLiveSeconds == 0L && timeToIdleSeconds == 0L) {
            this.eternal = true;
        } else {
            this.timeToLiveSeconds = timeToLiveSeconds;
            this.timeToIdleSeconds = timeToIdleSeconds;
            this.eternal = false;
        }
    }

    @Override
    public boolean isStatisticsEnabled() {
        return this.stats;
    }

    public void setStatisticsEnabled(boolean stats) {
        this.stats = stats;
    }

    @Override
    public long getMaxEntries() {
        return this.maxEntries;
    }

    @Override
    public long getTimeToLiveSeconds() {
        return this.timeToLiveSeconds;
    }

    @Override
    public long getTimeToIdleSeconds() {
        return this.timeToIdleSeconds;
    }

    @Override
    public boolean isEternal() {
        return this.eternal;
    }

    @Override
    public Properties getAll() {
        Properties p = new Properties();
        p.put("maxEntries", (Object)this.maxEntries);
        p.put("timeToLiveSeconds", (Object)this.timeToLiveSeconds);
        p.put("timeToIdleSeconds", (Object)this.timeToIdleSeconds);
        p.put("eternal", (Object)this.eternal);
        p.put("statisticsEnabled", (Object)this.stats);
        return p;
    }

    public String toString() {
        return "{stats:" + this.stats + ", maxEntries:" + this.maxEntries + ", timeToLiveSeconds:" + this.timeToLiveSeconds + ", timeToIdleSeconds:" + this.timeToIdleSeconds + ", eternal:" + this.eternal + '}';
    }
}

