/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.event.api;

import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.event.api.LearningResourceStoreProvider;

public interface LearningResourceStoreService {
    public static final String XAPI_ACTIVITIES_PREFIX = "http://adlnet.gov/expapi/activities/";

    public void registerStatement(LRS_Statement var1, String var2);

    public boolean isEnabled();

    public boolean registerProvider(LearningResourceStoreProvider var1);

    public LRS_Actor getEventActor(Event var1);

    public static class LRS_Context {
        LRS_Actor instructor;
        String revision;
        Map<String, Map<String, String>> activitiesMap;
        String platform = "Sakai";

        protected LRS_Context() {
        }

        public LRS_Context(LRS_Actor instructor) {
            this();
            if (instructor == null) {
                throw new IllegalArgumentException("LRS_Context instructor cannot be null");
            }
            this.instructor = instructor;
        }

        public LRS_Context(String contextType, String activityId) {
            this();
            this.setActivity(contextType, activityId);
        }

        public void setInstructor(LRS_Actor instructor) {
            this.instructor = instructor;
        }

        public void setInstructor(String instructorEmail) {
            this.instructor = new LRS_Actor(instructorEmail);
        }

        public void setActivity(String contextType, String activityId) {
            if (contextType == null || "".equals(contextType)) {
                throw new IllegalArgumentException("contextType MUST be set");
            }
            if (activityId == null || "".equals(activityId)) {
                throw new IllegalArgumentException("activityId MUST be set");
            }
            if (this.activitiesMap == null) {
                this.activitiesMap = new LinkedHashMap<String, Map<String, String>>();
            }
            if (!this.activitiesMap.containsKey(contextType) || this.activitiesMap.get(contextType) == null) {
                this.activitiesMap.put(contextType, new LinkedHashMap());
            }
            activityId = activityId.indexOf("://") == -1 ? LearningResourceStoreService.XAPI_ACTIVITIES_PREFIX + activityId : activityId;
            this.activitiesMap.get(contextType).put("id", activityId);
        }

        public void setActivitiesMap(Map<String, Map<String, String>> activitiesMap) {
            this.activitiesMap = activitiesMap;
        }

        public LRS_Actor getInstructor() {
            return this.instructor;
        }

        public String getRevision() {
            return this.revision;
        }

        public Map<String, Map<String, String>> getActivitiesMap() {
            return this.activitiesMap;
        }

        public String getPlatform() {
            return this.platform;
        }

        public String toString() {
            return "Context[instructor=" + this.instructor + ", rev=" + this.revision + ", activities=" + this.activitiesMap + "]";
        }
    }

    public static class LRS_Result {
        Float scaled;
        Number raw;
        Number min;
        Number max;
        String grade;
        Boolean success;
        Boolean completion;
        int duration = -1;
        String response;

        protected LRS_Result() {
        }

        public LRS_Result(boolean completion) {
            this();
            this.completion = completion;
        }

        public LRS_Result(Float scaled, Boolean success) {
            this();
            if (scaled == null) {
                throw new IllegalArgumentException("LRS_Result scaled cannot be null");
            }
            this.setScore(scaled);
            this.success = success;
        }

        public LRS_Result(Number raw, Number min, Number max, Boolean success) {
            this();
            if (raw == null) {
                throw new IllegalArgumentException("LRS_Result raw cannot be null");
            }
            this.setScore(null, raw, min, max);
            this.success = success;
        }

        public LRS_Result(String grade, Boolean success) {
            this();
            if (grade == null || "".equals(grade)) {
                throw new IllegalArgumentException("LRS_Result grade cannot be null or empty");
            }
            this.success = success;
        }

        public void setScore(Float scaled) {
            this.scaled = scaled;
            if (scaled != null) {
                if (scaled.floatValue() < -1.0f) {
                    throw new IllegalArgumentException("LRS_Result scaled cannot be < -1");
                }
                if (scaled.floatValue() > 1.0f) {
                    throw new IllegalArgumentException("LRS_Result scaled cannot be > 1");
                }
            }
        }

        public void setRawScore(Number raw) {
            if (raw != null) {
                if (this.min != null && raw.floatValue() < this.min.floatValue()) {
                    throw new IllegalArgumentException("score raw (" + raw + ") must not be less than min (" + this.min + ")");
                }
                if (this.max != null && raw.floatValue() > this.max.floatValue()) {
                    throw new IllegalArgumentException("score raw (" + raw + ") must not be greater than max (" + this.max + ") inclusive");
                }
            }
            this.raw = raw;
        }

        public void setScore(Float scaled, Number raw, Number min, Number max) {
            if (scaled == null && raw == null && min == null && max == null) {
                throw new IllegalArgumentException("score inputs cannot all be null");
            }
            this.setScore(scaled);
            this.min = min;
            this.max = max;
            if (this.min != null && this.max != null && min.floatValue() > max.floatValue()) {
                throw new IllegalArgumentException("score min (" + this.min + ") must be less than max (" + this.max + ")");
            }
            this.setRawScore(raw);
        }

        public void setGrade(String grade) {
            this.grade = grade;
        }

        public void setSuccess(Boolean success) {
            this.success = success;
        }

        public void setCompletion(Boolean completion) {
            this.completion = completion;
        }

        public void setDuration(int duration) {
            this.duration = duration;
        }

        public void setResponse(String response) {
            this.response = response;
        }

        public Float getScaled() {
            return this.scaled;
        }

        public Number getRaw() {
            return this.raw;
        }

        public Number getMin() {
            return this.min;
        }

        public Number getMax() {
            return this.max;
        }

        public Boolean getSuccess() {
            return this.success;
        }

        public Boolean getCompletion() {
            return this.completion;
        }

        public int getDuration() {
            return this.duration;
        }

        public String getResponse() {
            return this.response;
        }

        public String getGrade() {
            return this.grade;
        }

        public String toString() {
            String points = "";
            if (this.scaled != null) {
                points = "scaled=" + this.scaled;
            }
            if (this.raw != null) {
                points = points + ",raw=" + this.scaled;
            }
            if (this.min != null && this.max != null) {
                points = points + ",min=" + this.min + ",max=" + this.max;
            }
            return "Result[" + points + (this.grade != null ? " " + this.grade : "") + (this.response != null ? " response=" + this.response : "") + (this.success != null ? (this.success.booleanValue() ? " success" : " fail") : "") + (this.completion != null ? (this.completion.booleanValue() ? " complete" : " incomplete") : "") + "]";
        }
    }

    public static class LRS_Object {
        String id;
        String activityType;
        Map<String, String> activityName;
        Map<String, String> descMap;

        protected LRS_Object() {
        }

        public LRS_Object(String uri) {
            this();
            if (uri == null) {
                throw new IllegalArgumentException("LRS_Object uri cannot be null");
            }
            this.id = uri;
        }

        public LRS_Object(String uri, String activityType) {
            this(uri);
            if (activityType == null) {
                throw new IllegalArgumentException("LRS_Object type cannot be null");
            }
            this.activityType = activityType.indexOf("://") == -1 ? LearningResourceStoreService.XAPI_ACTIVITIES_PREFIX + activityType : activityType;
        }

        public void setActivityType(String type) {
            this.activityType = type;
        }

        public void setDescription(Map<String, String> desc) {
            this.descMap = desc;
        }

        public void setActivityName(Map<String, String> name) {
            this.activityName = name;
        }

        public String getId() {
            return this.id;
        }

        public Map<String, String> getActivityName() {
            return this.activityName;
        }

        public String getActivityType() {
            return this.activityType;
        }

        public Map<String, String> getDescription() {
            return this.descMap;
        }

        public String toString() {
            return "Object[id=" + this.id + ", activityType=" + this.activityType + "]";
        }
    }

    public static class LRS_Verb {
        static String XAPI_VERBS_PREFIX = "http://www.adlnet.gov/expapi/verbs/";
        static String SAKAI_VERBS_PREFIX = "http://sakaiproject.org/expapi/verbs/";
        String id;
        Map<String, String> display;

        protected LRS_Verb() {
        }

        public LRS_Verb(SAKAI_VERB verb) {
            this();
            if (verb == null) {
                throw new IllegalArgumentException("LRS_Verb SAKAI_VERB verb cannot be null");
            }
            this.id = XAPI_VERBS_PREFIX + verb.name();
        }

        public LRS_Verb(String verb) {
            this();
            if (verb == null) {
                throw new IllegalArgumentException("LRS_Verb verb cannot be null");
            }
            this.id = verb.indexOf("://") == -1 ? SAKAI_VERBS_PREFIX + verb : verb;
        }

        public void setDisplay(Map<String, String> display) {
            this.display = display;
        }

        public String getId() {
            return this.id;
        }

        public Map<String, String> getDisplay() {
            return this.display;
        }

        public String toString() {
            return "Verb[id=" + this.id + "]";
        }

        public static enum SAKAI_VERB {
            answered,
            asked,
            attempted,
            attended,
            commented,
            completed,
            exited,
            experienced,
            failed,
            imported,
            initialized,
            interacted,
            launched,
            mastered,
            passed,
            preferred,
            progressed,
            registered,
            responded,
            resumed,
            scored,
            shared,
            suspended,
            terminated,
            voided;

        }
    }

    public static class LRS_Actor {
        String objectType = "Agent";
        String name;
        String mbox;

        static LRS_Actor makeFromEmail(String email) {
            LRS_Actor actor = new LRS_Actor(email);
            return actor;
        }

        protected LRS_Actor() {
        }

        public LRS_Actor(String email) {
            this();
            if (email == null) {
                throw new IllegalArgumentException("LRS_Actor email cannot be null");
            }
            this.mbox = "mailto:" + email;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getObjectType() {
            return this.objectType;
        }

        public String getName() {
            return this.name;
        }

        public String getMbox() {
            return this.mbox;
        }

        public String toString() {
            return "Actor[mbox=" + this.mbox + ", name=" + this.name + "]";
        }
    }

    public static class LRS_Statement {
        boolean populated = false;
        Map<String, Object> rawMap;
        String rawJSON;
        String id = null;
        Date timestamp = new Date();
        Date stored;
        LRS_Actor actor;
        LRS_Verb verb;
        LRS_Object object;
        LRS_Result result;
        LRS_Context context;

        protected LRS_Statement() {
        }

        public LRS_Statement(LRS_Actor actor, LRS_Verb verb, LRS_Object object) {
            this();
            if (actor == null) {
                throw new IllegalArgumentException("LRS_Actor cannot be null");
            }
            if (verb == null) {
                throw new IllegalArgumentException("LRS_Verb cannot be null");
            }
            if (object == null) {
                throw new IllegalArgumentException("LRS_Object cannot be null");
            }
            this.actor = actor;
            this.verb = verb;
            this.object = object;
            this.populated = true;
        }

        public LRS_Statement(LRS_Actor actor, LRS_Verb verb, LRS_Object object, LRS_Result result, LRS_Context context) {
            this(actor, verb, object);
            this.result = result;
            this.context = context;
        }

        public LRS_Statement(String actorEmail, String verbStr, String objectURI) {
            this(new LRS_Actor(actorEmail), new LRS_Verb(verbStr), new LRS_Object(objectURI));
        }

        public LRS_Statement(String actorEmail, String verbStr, String objectURI, boolean resultSuccess, float resultScaledScore) {
            this(new LRS_Actor(actorEmail), new LRS_Verb(verbStr), new LRS_Object(objectURI));
            this.result = new LRS_Result(Float.valueOf(resultScaledScore), (Boolean)resultSuccess);
        }

        public LRS_Statement(Map<String, Object> rawData) {
            this();
            this.populated = false;
            this.rawMap = rawData;
            if (rawData != null) {
                if (!rawData.containsKey("actor") || rawData.get("actor") == null) {
                    throw new IllegalArgumentException("actor key MUST be set and NOT null");
                }
                if (!rawData.containsKey("verb") || rawData.get("verb") == null) {
                    throw new IllegalArgumentException("verb key MUST be set and NOT null");
                }
                if (!rawData.containsKey("object") || rawData.get("object") == null) {
                    throw new IllegalArgumentException("object key MUST be set and NOT null");
                }
                this.rawMap = new LinkedHashMap<String, Object>(rawData);
                this.rawJSON = null;
            }
        }

        public LRS_Statement(String rawJSON) {
            this();
            this.populated = false;
            this.rawJSON = rawJSON;
            if (rawJSON != null) {
                this.rawMap = null;
            }
        }

        public void setContext(LRS_Context context) {
            this.context = context;
        }

        public void setResult(LRS_Result result) {
            this.result = result;
        }

        public boolean isPopulated() {
            return this.populated;
        }

        public Map<String, Object> getRawMap() {
            return this.rawMap;
        }

        public String getRawJSON() {
            return this.rawJSON;
        }

        public String getId() {
            return this.id;
        }

        public Date getTimestamp() {
            return this.timestamp;
        }

        public Date getStored() {
            return this.stored;
        }

        public LRS_Actor getActor() {
            return this.actor;
        }

        public LRS_Verb getVerb() {
            return this.verb;
        }

        public LRS_Object getObject() {
            return this.object;
        }

        public LRS_Result getResult() {
            return this.result;
        }

        public LRS_Context getContext() {
            return this.context;
        }

        public String toString() {
            String s = this.getRawJSON() != null && !"".equals(this.getRawJSON()) ? "Statement(json):" + this.getRawJSON() : (this.getRawMap() != null && !this.getRawMap().isEmpty() ? "Statement(map):" + this.getRawJSON() : "Statement[pop=" + this.populated + ", id=" + this.id + ", timestamp=" + this.timestamp + ", actor=" + this.actor + ", verb=" + this.verb + ", object=" + this.object + (this.result == null ? "" : ", result=" + this.result) + (this.context == null ? "" : ", context=" + this.context) + "]");
            return s;
        }
    }
}

