/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.email.api;

import java.util.ArrayList;
import java.util.List;

public class EmailAddress {
    private String personal;
    private final String address;

    public EmailAddress(String address) {
        this.address = address;
    }

    public EmailAddress(String address, String name) {
        this(address);
        this.personal = name;
    }

    public String getPersonal() {
        return this.personal;
    }

    public String getAddress() {
        return this.address;
    }

    public String toString() {
        String retval = this.getAddress();
        if (this.getPersonal() != null && this.getPersonal().trim().length() > 0) {
            retval = "\"" + this.getPersonal() + "\" <" + this.getAddress() + ">";
        }
        return retval;
    }

    public static List<String> toStringList(List<EmailAddress> emails) {
        ArrayList<String> output = new ArrayList<String>();
        if (emails != null && !emails.isEmpty()) {
            for (EmailAddress ea : emails) {
                output.add(ea.toString());
            }
        }
        return output;
    }

    public static String toString(List<EmailAddress> emails) {
        StringBuilder output = new StringBuilder();
        if (emails != null && !emails.isEmpty()) {
            for (EmailAddress ea : emails) {
                output.append(ea.toString()).append(", ");
            }
            output.delete(output.length() - 2, output.length());
        }
        return output.toString();
    }

    public static enum RecipientType {
        TO,
        CC,
        BCC,
        ACTUAL;

    }
}

