/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.authz.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sakaiproject.authz.api.AuthzGroup;
import org.sakaiproject.authz.api.AuthzGroupAdvisor;
import org.sakaiproject.authz.api.AuthzPermissionException;
import org.sakaiproject.authz.api.GroupAlreadyDefinedException;
import org.sakaiproject.authz.api.GroupFullException;
import org.sakaiproject.authz.api.GroupIdInvalidException;
import org.sakaiproject.authz.api.GroupNotDefinedException;
import org.sakaiproject.entity.api.EntityProducer;
import org.sakaiproject.javax.PagingPosition;

public interface AuthzGroupService
extends EntityProducer {
    public static final String APPLICATION_ID = "sakai:authzGroup";
    public static final String REFERENCE_ROOT = "/realm";
    public static final String SECURE_ADD_AUTHZ_GROUP = "realm.add";
    public static final String SECURE_REMOVE_AUTHZ_GROUP = "realm.del";
    public static final String SECURE_UPDATE_AUTHZ_GROUP = "realm.upd";
    public static final String SECURE_JOIN_AUTHZ_GROUP = "realm.join";
    public static final String SECURE_UNJOIN_AUTHZ_GROUP = "realm.unjoin";
    public static final String SECURE_VIEW_ALL_AUTHZ_GROUPS = "realm.view.all";
    public static final String SECURE_UPDATE_OWN_AUTHZ_GROUP = "realm.upd.own";
    public static final String ANON_ROLE = ".anon";
    public static final String AUTH_ROLE = ".auth";

    public List<AuthzGroup> getAuthzGroups(String var1, PagingPosition var2);

    public List<AuthzGroup> getAuthzUserGroupIds(ArrayList<String> var1, String var2);

    public int countAuthzGroups(String var1);

    public AuthzGroup getAuthzGroup(String var1) throws GroupNotDefinedException;

    public boolean allowUpdate(String var1);

    public void save(AuthzGroup var1) throws GroupNotDefinedException, AuthzPermissionException;

    public boolean allowAdd(String var1);

    public AuthzGroup addAuthzGroup(String var1) throws GroupIdInvalidException, GroupAlreadyDefinedException, AuthzPermissionException;

    public AuthzGroup addAuthzGroup(String var1, AuthzGroup var2, String var3) throws GroupIdInvalidException, GroupAlreadyDefinedException, AuthzPermissionException;

    public boolean allowRemove(String var1);

    public void removeAuthzGroup(AuthzGroup var1) throws AuthzPermissionException;

    public void removeAuthzGroup(String var1) throws AuthzPermissionException;

    public String authzGroupReference(String var1);

    public void joinGroup(String var1, String var2) throws GroupNotDefinedException, AuthzPermissionException;

    public void joinGroup(String var1, String var2, int var3) throws GroupNotDefinedException, AuthzPermissionException, GroupFullException;

    public void unjoinGroup(String var1) throws GroupNotDefinedException, AuthzPermissionException;

    public boolean allowJoinGroup(String var1);

    public boolean allowUnjoinGroup(String var1);

    public boolean isAllowed(String var1, String var2, String var3);

    public boolean isAllowed(String var1, String var2, Collection<String> var3);

    public Set<String> getUsersIsAllowed(String var1, Collection<String> var2);

    public Set<String[]> getUsersIsAllowedByGroup(String var1, Collection<String> var2);

    public Map<String, Integer> getUserCountIsAllowed(String var1, Collection<String> var2);

    public Set<String> getAuthzGroupsIsAllowed(String var1, String var2, Collection<String> var3);

    public Set<String> getAllowedFunctions(String var1, Collection<String> var2);

    public String getUserRole(String var1, String var2);

    public Map<String, String> getUserRoles(String var1, Collection<String> var2);

    public Map<String, String> getUsersRole(Collection<String> var1, String var2);

    public void refreshUser(String var1);

    public AuthzGroup newAuthzGroup(String var1, AuthzGroup var2, String var3) throws GroupAlreadyDefinedException;

    public Set<String> getAuthzGroupIds(String var1);

    public Set<String> getProviderIds(String var1);

    public Collection<String> getAuthzUsersInGroups(Set<String> var1);

    public void addAuthzGroupAdvisor(AuthzGroupAdvisor var1);

    public boolean removeAuthzGroupAdvisor(AuthzGroupAdvisor var1);

    public List<AuthzGroupAdvisor> getAuthzGroupAdvisors();

    public Set<String> getMaintainRoles();
}

