/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.util;

import java.io.File;
import java.io.FileFilter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import org.sakaiproject.util.TerracottaClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class ComponentsLoader {
    private static final Logger log = LoggerFactory.getLogger(ComponentsLoader.class);
    private File overridesFolder;

    public ComponentsLoader() {
        this(null);
    }

    public ComponentsLoader(File overridesFolder) {
        this.overridesFolder = overridesFolder;
    }

    public void load(ConfigurableApplicationContext ac, String componentsRoot) {
        try {
            File root = new File(componentsRoot);
            if (!root.isDirectory()) {
                log.warn("load: root not directory: " + componentsRoot);
                return;
            }
            File[] packageArray = root.listFiles();
            if (packageArray == null) {
                log.warn("load: empty directory: " + componentsRoot);
                return;
            }
            List<File> packages = Arrays.asList(packageArray);
            Collections.sort(packages);
            if (System.getProperty("sakai.components.reverse.load") != null) {
                Collections.reverse(packages);
            }
            log.info("load: loading components from: " + componentsRoot);
            for (File packageDir : packages) {
                if (this.validComponentsPackage(packageDir)) {
                    this.loadComponentPackage(packageDir, ac);
                    continue;
                }
                log.warn("load: skipping non-package entry: " + packageDir);
            }
        }
        catch (Exception e) {
            log.error("load: exception: " + e, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadComponentPackage(File dir, ConfigurableApplicationContext ac) {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        ClassLoader loader = this.newPackageClassLoader(dir);
        log.info("loadComponentPackage: " + dir);
        Thread.currentThread().setContextClassLoader(loader);
        File xml = null;
        try {
            File override;
            File webinf = new File(dir, "WEB-INF");
            xml = new File(webinf, "components.xml");
            XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)ac.getBeanFactory());
            reader.setBeanClassLoader(loader);
            ArrayList<FileSystemResource> beanDefList = new ArrayList<FileSystemResource>();
            beanDefList.add(new FileSystemResource(xml.getCanonicalPath()));
            File demoXml = new File(webinf, "components-demo.xml");
            if ("true".equalsIgnoreCase(System.getProperty("sakai.demo"))) {
                if (log.isDebugEnabled()) {
                    log.debug("Attempting to load demo components");
                }
                if (demoXml.exists()) {
                    if (log.isInfoEnabled()) {
                        log.info("Loading demo components from " + dir);
                    }
                    beanDefList.add(new FileSystemResource(demoXml.getCanonicalPath()));
                }
            } else if (demoXml.exists() && log.isInfoEnabled()) {
                log.info("Skipping demo components from " + dir);
            }
            if (this.overridesFolder != null && (override = new File(this.overridesFolder, dir.getName() + ".xml")).isFile()) {
                beanDefList.add(new FileSystemResource(override.getCanonicalPath()));
                if (log.isInfoEnabled()) {
                    log.info("Overriding component definitions with " + override);
                }
            }
            reader.loadBeanDefinitions(beanDefList.toArray(new Resource[0]));
        }
        catch (Exception e) {
            log.error("loadComponentPackage: exception loading: " + xml + " : " + e, (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }

    protected boolean validComponentsPackage(File dir) {
        File xml;
        File webinf;
        return dir != null && dir.isDirectory() && (webinf = new File(dir, "WEB-INF")) != null && webinf.isDirectory() && (xml = new File(webinf, "components.xml")) != null && xml.isFile();
    }

    protected ClassLoader newPackageClassLoader(File dir) {
        Object[] jars;
        File lib;
        Vector<URL> urls = new Vector<URL>();
        File webinf = new File(dir, "WEB-INF");
        File classes = new File(webinf, "classes");
        if (classes != null && classes.isDirectory()) {
            try {
                URL url = new URL("file:" + classes.getCanonicalPath() + "/");
                urls.add(url);
            }
            catch (Exception e) {
                log.warn("Bad url for classes: " + classes.getPath() + " : " + e);
            }
        }
        if ((lib = new File(webinf, "lib")) != null && lib.isDirectory() && (jars = lib.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile() && file.getName().endsWith(".jar");
            }
        })) != null) {
            Arrays.sort(jars);
            for (int j = 0; j < jars.length; ++j) {
                if (jars[j] == null) continue;
                try {
                    URL url = new URL("file:" + ((File)jars[j]).getCanonicalPath());
                    urls.add(url);
                    continue;
                }
                catch (Exception e) {
                    log.warn("Bad url for jar: " + ((File)jars[j]).getPath() + " : " + e);
                }
            }
        }
        URL[] urlArray = urls.toArray(new URL[urls.size()]);
        URLClassLoader loader = null;
        String clusterTerracotta = System.getProperty("sakai.cluster.terracotta");
        loader = "true".equals(clusterTerracotta) ? new TerracottaClassLoader(urlArray, this.getClass().getClassLoader(), dir.getName()) : new URLClassLoader(urlArray, this.getClass().getClassLoader());
        return loader;
    }
}

