/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.component.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.sakaiproject.component.api.ComponentManager;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.util.ComponentsLoader;
import org.sakaiproject.util.SakaiApplicationContext;
import org.sakaiproject.util.SakaiComponentEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ConfigurableApplicationContext;

public class SpringCompMgr
implements ComponentManager {
    private static final Logger log = LoggerFactory.getLogger(SpringCompMgr.class);
    protected static final String CLOSE_ON_SHUTDOWN = "sakai.component.closeonshutdown";
    protected static final String SHUTDOWN_ON_ERROR = "sakai.component.shutdownonerror";
    protected static final String CONFIGURATION_COMPONENT_PACKAGE = "sakai-component-pack";
    protected static final String[] CONFIGURATION_COMPONENTS = new String[]{"org.sakaiproject.component.SakaiPropertyPromoter", "org.sakaiproject.log.api.LogConfigurationManager"};
    protected static final String DEFAULT_CONFIGURATION_FILE = "classpath:/org/sakaiproject/config/sakai-configuration.xml";
    protected static final String CONFIGURATION_FILE_NAME = "sakai-configuration.xml";
    protected SakaiApplicationContext m_ac = null;
    protected Set m_loadedComponents = new HashSet();
    protected int m_childCount = 0;
    protected boolean m_hasBeenClosed = false;
    protected boolean lateRefresh = false;

    public SpringCompMgr(ComponentManager parent) {
    }

    public void init(boolean lateRefresh) {
        if (this.m_ac != null) {
            return;
        }
        this.lateRefresh = lateRefresh;
        this.ensureSakaiHome();
        this.checkSecurityPath();
        this.m_ac = new SakaiApplicationContext();
        this.m_ac.setInitialSingletonNames(CONFIGURATION_COMPONENTS);
        ArrayList<String> configLocationList = new ArrayList<String>();
        configLocationList.add(DEFAULT_CONFIGURATION_FILE);
        String localConfigLocation = System.getProperty("sakai.home") + CONFIGURATION_FILE_NAME;
        File configFile = new File(localConfigLocation);
        if (configFile.exists()) {
            configLocationList.add("file:" + localConfigLocation);
        }
        this.m_ac.setConfigLocations(configLocationList.toArray(new String[0]));
        this.loadComponents();
        if (System.getProperty(CLOSE_ON_SHUTDOWN) != null) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    SpringCompMgr.this.close();
                }
            });
        }
        if (!lateRefresh) {
            try {
                this.m_ac.refresh();
                this.m_ac.start();
                this.m_ac.publishEvent(new SakaiComponentEvent(this, SakaiComponentEvent.Type.STARTED));
            }
            catch (Exception e) {
                if (Boolean.valueOf(System.getProperty(SHUTDOWN_ON_ERROR, "false")).booleanValue()) {
                    log.error(e.getMessage(), (Throwable)e);
                    log.error("Shutting down JVM");
                    System.exit(1);
                }
                log.error(e.getMessage(), (Throwable)e);
            }
            try {
                final ServerConfigurationService scs = this.get(ServerConfigurationService.class);
                if (scs != null) {
                    ServerConfigurationService.ConfigData cd = scs.getConfigData();
                    log.info("Configuration loaded " + cd.getTotalConfigItems() + " values, " + cd.getRegisteredConfigItems() + " registered");
                    if (scs.getBoolean("config.dump.to.log", false)) {
                        log.info("Configuration values:\n" + cd.toString());
                        Timer timer = new Timer(true);
                        timer.schedule(new TimerTask(){

                            @Override
                            public void run() {
                                log.info("Configuration values: (delay 1):\n" + scs.getConfigData().toString());
                            }
                        }, 120000L);
                        timer.schedule(new TimerTask(){

                            @Override
                            public void run() {
                                log.info("Configuration values: (delay 2):\n" + scs.getConfigData().toString());
                            }
                        }, 300000L);
                    }
                } else {
                    log.warn("Configuration: Unable to get and dump out the registered server config values because no ServerConfigurationService is available - this is OK if this is part of a test, this is very bad otherwise");
                }
            }
            catch (Exception e) {
                log.error("Configuration: Unable to get and dump out the registered server config values (config.dump.to.log): " + e, (Throwable)e);
            }
        }
    }

    public ConfigurableApplicationContext getApplicationContext() {
        return this.m_ac;
    }

    @Override
    public <T> T get(Class<T> iface) {
        Object component = null;
        try {
            component = this.m_ac.getBean(iface.getName(), iface);
        }
        catch (NoSuchBeanDefinitionException e) {
            if (log.isDebugEnabled()) {
                log.debug("get(" + iface.getName() + "): " + (Object)((Object)e), (Throwable)e);
            }
        }
        catch (Exception e) {
            log.error("get(" + iface.getName() + "): ", (Throwable)e);
        }
        return (T)component;
    }

    @Override
    public Object get(String ifaceName) {
        Object component = null;
        try {
            component = this.m_ac.getBean(ifaceName);
        }
        catch (NoSuchBeanDefinitionException e) {
            if (log.isDebugEnabled()) {
                log.debug("get(" + ifaceName + "): " + (Object)((Object)e), (Throwable)e);
            }
        }
        catch (Exception e) {
            log.error("get(" + ifaceName + "): ", (Throwable)e);
        }
        return component;
    }

    @Override
    public boolean contains(Class iface) {
        boolean found = this.m_ac.containsBeanDefinition(iface.getName());
        return found;
    }

    @Override
    public boolean contains(String ifaceName) {
        boolean found = this.m_ac.containsBeanDefinition(ifaceName);
        return found;
    }

    public Set getRegisteredInterfaces() {
        HashSet<String> rv = new HashSet<String>();
        String[] names = this.m_ac.getBeanDefinitionNames();
        for (int i = 0; i < names.length; ++i) {
            rv.add(names[i]);
        }
        for (String loaded : this.m_loadedComponents) {
            rv.add(loaded);
        }
        return rv;
    }

    @Override
    public void close() {
        this.m_hasBeenClosed = true;
        if (!this.lateRefresh) {
            this.m_ac.stop();
        }
        if (this.m_ac.isActive()) {
            this.m_ac.publishEvent(new SakaiComponentEvent(this, SakaiComponentEvent.Type.STOPPING));
        }
        this.m_ac.close();
    }

    @Override
    public void loadComponent(Class iface, Object component) {
        this.m_loadedComponents.add(iface.getName());
        this.m_ac.getBeanFactory().registerSingleton(iface.getName(), component);
    }

    @Override
    public void loadComponent(String ifaceName, Object component) {
        this.m_loadedComponents.add(ifaceName);
        this.m_ac.getBeanFactory().registerSingleton(ifaceName, component);
    }

    protected void loadComponents() {
        String catalina;
        File overrideFolder = new File(System.getProperty("sakai.home"), "override");
        ComponentsLoader loader = new ComponentsLoader(overrideFolder);
        String componentsRoot = System.getProperty("sakai.components.root");
        if (componentsRoot == null && (catalina = this.getCatalina()) != null) {
            componentsRoot = catalina + File.separatorChar + "components" + File.separatorChar;
        }
        if (componentsRoot == null) {
            log.warn("loadComponents: cannot establish a root directory for the components packages");
            return;
        }
        System.setProperty("sakai.components.root", componentsRoot);
        loader.load((ConfigurableApplicationContext)this.m_ac, componentsRoot);
    }

    public synchronized void addChildAc() {
        ++this.m_childCount;
    }

    public synchronized void removeChildAc() {
        --this.m_childCount;
        if (this.m_childCount == 0 && System.getProperty(CLOSE_ON_SHUTDOWN) == null) {
            this.close();
        }
    }

    protected String getCatalina() {
        String catalina = System.getProperty("catalina.base");
        if (catalina == null) {
            catalina = System.getProperty("catalina.home");
        }
        return catalina;
    }

    @Override
    public Properties getConfig() {
        if (log.isErrorEnabled()) {
            log.error("getConfig called; ServerConfigurationService should be used instead", (Throwable)new Exception());
        }
        return null;
    }

    @Override
    public void waitTillConfigured() {
    }

    @Override
    public boolean hasBeenClosed() {
        return this.m_hasBeenClosed;
    }

    private void ensureSakaiHome() {
        File sakaiHomeDirectory;
        String catalina;
        String sakaiHomePath = System.getProperty("sakai.home");
        if (sakaiHomePath == null && (catalina = this.getCatalina()) != null) {
            sakaiHomePath = catalina + File.separatorChar + "sakai" + File.separatorChar;
        }
        if (sakaiHomePath == null) {
            sakaiHomePath = File.separatorChar + "tmp" + File.separatorChar + "sakai" + File.separatorChar;
        }
        if (!sakaiHomePath.endsWith(File.separator)) {
            sakaiHomePath = sakaiHomePath + File.separatorChar;
        }
        if (!(sakaiHomeDirectory = new File(sakaiHomePath)).exists()) {
            if (sakaiHomeDirectory.mkdir()) {
                log.debug("Created sakai.home directory at: " + sakaiHomePath);
            } else {
                log.warn("Could not create sakai.home directory at: " + sakaiHomePath);
            }
        }
        System.setProperty("sakai.home", sakaiHomePath);
    }

    private void checkSecurityPath() {
        String securityPath = System.getProperty("sakai.security");
        if (securityPath != null) {
            if (!securityPath.endsWith(File.separator)) {
                securityPath = securityPath + File.separatorChar;
            }
            System.setProperty("sakai.security", securityPath);
        }
    }
}

