/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.util;

import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import org.sakaiproject.util.ComponentsLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TerracottaClassLoader
extends URLClassLoader {
    private static Logger log = LoggerFactory.getLogger(ComponentsLoader.class);
    private String classLoaderName;

    public TerracottaClassLoader(URL[] urls, ClassLoader parent, String classLoaderName) {
        super(urls, parent);
        this.classLoaderName = classLoaderName;
        boolean registeredWithTerracotta = false;
        try {
            if (parent == null) {
                log.error("Parent classloader is set to null.");
            } else {
                Class<?> namedClassLoader = parent.loadClass("com.tc.object.loaders.NamedClassLoader");
                if (namedClassLoader == null) {
                    log.error("Could not load Terracotta NamedClassLoader");
                } else {
                    Class<?> helper = parent.loadClass("com.tc.object.bytecode.hook.impl.ClassProcessorHelper");
                    if (helper == null) {
                        log.error("Could not load Terracotta ClassProcessorHelper");
                    } else {
                        Method m = helper.getMethod("registerGlobalLoader", namedClassLoader);
                        if (m == null) {
                            log.error("Could not find Terracotta Method - \"registerGlobalLoader\"");
                        } else {
                            m.invoke(null, this);
                            registeredWithTerracotta = true;
                            if (log.isInfoEnabled()) {
                                log.info("Registered the [" + classLoaderName + "] class loader with Terracotta.");
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("Unexpected error occurred trying to register class loader [" + classLoaderName + "] with Terracotta: " + e, (Throwable)e);
        }
        if (!registeredWithTerracotta) {
            log.warn("The [" + classLoaderName + "] class loader is not registered with Terracotta.  Objects from this class loader will not be shared.");
        }
    }

    public String __tc_getClassLoaderName() {
        return this.classLoaderName;
    }
}

