/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.util;

import java.io.File;
import java.io.FileFilter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.util.TerracottaClassLoader;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class ComponentsLoader {
    private static Log M_log = LogFactory.getLog(ComponentsLoader.class);

    public void load(ConfigurableApplicationContext ac, String componentsRoot) {
        try {
            File root = new File(componentsRoot);
            if (!root.isDirectory()) {
                M_log.warn((Object)("load: root not directory: " + componentsRoot));
                return;
            }
            File[] packageArray = root.listFiles();
            if (packageArray == null) {
                M_log.warn((Object)("load: empty directory: " + componentsRoot));
                return;
            }
            ArrayList<File> packages = new ArrayList<File>(Arrays.asList(packageArray));
            final int reverse = System.getProperty("sakai.components.reverse.load") != null ? -1 : 1;
            Collections.sort(packages, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    File f1 = (File)o1;
                    File f2 = (File)o2;
                    int sort = f1.compareTo(f2);
                    return sort * reverse;
                }
            });
            M_log.info((Object)("load: loading components from: " + componentsRoot));
            for (File packageDir : packages) {
                if (this.validComponentsPackage(packageDir)) {
                    this.loadComponentPackage(packageDir, ac);
                    continue;
                }
                M_log.warn((Object)("load: skipping non-package entry: " + packageDir));
            }
        }
        catch (Exception e) {
            M_log.warn((Object)("load: exception: " + e), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadComponentPackage(File dir, ConfigurableApplicationContext ac) {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        ClassLoader loader = this.newPackageClassLoader(dir);
        M_log.info((Object)("loadComponentPackage: " + dir));
        Thread.currentThread().setContextClassLoader(loader);
        File xml = null;
        try {
            File webinf = new File(dir, "WEB-INF");
            xml = new File(webinf, "components.xml");
            XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)ac.getBeanFactory());
            reader.setBeanClassLoader(loader);
            ArrayList<FileSystemResource> beanDefList = new ArrayList<FileSystemResource>();
            beanDefList.add(new FileSystemResource(xml.getCanonicalPath()));
            File demoXml = new File(webinf, "components-demo.xml");
            if ("true".equalsIgnoreCase(System.getProperty("sakai.demo"))) {
                if (M_log.isDebugEnabled()) {
                    M_log.debug((Object)"Attempting to load demo components");
                }
                if (demoXml.exists()) {
                    if (M_log.isInfoEnabled()) {
                        M_log.info((Object)("Loading demo components from " + dir));
                    }
                    beanDefList.add(new FileSystemResource(demoXml.getCanonicalPath()));
                }
            } else if (demoXml.exists() && M_log.isInfoEnabled()) {
                M_log.info((Object)("Skipping demo components from " + dir));
            }
            reader.loadBeanDefinitions(beanDefList.toArray(new Resource[0]));
        }
        catch (Exception e) {
            M_log.warn((Object)("loadComponentPackage: exception loading: " + xml + " : " + e), (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }

    protected boolean validComponentsPackage(File dir) {
        File xml;
        File webinf;
        return dir != null && dir.isDirectory() && (webinf = new File(dir, "WEB-INF")) != null && webinf.isDirectory() && (xml = new File(webinf, "components.xml")) != null && xml.isFile();
    }

    protected ClassLoader newPackageClassLoader(File dir) {
        File[] jars;
        File lib;
        Vector<URL> urls = new Vector<URL>();
        File webinf = new File(dir, "WEB-INF");
        File classes = new File(webinf, "classes");
        if (classes != null && classes.isDirectory()) {
            try {
                URL url = new URL("file:" + classes.getCanonicalPath() + "/");
                urls.add(url);
            }
            catch (Exception e) {
                M_log.warn((Object)("Bad url for classes: " + classes.getPath() + " : " + e));
            }
        }
        if ((lib = new File(webinf, "lib")) != null && lib.isDirectory() && (jars = lib.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isFile() && file.getName().endsWith(".jar");
            }
        })) != null) {
            for (int j = 0; j < jars.length; ++j) {
                if (jars[j] == null) continue;
                try {
                    URL url = new URL("file:" + jars[j].getCanonicalPath());
                    urls.add(url);
                    continue;
                }
                catch (Exception e) {
                    M_log.warn((Object)("Bad url for jar: " + jars[j].getPath() + " : " + e));
                }
            }
        }
        URL[] urlArray = urls.toArray(new URL[urls.size()]);
        URLClassLoader loader = null;
        String clusterTerracotta = System.getProperty("sakai.cluster.terracotta");
        loader = "true".equals(clusterTerracotta) ? new TerracottaClassLoader(urlArray, this.getClass().getClassLoader(), dir.getName()) : new URLClassLoader(urlArray, this.getClass().getClassLoader());
        return loader;
    }
}

