/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.util;

import org.sakaiproject.component.api.ServerConfigurationService;

public class BasicConfigItem
implements ServerConfigurationService.ConfigItem {
    protected String name;
    protected Object value = null;
    protected Object defaultValue = null;
    protected String source = "UNKNOWN";

    protected BasicConfigItem() {
    }

    public BasicConfigItem(String name, Object value, Object defaultValue, String source) {
        if (name == null || "".equals(name)) {
            throw new IllegalArgumentException("name must be set");
        }
        this.name = name;
        if (value == null && defaultValue == null) {
            throw new IllegalArgumentException("value OR defaultValue must be set");
        }
        this.value = value;
        this.defaultValue = defaultValue;
        if (source != null && !"".equals(source)) {
            this.source = source;
        }
    }

    public int requested() {
        return 0;
    }

    public int changed(Object value, String source) {
        return 0;
    }

    public ServerConfigurationService.ConfigItem copy() {
        return new BasicConfigItem(this.name, this.value, this.defaultValue, this.source);
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public String getType() {
        return "UNKNOWN";
    }

    public String getSource() {
        return this.source;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public int getRequested() {
        return 0;
    }

    public int getChanged() {
        return 0;
    }

    public int getVersion() {
        return 1;
    }

    public ServerConfigurationService.ConfigHistory[] getHistory() {
        return new ServerConfigurationService.ConfigHistory[0];
    }

    public boolean isRegistered() {
        return false;
    }

    public boolean isDefaulted() {
        return this.defaultValue != null;
    }

    public boolean isSecured() {
        return false;
    }

    public static ServerConfigurationService.ConfigItem makeDefaultedConfigItem(String name, Object defaultValue, String source) {
        return new BasicConfigItem(name, null, defaultValue, source);
    }

    public static ServerConfigurationService.ConfigItem makeConfigItem(String name, Object value, String source) {
        return new BasicConfigItem(name, value, null, source);
    }
}

