/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.component.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.component.api.ComponentManager;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.util.ComponentsLoader;
import org.sakaiproject.util.SakaiApplicationContext;
import org.sakaiproject.util.SakaiComponentEvent;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ConfigurableApplicationContext;

public class SpringCompMgr
implements ComponentManager {
    private static Log M_log = LogFactory.getLog(SpringCompMgr.class);
    protected static final String CLOSE_ON_SHUTDOWN = "sakai.component.closeonshutdown";
    protected static final String SHUTDOWN_ON_ERROR = "sakai.component.shutdownonerror";
    protected static final String CONFIGURATION_COMPONENT_PACKAGE = "sakai-component-pack";
    protected static final String[] CONFIGURATION_COMPONENTS = new String[]{"org.sakaiproject.component.SakaiPropertyPromoter", "org.sakaiproject.log.api.LogConfigurationManager"};
    protected static final String DEFAULT_CONFIGURATION_FILE = "classpath:/org/sakaiproject/config/sakai-configuration.xml";
    protected static final String CONFIGURATION_FILE_NAME = "sakai-configuration.xml";
    protected SakaiApplicationContext m_ac = null;
    protected Set m_loadedComponents = new HashSet();
    protected int m_childCount = 0;
    protected boolean m_hasBeenClosed = false;

    public SpringCompMgr(ComponentManager parent) {
    }

    public void init(boolean lateRefresh) {
        if (this.m_ac != null) {
            return;
        }
        this.ensureSakaiHome();
        this.checkSecurityPath();
        this.m_ac = new SakaiApplicationContext();
        this.m_ac.setInitialSingletonNames(CONFIGURATION_COMPONENTS);
        ArrayList<String> configLocationList = new ArrayList<String>();
        configLocationList.add(DEFAULT_CONFIGURATION_FILE);
        String localConfigLocation = System.getProperty("sakai.home") + CONFIGURATION_FILE_NAME;
        File configFile = new File(localConfigLocation);
        if (configFile.exists()) {
            configLocationList.add("file:" + localConfigLocation);
        }
        this.m_ac.setConfigLocations(configLocationList.toArray(new String[0]));
        this.loadComponents();
        if (System.getProperty(CLOSE_ON_SHUTDOWN) != null) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    SpringCompMgr.this.close();
                }
            });
        }
        if (!lateRefresh) {
            try {
                this.m_ac.refresh();
                this.m_ac.publishEvent(new SakaiComponentEvent(this, SakaiComponentEvent.Type.STARTED));
            }
            catch (Exception e) {
                if (Boolean.valueOf(System.getProperty(SHUTDOWN_ON_ERROR, "false")).booleanValue()) {
                    M_log.fatal((Object)e.getMessage(), (Throwable)e);
                    M_log.fatal((Object)"Shutting down JVM");
                    System.exit(1);
                }
                M_log.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
        try {
            final ServerConfigurationService scs = (ServerConfigurationService)this.get(ServerConfigurationService.class);
            if (scs != null) {
                ServerConfigurationService.ConfigData cd = scs.getConfigData();
                M_log.info((Object)("Configuration loaded " + cd.getTotalConfigItems() + " values, " + cd.getRegisteredConfigItems() + " registered"));
                if (scs.getBoolean("config.dump.to.log", false)) {
                    M_log.info((Object)("Configuration values:\n" + cd.toString()));
                    Timer timer = new Timer(true);
                    timer.schedule(new TimerTask(){

                        public void run() {
                            M_log.info((Object)("Configuration values: (delay 1):\n" + scs.getConfigData().toString()));
                        }
                    }, 120000L);
                    timer.schedule(new TimerTask(){

                        public void run() {
                            M_log.info((Object)("Configuration values: (delay 2):\n" + scs.getConfigData().toString()));
                        }
                    }, 300000L);
                }
            } else {
                M_log.warn((Object)"Configuration: Unable to get and dump out the registered server config values because no ServerConfigurationService is available - this is OK if this is part of a test, this is very bad otherwise");
            }
        }
        catch (Exception e) {
            M_log.error((Object)("Configuration: Unable to get and dump out the registered server config values (config.dump.to.log): " + e), (Throwable)e);
        }
    }

    public ConfigurableApplicationContext getApplicationContext() {
        return this.m_ac;
    }

    public Object get(Class iface) {
        Object component = null;
        try {
            component = this.m_ac.getBean(iface.getName(), iface);
        }
        catch (NoSuchBeanDefinitionException e) {
            if (M_log.isDebugEnabled()) {
                M_log.debug((Object)("get(" + iface.getName() + "): " + (Object)((Object)e)), (Throwable)e);
            }
        }
        catch (Exception e) {
            M_log.warn((Object)("get(" + iface.getName() + "): "), (Throwable)e);
        }
        return component;
    }

    public Object get(String ifaceName) {
        Object component = null;
        try {
            component = this.m_ac.getBean(ifaceName);
        }
        catch (NoSuchBeanDefinitionException e) {
            if (M_log.isDebugEnabled()) {
                M_log.debug((Object)("get(" + ifaceName + "): " + (Object)((Object)e)), (Throwable)e);
            }
        }
        catch (Exception e) {
            M_log.warn((Object)("get(" + ifaceName + "): "), (Throwable)e);
        }
        return component;
    }

    public boolean contains(Class iface) {
        boolean found = this.m_ac.containsBeanDefinition(iface.getName());
        return found;
    }

    public boolean contains(String ifaceName) {
        boolean found = this.m_ac.containsBeanDefinition(ifaceName);
        return found;
    }

    public Set getRegisteredInterfaces() {
        HashSet<String> rv = new HashSet<String>();
        String[] names = this.m_ac.getBeanDefinitionNames();
        for (int i = 0; i < names.length; ++i) {
            rv.add(names[i]);
        }
        for (String loaded : this.m_loadedComponents) {
            rv.add(loaded);
        }
        return rv;
    }

    public void close() {
        this.m_hasBeenClosed = true;
        if (this.m_ac.isActive()) {
            this.m_ac.publishEvent(new SakaiComponentEvent(this, SakaiComponentEvent.Type.STOPPING));
        }
        this.m_ac.close();
    }

    public void loadComponent(Class iface, Object component) {
        this.m_loadedComponents.add(iface.getName());
        this.m_ac.getBeanFactory().registerSingleton(iface.getName(), component);
    }

    public void loadComponent(String ifaceName, Object component) {
        this.m_loadedComponents.add(ifaceName);
        this.m_ac.getBeanFactory().registerSingleton(ifaceName, component);
    }

    protected void loadComponents() {
        String catalina;
        ComponentsLoader loader = new ComponentsLoader();
        String componentsRoot = System.getProperty("sakai.components.root");
        if (componentsRoot == null && (catalina = this.getCatalina()) != null) {
            componentsRoot = catalina + File.separatorChar + "components" + File.separatorChar;
        }
        if (componentsRoot == null) {
            M_log.warn((Object)"loadComponents: cannot estabish a root directory for the components packages");
            return;
        }
        System.setProperty("sakai.components.root", componentsRoot);
        loader.load((ConfigurableApplicationContext)this.m_ac, componentsRoot);
    }

    public synchronized void addChildAc() {
        ++this.m_childCount;
    }

    public synchronized void removeChildAc() {
        --this.m_childCount;
        if (this.m_childCount == 0 && System.getProperty(CLOSE_ON_SHUTDOWN) == null) {
            this.close();
        }
    }

    protected String getCatalina() {
        String catalina = System.getProperty("catalina.base");
        if (catalina == null) {
            catalina = System.getProperty("catalina.home");
        }
        return catalina;
    }

    public Properties getConfig() {
        if (M_log.isErrorEnabled()) {
            M_log.error((Object)"getConfig called; ServerConfigurationService should be used instead", (Throwable)new Exception());
        }
        return null;
    }

    public void waitTillConfigured() {
    }

    public boolean hasBeenClosed() {
        return this.m_hasBeenClosed;
    }

    private void ensureSakaiHome() {
        File sakaiHomeDirectory;
        String catalina;
        String sakaiHomePath = System.getProperty("sakai.home");
        if (sakaiHomePath == null && (catalina = this.getCatalina()) != null) {
            sakaiHomePath = catalina + File.separatorChar + "sakai" + File.separatorChar;
        }
        if (sakaiHomePath == null) {
            sakaiHomePath = File.separatorChar + "usr" + File.separatorChar + "local" + File.separatorChar + "sakai" + File.separatorChar;
        }
        if (!sakaiHomePath.endsWith(File.separator)) {
            sakaiHomePath = sakaiHomePath + File.separatorChar;
        }
        if (!(sakaiHomeDirectory = new File(sakaiHomePath)).exists()) {
            if (sakaiHomeDirectory.mkdir()) {
                M_log.debug((Object)("Created sakai.home directory at: " + sakaiHomePath));
            } else {
                M_log.warn((Object)("Could not create sakai.home directory at: " + sakaiHomePath));
            }
        }
        System.setProperty("sakai.home", sakaiHomePath);
    }

    private void checkSecurityPath() {
        String securityPath = System.getProperty("sakai.security");
        if (securityPath != null) {
            if (!securityPath.endsWith(File.separator)) {
                securityPath = securityPath + File.separatorChar;
            }
            System.setProperty("sakai.security", securityPath);
        }
    }
}

