/*
 * Decompiled with CFR 0.152.
 */
package org.sagebionetworks.research.modules.common.step.instruction;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import org.sagebionetworks.research.domain.step.interfaces.Step;
import org.sagebionetworks.research.modules.common.step.instruction.InstructionStep;
import org.sagebionetworks.research.presentation.DisplayString;
import org.sagebionetworks.research.presentation.mapper.DrawableMapper;
import org.sagebionetworks.research.presentation.model.ColorThemeView;
import org.sagebionetworks.research.presentation.model.ImageThemeView;
import org.sagebionetworks.research.presentation.model.action.ActionView;
import org.sagebionetworks.research.presentation.model.implementations.ActiveUIStepViewBase;
import org.threeten.bp.Duration;

public class InstructionStepView
extends ActiveUIStepViewBase {
    public static final String TYPE = "instruction";
    private final boolean isFirstRunOnly;

    @NonNull
    public static InstructionStepView fromInstructionStep(@NonNull Step step, DrawableMapper mapper) {
        if (!(step instanceof InstructionStep)) {
            throw new IllegalArgumentException("Provided step: " + step + " is not an InstructionStep");
        }
        InstructionStep instructionStep = (InstructionStep)step;
        ActiveUIStepViewBase activeUIStepView = ActiveUIStepViewBase.fromActiveUIStep((Step)step, (DrawableMapper)mapper);
        return new InstructionStepView(activeUIStepView.getIdentifier(), (ImmutableMap<String, ActionView>)activeUIStepView.getActions(), activeUIStepView.getTitle(), activeUIStepView.getText(), activeUIStepView.getDetail(), activeUIStepView.getFootnote(), activeUIStepView.getColorTheme(), activeUIStepView.getImageTheme(), activeUIStepView.getDuration(), activeUIStepView.getSpokenInstructions(), (ImmutableSet<String>)activeUIStepView.getCommands(), activeUIStepView.isBackgroundAudioRequired(), instructionStep.getIsFirstRunOnly());
    }

    public InstructionStepView(@NonNull String identifier, @NonNull ImmutableMap<String, ActionView> actions, @Nullable DisplayString title, @Nullable DisplayString text, @Nullable DisplayString detail, @Nullable DisplayString footnote, @Nullable ColorThemeView colorTheme, @Nullable ImageThemeView imageTheme, @NonNull Duration duration, @NonNull Map<String, String> spokenInstructions, @NonNull ImmutableSet<String> commands, boolean isBackgroundAudioRequired, boolean isFirstRunOnly) {
        super(identifier, actions, title, text, detail, footnote, colorTheme, imageTheme, duration, spokenInstructions, commands, isBackgroundAudioRequired);
        this.isFirstRunOnly = isFirstRunOnly;
    }

    @NonNull
    public String getType() {
        return TYPE;
    }

    public boolean isFirstRunOnly() {
        return this.isFirstRunOnly;
    }
}

