/*
 * Decompiled with CFR 0.152.
 */
package org.sagebionetworks.research.modules.common.step.overview;

import android.animation.ObjectAnimator;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewPropertyAnimator;
import android.widget.ImageView;
import android.widget.TextView;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.sagebionetworks.research.domain.result.implementations.ResultBase;
import org.sagebionetworks.research.domain.result.interfaces.Result;
import org.sagebionetworks.research.mobile_ui.show_step.view.ShowUIStepFragmentBase;
import org.sagebionetworks.research.mobile_ui.widget.ActionButton;
import org.sagebionetworks.research.modules.common.R;
import org.sagebionetworks.research.modules.common.step.overview.OverviewStepView;
import org.sagebionetworks.research.modules.common.step.overview.OverviewStepViewBinding;
import org.sagebionetworks.research.modules.common.util.FirstRunHelper;
import org.sagebionetworks.research.modules.common.widget.DisableableScrollView;
import org.sagebionetworks.research.presentation.DisplayDrawable;
import org.sagebionetworks.research.presentation.DisplayString;
import org.sagebionetworks.research.presentation.model.interfaces.StepView;
import org.sagebionetworks.research.presentation.model.interfaces.UIStepView;
import org.sagebionetworks.research.presentation.show_step.show_step_view_models.ShowUIStepViewModel;
import org.threeten.bp.Instant;

public class ShowOverviewStepFragment
extends ShowUIStepFragmentBase<OverviewStepView, ShowUIStepViewModel<OverviewStepView>, OverviewStepViewBinding<OverviewStepView>> {
    public static final String INFO_TAPPED_RESULT_ID = "infoTapped";
    private boolean isFirstRun;

    @NonNull
    public static ShowOverviewStepFragment newInstance(@NonNull StepView stepView) {
        ShowOverviewStepFragment fragment = new ShowOverviewStepFragment();
        Bundle arguments = ShowOverviewStepFragment.createArguments((StepView)stepView);
        fragment.setArguments(arguments);
        return fragment;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View returnValue = super.onCreateView(inflater, container, savedInstanceState);
        this.isFirstRun = FirstRunHelper.isFirstRun(this.performTaskViewModel.getTaskResult());
        return returnValue;
    }

    public int getLayoutId() {
        return R.layout.srmc_fragment_show_overview_step;
    }

    protected void handleActionButtonClick(@NonNull ActionButton actionButton) {
        String actionType = this.getActionTypeFromActionButton(actionButton);
        if ("learnMore".equals(actionType)) {
            this.scrollToBottomAndFadeIn();
            this.performTaskViewModel.addStepResult((Result)new ResultBase(INFO_TAPPED_RESULT_ID, Instant.now(), Instant.now()));
        } else {
            super.handleActionButtonClick(actionButton);
        }
    }

    @NonNull
    protected OverviewStepViewBinding<OverviewStepView> instantiateAndBindBinding(View view) {
        return new OverviewStepViewBinding<OverviewStepView>(view);
    }

    public void onStart() {
        super.onStart();
        DisableableScrollView scrollView = ((OverviewStepViewBinding)this.stepViewBinding).getScrollView();
        if (this.isFirstRun) {
            scrollView.post(() -> scrollView.fullScroll(130));
            ((OverviewStepViewBinding)this.stepViewBinding).getInfoButton().setVisibility(8);
        } else {
            scrollView.setScrollingEnabled(false);
            ((OverviewStepViewBinding)this.stepViewBinding).getText().setAlpha(0.0f);
            ((OverviewStepViewBinding)this.stepViewBinding).getOverallIconDescriptionLabel().setAlpha(0.0f);
            for (ImageView imageView : ((OverviewStepViewBinding)this.stepViewBinding).getIconImageViews()) {
                imageView.setAlpha(0.0f);
            }
            for (TextView iconLabel : ((OverviewStepViewBinding)this.stepViewBinding).getIconLabels()) {
                iconLabel.setAlpha(0.0f);
            }
        }
    }

    public void update(OverviewStepView stepView) {
        super.update((UIStepView)stepView);
        List<ImageView> iconImageViews = ((OverviewStepViewBinding)this.stepViewBinding).getIconImageViews();
        List<TextView> iconLabels = ((OverviewStepViewBinding)this.stepViewBinding).getIconLabels();
        ImmutableList<OverviewStepView.IconView> iconViews = stepView.getIconViews();
        for (int i = 0; i < iconImageViews.size(); ++i) {
            Integer resId;
            DisplayDrawable drawable;
            OverviewStepView.IconView iconView = null;
            if (i < iconViews.size()) {
                iconView = (OverviewStepView.IconView)iconViews.get(i);
            }
            if (iconView == null) {
                iconImageViews.get(i).setVisibility(8);
                iconLabels.get(i).setVisibility(8);
                continue;
            }
            DisplayString titleDisplayString = iconView.getTitle();
            if (titleDisplayString != null) {
                String titleString = titleDisplayString.getString(this.getContext().getResources());
                iconLabels.get(i).setText((CharSequence)titleString);
            }
            if ((drawable = iconView.getIcon()) == null || (resId = drawable.getDrawable()) == null) continue;
            iconImageViews.get(i).setImageResource(resId.intValue());
        }
    }

    protected void scrollToBottomAndFadeIn() {
        ((OverviewStepViewBinding)this.stepViewBinding).getScrollView().setScrollingEnabled(true);
        long duration = 300L;
        ArrayList<ViewPropertyAnimator> fadeInAnimators = new ArrayList<ViewPropertyAnimator>();
        fadeInAnimators.add(((OverviewStepViewBinding)this.stepViewBinding).getTitle().animate().alpha(1.0f).setDuration(duration));
        fadeInAnimators.add(((OverviewStepViewBinding)this.stepViewBinding).getText().animate().alpha(1.0f).setDuration(duration));
        fadeInAnimators.add(((OverviewStepViewBinding)this.stepViewBinding).getOverallIconDescriptionLabel().animate().alpha(1.0f).setDuration(duration));
        for (ImageView imageView : ((OverviewStepViewBinding)this.stepViewBinding).getIconImageViews()) {
            fadeInAnimators.add(imageView.animate().alpha(1.0f).setDuration(duration));
        }
        for (TextView iconLabel : ((OverviewStepViewBinding)this.stepViewBinding).getIconLabels()) {
            fadeInAnimators.add(iconLabel.animate().alpha(1.0f).setDuration(duration));
        }
        fadeInAnimators.add(((OverviewStepViewBinding)this.stepViewBinding).getInfoButton().animate().alpha(0.0f).setDuration(duration));
        DisableableScrollView scrollView = ((OverviewStepViewBinding)this.stepViewBinding).getScrollView();
        int bottomY = scrollView.getChildAt(0).getHeight();
        ObjectAnimator scrollViewAnimator = ObjectAnimator.ofInt((Object)((Object)((OverviewStepViewBinding)this.stepViewBinding).getScrollView()), (String)"scrollY", (int[])new int[]{bottomY}).setDuration(duration);
        for (ViewPropertyAnimator animator : fadeInAnimators) {
            animator.start();
        }
        scrollViewAnimator.start();
    }
}

