/*
 * Decompiled with CFR 0.152.
 */
package org.sagebionetworks.research.modules.common.step.overview;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.sagebionetworks.research.domain.step.interfaces.Step;
import org.sagebionetworks.research.modules.common.step.overview.AutoValue_OverviewStepView_IconView;
import org.sagebionetworks.research.modules.common.step.overview.OverviewStep;
import org.sagebionetworks.research.presentation.DisplayDrawable;
import org.sagebionetworks.research.presentation.DisplayString;
import org.sagebionetworks.research.presentation.mapper.DrawableMapper;
import org.sagebionetworks.research.presentation.model.ColorThemeView;
import org.sagebionetworks.research.presentation.model.ImageThemeView;
import org.sagebionetworks.research.presentation.model.action.ActionView;
import org.sagebionetworks.research.presentation.model.implementations.UIStepViewBase;

public class OverviewStepView
extends UIStepViewBase {
    public static final String TYPE = "overview";
    private final ImmutableList<IconView> iconViews;

    @NonNull
    public static OverviewStepView fromOverviewStep(@NonNull Step step, DrawableMapper mapper) {
        if (!(step instanceof OverviewStep)) {
            throw new IllegalArgumentException("Provided step: " + step + " is not an OverviewStep");
        }
        UIStepViewBase uiStepView = UIStepViewBase.fromUIStep((Step)step, (DrawableMapper)mapper);
        OverviewStep overviewStep = (OverviewStep)step;
        ArrayList<IconView> iconViews = new ArrayList<IconView>();
        for (OverviewStep.Icon icon : overviewStep.getIcons()) {
            iconViews.add(IconView.fromIcon(icon, mapper));
        }
        return new OverviewStepView(uiStepView.getIdentifier(), (ImmutableMap<String, ActionView>)uiStepView.getActions(), uiStepView.getTitle(), uiStepView.getText(), uiStepView.getDetail(), uiStepView.getFootnote(), uiStepView.getColorTheme(), uiStepView.getImageTheme(), iconViews);
    }

    public OverviewStepView(@NonNull String identifier, @NonNull ImmutableMap<String, ActionView> actions, @Nullable DisplayString title, @Nullable DisplayString text, @Nullable DisplayString detail, @Nullable DisplayString footnote, @Nullable ColorThemeView colorTheme, @Nullable ImageThemeView imageTheme, @NonNull List<IconView> iconViews) {
        super(identifier, actions, title, text, detail, footnote, colorTheme, imageTheme);
        this.iconViews = ImmutableList.copyOf(iconViews);
    }

    @NonNull
    public String getType() {
        return TYPE;
    }

    @NonNull
    public ImmutableList<IconView> getIconViews() {
        return this.iconViews;
    }

    @AutoValue
    public static abstract class IconView
    implements Serializable {
        public static Builder builder() {
            return new AutoValue_OverviewStepView_IconView.Builder();
        }

        @NonNull
        public static IconView fromIcon(@NonNull OverviewStep.Icon icon, DrawableMapper mapper) {
            String title = icon.getTitle();
            DisplayDrawable iconDrawable = DisplayDrawable.create(null, (Integer)mapper.getDrawableFromName(icon.getIcon()));
            if (title != null) {
                return IconView.builder().setIcon(iconDrawable).setTitle(DisplayString.create(null, (String)title)).build();
            }
            return null;
        }

        public abstract DisplayDrawable getIcon();

        public abstract DisplayString getTitle();

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract IconView build();

            @Nullable
            public abstract Builder setIcon(@Nullable DisplayDrawable var1);

            @Nullable
            public abstract Builder setTitle(@Nullable DisplayString var1);
        }
    }
}

