/*
 * Decompiled with CFR 0.152.
 */
package org.sagebionetworks.bridge.android.manager.dao;

import android.content.Context;
import androidx.annotation.AnyThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.inject.Inject;
import org.sagebionetworks.bridge.android.di.BridgeStudyScope;
import org.sagebionetworks.bridge.android.manager.dao.SharedPreferencesJsonDAO;
import org.sagebionetworks.bridge.rest.UserSessionInfoProvider;
import org.sagebionetworks.bridge.rest.model.StudyParticipant;
import org.sagebionetworks.bridge.rest.model.UserSessionInfo;

@BridgeStudyScope
@AnyThread
public class AccountDAO
extends SharedPreferencesJsonDAO {
    private static final TypeToken<List<String>> STRING_LIST = new TypeToken<List<String>>(){};
    private static final String PREFERENCES_FILE = "accounts";
    private static final String KEY_DATA_GROUPS = "dataGroups";
    private static final String KEY_SESSION_INFO = "session";
    private static final String KEY_STUDY_PARTICIPANT = "participant";
    private static final String KEY_EMAIL = "email";
    private static final String KEY_PHONE_REGION = "phoneRegion";
    private static final String KEY_PHONE_NUMBER = "phoneNumber";
    private static final String KEY_EXTERNAL_ID = "externalId";
    private static final String KEY_PASSWORD = "password";
    private final ReadWriteLock sessionReadWriteLock = new ReentrantReadWriteLock(true);

    @Inject
    public AccountDAO(Context applicationContext) {
        super(applicationContext, PREFERENCES_FILE);
    }

    public void clear() {
        this.sharedPreferences.edit().clear().commit();
    }

    @NonNull
    public List<String> getDataGroups() {
        List<String> rawDataGroupList = this.getValue(KEY_DATA_GROUPS, STRING_LIST);
        if (rawDataGroupList == null) {
            return new ArrayList<String>();
        }
        return rawDataGroupList;
    }

    public void setDataGroups(@NonNull List<String> dataGroupList) {
        this.setValue(KEY_DATA_GROUPS, dataGroupList, STRING_LIST);
    }

    public void addDataGroup(@NonNull String dataGroup) {
        List<String> dataGroupList = this.getDataGroups();
        dataGroupList.add(dataGroup);
        this.setDataGroups(dataGroupList);
    }

    @Nullable
    public UserSessionInfo getUserSessionInfo() {
        Lock readLock = this.sessionReadWriteLock.readLock();
        readLock.lock();
        try {
            UserSessionInfo userSessionInfo = this.getValue(KEY_SESSION_INFO, UserSessionInfo.class);
            return userSessionInfo;
        }
        finally {
            readLock.unlock();
        }
    }

    public void setUserSessionInfo(@Nullable UserSessionInfo userSessionInfo) {
        Lock writeLock = this.sessionReadWriteLock.writeLock();
        writeLock.lock();
        try {
            userSessionInfo = UserSessionInfoProvider.mergeReauthToken((UserSessionInfo)this.getUserSessionInfo(), (UserSessionInfo)userSessionInfo);
            this.setValue(KEY_SESSION_INFO, userSessionInfo, UserSessionInfo.class);
        }
        finally {
            writeLock.unlock();
        }
    }

    @Nullable
    public String getExternalId() {
        return this.getValue(KEY_EXTERNAL_ID, String.class);
    }

    public void setExternalId(@Nullable String externalId) {
        this.setValue(KEY_EXTERNAL_ID, externalId, String.class);
    }

    @Nullable
    public String getEmail() {
        return this.getValue(KEY_EMAIL, String.class);
    }

    public void setEmail(@Nullable String email) {
        this.setValue(KEY_EMAIL, email, String.class);
    }

    @Nullable
    public String getPhoneRegion() {
        return this.getValue(KEY_PHONE_REGION, String.class);
    }

    @Nullable
    public void setPhoneRegion(@Nullable String phoneRegion) {
        this.setValue(KEY_PHONE_REGION, phoneRegion, String.class);
    }

    @Nullable
    public String getPhoneNumber() {
        return this.getValue(KEY_PHONE_NUMBER, String.class);
    }

    @Nullable
    public void setPhoneNumber(@Nullable String phoneNumber) {
        this.setValue(KEY_PHONE_NUMBER, phoneNumber, String.class);
    }

    @Nullable
    public String getPassword() {
        return this.getValue(KEY_PASSWORD, String.class);
    }

    public void setPassword(@Nullable String password) {
        this.setValue(KEY_PASSWORD, password, String.class);
    }

    @Nullable
    public StudyParticipant getStudyParticipant() {
        return this.getValue(KEY_STUDY_PARTICIPANT, StudyParticipant.class);
    }

    public void setStudyParticipant(@Nullable StudyParticipant studyParticipant) {
        this.setValue(KEY_STUDY_PARTICIPANT, studyParticipant, StudyParticipant.class);
    }
}

