/*
 * Decompiled with CFR 0.152.
 */
package org.sagebionetworks.bridge.android.manager;

import androidx.annotation.AnyThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.sagebionetworks.bridge.android.di.BridgeStudyParticipantScope;
import org.sagebionetworks.bridge.android.manager.AuthenticationManager;
import org.sagebionetworks.bridge.android.manager.dao.AccountDAO;
import org.sagebionetworks.bridge.android.util.retrofit.RxUtils;
import org.sagebionetworks.bridge.rest.model.DateRange;
import org.sagebionetworks.bridge.rest.model.ForwardCursorReportDataList;
import org.sagebionetworks.bridge.rest.model.Message;
import org.sagebionetworks.bridge.rest.model.ReportData;
import org.sagebionetworks.bridge.rest.model.ReportDataList;
import org.sagebionetworks.bridge.rest.model.StudyParticipant;
import org.sagebionetworks.bridge.rest.model.UserSessionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Completable;
import rx.Single;

@BridgeStudyParticipantScope
@AnyThread
public class ParticipantRecordManager {
    private static final Logger logger = LoggerFactory.getLogger(ParticipantRecordManager.class);
    private long lastLoad = 0L;
    private static long DEFAULT_REFRESH = 60000L;
    @NonNull
    private final AccountDAO accountDAO;
    @NonNull
    private final AtomicReference<AuthenticationManager.AuthStateHolder> authStateHolderAtomicReference;

    @Inject
    public ParticipantRecordManager(@NonNull AccountDAO accountDAO, @NonNull AuthenticationManager authenticationManager) {
        this.accountDAO = accountDAO;
        this.authStateHolderAtomicReference = authenticationManager.getAuthStateReference();
    }

    @Nullable
    public StudyParticipant getCachedParticipantRecord() {
        return this.accountDAO.getStudyParticipant();
    }

    @NonNull
    public Single<StudyParticipant> getParticipantRecord() {
        if (this.lastLoad + DEFAULT_REFRESH > System.currentTimeMillis()) {
            return Single.just((Object)this.getCachedParticipantRecord());
        }
        return RxUtils.toBodySingle(this.authStateHolderAtomicReference.get().forConsentedUsersApi.getUsersParticipantRecord(Boolean.valueOf(false))).doOnSuccess(participant -> {
            this.accountDAO.setStudyParticipant((StudyParticipant)participant);
            this.lastLoad = System.currentTimeMillis();
        }).doOnError(throwable -> logger.error(throwable.getLocalizedMessage()));
    }

    @NonNull
    public Single<UserSessionInfo> updateParticipantRecord(@NonNull StudyParticipant studyParticipant) {
        Preconditions.checkNotNull((Object)studyParticipant);
        return RxUtils.toBodySingle(this.authStateHolderAtomicReference.get().forConsentedUsersApi.updateUsersParticipantRecord(studyParticipant)).doOnSuccess(userSessionInfo -> {
            logger.debug("Successfully updated participant");
            this.getParticipantRecord().toCompletable().onErrorComplete(e -> {
                logger.warn("Could not retrieve updated participant", e);
                return true;
            });
        });
    }

    @NonNull
    public Completable emailDataToParticipant(@NonNull LocalDate startDate, @NonNull LocalDate endDate) {
        Preconditions.checkNotNull((Object)startDate);
        Preconditions.checkNotNull((Object)endDate);
        return RxUtils.toBodySingle(this.authStateHolderAtomicReference.get().forConsentedUsersApi.sendDataToUser(new DateRange().startDate(startDate).endDate(endDate))).toCompletable();
    }

    @Nullable
    public DateTime getParticipantCreatedOn() {
        UserSessionInfo sessionInfo = this.accountDAO.getUserSessionInfo();
        if (sessionInfo == null) {
            return null;
        }
        DateTime existingCreatedOnServerTimezone = sessionInfo.getCreatedOn();
        if (existingCreatedOnServerTimezone == null) {
            return null;
        }
        return existingCreatedOnServerTimezone.toDateTime(DateTimeZone.getDefault());
    }

    public Single<Message> saveReportJSON(String reportIdentifier, ReportData reportData) {
        return RxUtils.toBodySingle(this.authStateHolderAtomicReference.get().forConsentedUsersApi.saveParticipantReportRecordsV4(reportIdentifier, reportData));
    }

    public Single<ReportDataList> getReportsV3(@Nonnull String reportIdentifier, @Nonnull LocalDate startLocalDate, @Nonnull LocalDate endLocalDate) {
        return RxUtils.toBodySingle(this.authStateHolderAtomicReference.get().forConsentedUsersApi.getParticipantReportRecords(reportIdentifier, startLocalDate, endLocalDate)).doOnSuccess(scheduleActivityList -> logger.debug("Got report list")).doOnError(throwable -> logger.error(throwable.getMessage()));
    }

    public Single<ForwardCursorReportDataList> getReportsV4(@Nonnull String reportIdentifier, @Nonnull DateTime startTime, @Nonnull DateTime endTime, @Nullable Integer pageSize, @Nullable String offsetKey) {
        DateTime requestEndTime = endTime;
        try {
            int startOffset = startTime.getZone().getOffset((ReadableInstant)startTime);
            int endOffset = endTime.getZone().getOffset((ReadableInstant)endTime);
            if (startOffset != endOffset) {
                requestEndTime = endTime.toDateTime(DateTimeZone.forOffsetMillis((int)startOffset));
                logger.warn("Correcting for mismatched offset. startTime: {}, endTime: {}, newEndTime: {}", new Object[]{startTime, endTime, requestEndTime});
            }
        }
        catch (Exception e) {
            return Single.error((Throwable)e);
        }
        return RxUtils.toBodySingle(this.authStateHolderAtomicReference.get().forConsentedUsersApi.getParticipantReportRecordsV4(reportIdentifier, startTime, requestEndTime, pageSize, offsetKey)).doOnSuccess(scheduleActivityList -> logger.debug("Got report list")).doOnError(throwable -> logger.error(throwable.getMessage()));
    }
}

