/*
 * Decompiled with CFR 0.152.
 */
package org.sagebionetworks.bridge.android.access;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.common.base.Preconditions;

public class Resource<T> {
    @NonNull
    public final Status status;
    @Nullable
    public final T data;
    @Nullable
    public final String message;

    private Resource(@NonNull Status status, @Nullable T data, @Nullable String message) {
        Preconditions.checkNotNull((Object)((Object)status));
        this.status = status;
        this.data = data;
        this.message = message;
    }

    public static <T> Resource<T> success(@NonNull T data) {
        Preconditions.checkNotNull(data);
        return new Resource<T>(Status.SUCCESS, data, null);
    }

    public static <T> Resource<T> error(@Nullable String msg, @Nullable T data) {
        return new Resource<T>(Status.ERROR, data, msg);
    }

    public static <T> Resource<T> loading(@Nullable T data) {
        return new Resource<T>(Status.LOADING, data, null);
    }

    public static enum Status {
        SUCCESS,
        ERROR,
        LOADING;

    }
}

