/*
 * Decompiled with CFR 0.152.
 */
package org.sagebionetworks.bridge.android.manager;

import android.support.annotation.AnyThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import org.joda.time.DateTime;
import org.sagebionetworks.bridge.android.di.BridgeStudyParticipantScope;
import org.sagebionetworks.bridge.android.manager.AuthenticationManager;
import org.sagebionetworks.bridge.android.util.retrofit.RxUtils;
import org.sagebionetworks.bridge.rest.model.Survey;
import rx.Single;

@BridgeStudyParticipantScope
@AnyThread
public class SurveyManager {
    @NonNull
    private final AtomicReference<AuthenticationManager.AuthStateHolder> authStateHolderAtomicReference;

    @Inject
    public SurveyManager(AuthenticationManager authenticationManager) {
        this.authStateHolderAtomicReference = authenticationManager.getAuthStateReference();
    }

    @NonNull
    public Single<Survey> getSurvey(@NonNull String guid, @Nullable DateTime createdOn) {
        if (createdOn != null) {
            return RxUtils.toBodySingle(this.authStateHolderAtomicReference.get().forConsentedUsersApi.getSurvey(guid, createdOn));
        }
        return RxUtils.toBodySingle(this.authStateHolderAtomicReference.get().forConsentedUsersApi.getPublishedSurveyVersion(guid));
    }
}

