/*
 * Decompiled with CFR 0.152.
 */
package org.sagebionetworks.bridge.android.manager;

import android.support.annotation.AnyThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import org.joda.time.LocalDate;
import org.sagebionetworks.bridge.android.BridgeConfig;
import org.sagebionetworks.bridge.android.di.BridgeStudyParticipantScope;
import org.sagebionetworks.bridge.android.manager.dao.AccountDAO;
import org.sagebionetworks.bridge.android.manager.dao.ConsentDAO;
import org.sagebionetworks.bridge.android.util.retrofit.RxUtils;
import org.sagebionetworks.bridge.rest.ApiClientProvider;
import org.sagebionetworks.bridge.rest.UserSessionInfoProvider;
import org.sagebionetworks.bridge.rest.api.AuthenticationApi;
import org.sagebionetworks.bridge.rest.api.ForConsentedUsersApi;
import org.sagebionetworks.bridge.rest.exceptions.ConsentRequiredException;
import org.sagebionetworks.bridge.rest.exceptions.EntityNotFoundException;
import org.sagebionetworks.bridge.rest.model.ConsentSignature;
import org.sagebionetworks.bridge.rest.model.ConsentStatus;
import org.sagebionetworks.bridge.rest.model.EmailSignIn;
import org.sagebionetworks.bridge.rest.model.EmailSignInRequest;
import org.sagebionetworks.bridge.rest.model.Identifier;
import org.sagebionetworks.bridge.rest.model.Phone;
import org.sagebionetworks.bridge.rest.model.PhoneSignIn;
import org.sagebionetworks.bridge.rest.model.PhoneSignInRequest;
import org.sagebionetworks.bridge.rest.model.SharingScope;
import org.sagebionetworks.bridge.rest.model.SignIn;
import org.sagebionetworks.bridge.rest.model.SignUp;
import org.sagebionetworks.bridge.rest.model.StudyParticipant;
import org.sagebionetworks.bridge.rest.model.UserSessionInfo;
import org.sagebionetworks.bridge.rest.model.Withdrawal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Completable;
import rx.Observable;
import rx.Single;
import rx.functions.Func1;

@BridgeStudyParticipantScope
@AnyThread
public class AuthenticationManager
implements UserSessionInfoProvider.UserSessionInfoChangeListener {
    private static final Logger logger = LoggerFactory.getLogger(AuthenticationManager.class);
    @NonNull
    private final AccountDAO accountDAO;
    @NonNull
    private final ConsentDAO consentDAO;
    @NonNull
    private final BridgeConfig config;
    @NonNull
    private final AuthenticationApi authenticationApi;
    @NonNull
    private final List<AuthenticationEventListener> listeners;
    @NonNull
    private final ApiClientProvider apiClientProvider;
    @NonNull
    private final AtomicReference<AuthStateHolder> authStateHolderAtomicReference;

    @Inject
    public AuthenticationManager(@NonNull BridgeConfig config, @NonNull ApiClientProvider apiClientProvider, @NonNull AccountDAO accountDAO, @NonNull ConsentDAO consentDAO) {
        Preconditions.checkNotNull((Object)config);
        Preconditions.checkNotNull((Object)accountDAO);
        Preconditions.checkNotNull((Object)consentDAO);
        this.config = config;
        this.accountDAO = accountDAO;
        this.consentDAO = consentDAO;
        this.apiClientProvider = apiClientProvider;
        this.authenticationApi = apiClientProvider.getAuthenticationApi();
        this.authStateHolderAtomicReference = new AtomicReference<AuthStateHolder>(this.createAuthStateFromStoredCredentials());
        this.listeners = Lists.newArrayList();
    }

    @VisibleForTesting
    @NonNull
    AuthStateHolder createAuthStateFromStoredCredentials() {
        ForConsentedUsersApi forConsentedUsersApi;
        UserSessionInfoProvider userSessionInfoProvider = null;
        ApiClientProvider.AuthenticatedClientProvider provider = this.createAuthenticatedClientProviderFromStoredCredentials();
        if (provider != null) {
            forConsentedUsersApi = (ForConsentedUsersApi)provider.getClient(ForConsentedUsersApi.class);
            userSessionInfoProvider = provider.getUserSessionInfoProvider();
        } else {
            forConsentedUsersApi = (ForConsentedUsersApi)this.apiClientProvider.getClient(ForConsentedUsersApi.class);
        }
        return new AuthStateHolder(forConsentedUsersApi, userSessionInfoProvider);
    }

    @VisibleForTesting
    @Nullable
    ApiClientProvider.AuthenticatedClientProvider createAuthenticatedClientProviderFromStoredCredentials() {
        String email = this.accountDAO.getEmail();
        String phoneRegion = this.accountDAO.getPhoneRegion();
        String phoneNumber = this.accountDAO.getPhoneNumber();
        String externalId = this.accountDAO.getExternalId();
        Phone phone = null;
        if (!Strings.isNullOrEmpty((String)phoneNumber)) {
            phone = new Phone().number(phoneNumber).regionCode(phoneRegion);
        }
        if (Strings.isNullOrEmpty((String)email) && phone == null && Strings.isNullOrEmpty((String)externalId)) {
            return null;
        }
        String password = this.accountDAO.getPassword();
        UserSessionInfo session = this.accountDAO.getUserSessionInfo();
        if (Strings.isNullOrEmpty((String)password) && session == null) {
            return null;
        }
        ApiClientProvider.AuthenticatedClientProviderBuilder builder = this.apiClientProvider.getAuthenticatedClientProviderBuilder().addUserSessionInfoChangeListener((UserSessionInfoProvider.UserSessionInfoChangeListener)this).withPassword(password).withSession(session).withEmail(email).withPhone(phone).withExternalId(externalId);
        return builder.build();
    }

    public void onChange(UserSessionInfo userSessionInfo) {
        this.accountDAO.setUserSessionInfo(userSessionInfo);
    }

    @NonNull
    public Completable signUp(@NonNull String email, @Nullable String password) {
        Preconditions.checkNotNull((Object)email);
        logger.debug("signUp called with email: " + email);
        SignUp participantSignUp = new SignUp().study(this.config.getStudyId()).email(email).password(password);
        return this.signUp(participantSignUp);
    }

    @NonNull
    public Completable signUp(@NonNull SignUp signUp) {
        Preconditions.checkNotNull((Object)signUp);
        logger.debug("signUp called with signUp: " + signUp);
        signUp.study(this.config.getStudyId()).consent(Boolean.valueOf(false)).status(null);
        return RxUtils.toBodySingle(this.authenticationApi.signUp(signUp)).doOnSuccess(message -> {
            SignIn signIn = new SignIn().study(this.config.getStudyId()).email(signUp.getEmail()).password(signUp.getPassword());
            this.accountDAO.setEmail(signUp.getEmail());
            this.accountDAO.setPassword(signUp.getPassword());
            this.accountDAO.setExternalId(signUp.getExternalId());
            Phone phone = signUp.getPhone();
            if (phone != null) {
                this.accountDAO.setPhoneRegion(phone.getRegionCode());
                this.accountDAO.setPhoneNumber(phone.getNumber());
            }
            this.authStateHolderAtomicReference.set(this.createAuthStateFromStoredCredentials());
            StudyParticipant participant = new StudyParticipant();
            participant.email(signUp.getEmail()).firstName(signUp.getFirstName()).lastName(signUp.getLastName()).externalId(signUp.getExternalId());
            this.accountDAO.setStudyParticipant(participant);
        }).flatMap(message -> {
            if (Strings.isNullOrEmpty((String)signUp.getPassword())) {
                if (!Strings.isNullOrEmpty((String)signUp.getEmail())) {
                    return RxUtils.toBodySingle(this.authenticationApi.requestEmailSignIn(new EmailSignInRequest().study(this.config.getStudyId()).email(signUp.getEmail()))).doOnSuccess(m -> logger.debug("Request for email sign-in link succeeded")).doOnError(t -> logger.warn("Request for email sign-in link failed: ", t));
                }
                if (signUp.getPhone() != null) {
                    return RxUtils.toBodySingle(this.authenticationApi.requestPhoneSignIn(new PhoneSignInRequest().phone(signUp.getPhone()).study(this.config.getStudyId())));
                }
            }
            return Single.just((Object)message);
        }).doOnError(throwable -> this.accountDAO.setStudyParticipant(null)).toCompletable();
    }

    @NonNull
    public Completable signUp(@NonNull Phone phone) {
        Preconditions.checkNotNull((Object)phone);
        logger.debug("signUp called with phone: " + phone);
        SignUp signUp = new SignUp().phone(phone);
        signUp.study(this.config.getStudyId()).consent(Boolean.valueOf(false)).status(null);
        return this.signUp(signUp);
    }

    @NonNull
    public Completable resendEmailVerification(@NonNull String email) {
        Preconditions.checkNotNull((Object)email);
        logger.debug("resendEmailVerification called with email: " + email);
        return RxUtils.toBodySingle(this.authenticationApi.resendEmailVerification(new Identifier().study(this.config.getStudyId()).email(email))).toCompletable();
    }

    @NonNull
    public Completable requestEmailSignIn(@NonNull String email) {
        Preconditions.checkNotNull((Object)email);
        return RxUtils.toBodySingle(this.authenticationApi.requestEmailSignIn(new EmailSignInRequest().email(email).study(this.config.getStudyId()))).doOnSuccess(m -> logger.debug("Email sign in request success: " + m.getMessage())).doOnError(t -> logger.debug("Email sign in request failure", t)).toCompletable();
    }

    @NonNull
    public Completable requestPhoneSignIn(@NonNull String regionCode, @NonNull String phoneNumber) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)regionCode) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)phoneNumber) ? 1 : 0) != 0);
        Phone phone = new Phone().regionCode(regionCode).number(phoneNumber);
        return RxUtils.toBodySingle(this.authenticationApi.requestPhoneSignIn(new PhoneSignInRequest().phone(phone).study(this.config.getStudyId()))).doOnSuccess(m -> {
            logger.debug("Phone sign in request success: " + m.getMessage());
            this.accountDAO.setPhoneRegion(regionCode);
            this.accountDAO.setPhoneNumber(phoneNumber);
        }).doOnError(t -> logger.debug("Phone sign in request failure", t)).toCompletable();
    }

    @NonNull
    public Single<UserSessionInfo> signInViaPhoneLink(@NonNull String regionCode, @NonNull String phoneNumber, @NonNull String token) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)regionCode) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)phoneNumber) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)token) ? 1 : 0) != 0);
        Phone phone = new Phone().regionCode(regionCode).number(phoneNumber);
        PhoneSignIn phoneSignIn = new PhoneSignIn().study(this.config.getStudyId()).phone(phone).token(token);
        SignIn signIn = new SignIn().phone(phone).study(this.config.getStudyId());
        return RxUtils.toBodySingle(this.authenticationApi.signInViaPhone(phoneSignIn)).compose(this.signInHelper(signIn)).doOnSuccess(session -> logger.debug("Successfully signed in via phone")).doOnError(t -> logger.debug("Failed to sign in via phone", t));
    }

    @NonNull
    public Single<UserSessionInfo> signInViaEmailLink(@NonNull String email, @NonNull String token) {
        Preconditions.checkNotNull((Object)email);
        Preconditions.checkNotNull((Object)token);
        SignIn signIn = new SignIn().email(email).study(this.config.getStudyId());
        return RxUtils.toBodySingle(this.authenticationApi.signInViaEmail(new EmailSignIn().email(email).study(this.config.getStudyId()).token(token))).compose(this.signInHelper(signIn)).doOnSuccess(session -> logger.debug("Successfully signed in via email")).doOnError(t -> logger.debug("Failed to sign in via email", t));
    }

    @NonNull
    public Single<UserSessionInfo> signIn(@NonNull String email, @NonNull String password) {
        Preconditions.checkNotNull((Object)email);
        Preconditions.checkNotNull((Object)password);
        logger.debug("signIn called with email: " + email);
        String studyId = this.config.getStudyId();
        SignIn signIn = new SignIn().study(studyId).email(email).password(password);
        return RxUtils.toBodySingle(this.authenticationApi.signIn(signIn)).compose(this.signInHelper(signIn));
    }

    @NonNull
    public Single<UserSessionInfo> signInWithExternalId(@NonNull String externalId, @NonNull String password) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)externalId) ? 1 : 0) != 0, (Object)"externalId cannot be null or empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)password) ? 1 : 0) != 0, (Object)"password cannot be null or empty");
        SignIn signIn = new SignIn().study(this.config.getStudyId()).externalId(externalId).password(password);
        return RxUtils.toBodySingle(this.authenticationApi.signInV4(signIn)).compose(this.signInHelper(signIn)).doOnSuccess(session -> logger.debug("Successfully signed in via externalId")).doOnError(t -> logger.debug("Failed to sign in via externalId", t));
    }

    Single.Transformer<UserSessionInfo, UserSessionInfo> signInHelper(SignIn signIn) {
        String email = signIn.getEmail();
        return userSessionInfoSingle -> userSessionInfoSingle.doOnSubscribe(this.accountDAO::clear).onErrorResumeNext(t -> {
            if (t instanceof ConsentRequiredException) {
                logger.debug("Received ConsentRequiredException, treating as success");
                return Single.just((Object)((ConsentRequiredException)t).getSession());
            }
            return Single.error((Throwable)t);
        }).doOnSuccess(session -> {
            this.accountDAO.setEmail(email);
            this.accountDAO.setPassword(signIn.getPassword());
            this.accountDAO.setExternalId(signIn.getExternalId());
            Phone phone = signIn.getPhone();
            if (phone != null) {
                this.accountDAO.setPhoneRegion(phone.getRegionCode());
                this.accountDAO.setPhoneNumber(phone.getNumber());
            }
            this.accountDAO.setUserSessionInfo((UserSessionInfo)session);
            this.authStateHolderAtomicReference.set(this.createAuthStateFromStoredCredentials());
            this.accountDAO.setStudyParticipant(new StudyParticipant().email(signIn.getEmail()));
        }).flatMap(session -> {
            if (!session.isConsented().booleanValue()) {
                for (Map.Entry consentStatusEntry : session.getConsentStatuses().entrySet()) {
                    String subpopulationGuid = (String)consentStatusEntry.getKey();
                    ConsentStatus consentStatus = (ConsentStatus)consentStatusEntry.getValue();
                    if (!consentStatus.isRequired().booleanValue() || consentStatus.isConsented().booleanValue()) continue;
                    if (this.isConsentedInLocal(subpopulationGuid)) {
                        return this.uploadLocalConsents().toSingle();
                    }
                    return Single.error((Throwable)new ConsentRequiredException("Consent required.", "signIn", session));
                }
            }
            return Single.just((Object)session);
        }).doOnError(t -> this.accountDAO.clear());
    }

    Func1<Observable<? extends Throwable>, ? extends Observable<UserSessionInfo>> retrySignInForConsentOnce(final String subpopulationGuid) {
        return new Func1<Observable<? extends Throwable>, Observable<UserSessionInfo>>(){
            private int retryAttempt = 0;

            public Observable<UserSessionInfo> call(Observable<? extends Throwable> throwableObservable) {
                return throwableObservable.flatMap(throwable -> {
                    ++this.retryAttempt;
                    if (!(throwable instanceof ConsentRequiredException) || this.retryAttempt > 1 || !AuthenticationManager.this.isConsented() && !AuthenticationManager.this.isConsentedInLocal(subpopulationGuid)) {
                        Observable obs = Observable.error((Throwable)throwable);
                        return obs;
                    }
                    return AuthenticationManager.this.uploadLocalConsents();
                });
            }
        };
    }

    @NonNull
    public Completable signOut() {
        logger.debug("signOut called");
        String email = this.accountDAO.getEmail();
        for (AuthenticationEventListener listener : this.listeners) {
            listener.onSignedOut(email);
        }
        Completable completable = RxUtils.toBodySingle(this.authenticationApi.signOut()).toCompletable();
        this.accountDAO.clear();
        this.consentDAO.clear();
        this.authStateHolderAtomicReference.set(this.createAuthStateFromStoredCredentials());
        return completable;
    }

    @NonNull
    public Completable requestPasswordReset(@NonNull String email) {
        Preconditions.checkNotNull((Object)email);
        logger.debug("requestPasswordReset called with email: " + email);
        return RxUtils.toBodySingle(this.authenticationApi.requestResetPassword(new SignIn().study(this.config.getStudyId()).email(email))).toCompletable();
    }

    @NonNull
    public AtomicReference<AuthStateHolder> getAuthStateReference() {
        logger.debug("getAuthStateReference called");
        return this.authStateHolderAtomicReference;
    }

    @NonNull
    public boolean hasAuthenticationCredentials() {
        logger.debug("hasAuthenticationCredentials called");
        return this.authStateHolderAtomicReference.get().userSessionInfoProvider != null;
    }

    @Nullable
    public String getEmail() {
        return this.accountDAO.getEmail();
    }

    @Nullable
    public UserSessionInfo getUserSessionInfo() {
        logger.debug("getUserSessionInfo called");
        return this.accountDAO.getUserSessionInfo();
    }

    @Deprecated
    @NonNull
    public Single<UserSessionInfo> getLatestUserSessionInfo() {
        return RxUtils.toBodySingle(this.getAuthStateReference().get().forConsentedUsersApi.updateUsersParticipantRecord(new StudyParticipant()));
    }

    public void addEventListener(AuthenticationEventListener listener) {
        this.listeners.add(listener);
    }

    public void removeEventListener(AuthenticationEventListener listener) {
        this.listeners.remove(listener);
    }

    public boolean isConsented(@NonNull String subpopulationGuid) {
        Preconditions.checkNotNull((Object)subpopulationGuid);
        return this.isConsentedInSessionOrLocal(this.getUserSessionInfo(), subpopulationGuid);
    }

    public boolean isConsentedMostRecent(@NonNull String subpopulationGuid) {
        Preconditions.checkNotNull((Object)subpopulationGuid);
        ConsentStatus consentStatus = this.getConsentStatusFromSession(subpopulationGuid);
        if (consentStatus == null) {
            return false;
        }
        return consentStatus.isSignedMostRecentConsent();
    }

    @Nullable
    private ConsentStatus getConsentStatusFromSession(@NonNull String subpopulationGuid) {
        Preconditions.checkNotNull((Object)subpopulationGuid);
        UserSessionInfo userSessionInfo = this.getUserSessionInfo();
        return userSessionInfo == null ? null : (ConsentStatus)userSessionInfo.getConsentStatuses().get(subpopulationGuid);
    }

    boolean isConsentedInSessionOrLocal(UserSessionInfo session, String subpopulationGuid) {
        ConsentStatus subpopulationStatus = this.getConsentStatusFromSession(subpopulationGuid);
        if (subpopulationStatus != null && subpopulationStatus.isConsented().booleanValue()) {
            return true;
        }
        return this.isConsentedInLocal(subpopulationGuid);
    }

    boolean isConsentedInLocal(String subpopulationGuid) {
        return this.consentDAO.getConsent(subpopulationGuid) != null;
    }

    public boolean isConsented() {
        UserSessionInfo userSessionInfo = this.getUserSessionInfo();
        if (userSessionInfo != null) {
            if (userSessionInfo.isConsented().booleanValue()) {
                return true;
            }
            for (String subpopulation : this.getRequiredConsents(userSessionInfo)) {
                if (this.isConsentedInSessionOrLocal(userSessionInfo, subpopulation)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @NonNull
    Set<String> getRequiredConsents(@NonNull UserSessionInfo userSessionInfo) {
        Preconditions.checkNotNull((Object)userSessionInfo);
        HashSet subpopulations = Sets.newHashSet();
        if (userSessionInfo.getConsentStatuses() == null) {
            return subpopulations;
        }
        for (Map.Entry consentStatus : userSessionInfo.getConsentStatuses().entrySet()) {
            if (!((ConsentStatus)consentStatus.getValue()).isRequired().booleanValue()) continue;
            subpopulations.add(consentStatus.getKey());
        }
        return subpopulations;
    }

    public boolean isConsentedMostRecent() {
        UserSessionInfo userSessionInfo = this.getUserSessionInfo();
        return userSessionInfo == null ? false : userSessionInfo.isSignedMostRecentConsent();
    }

    @NonNull
    public Single<UserSessionInfo> giveConsent(@NonNull String subpopulationGuid, @NonNull String name, @Nullable LocalDate birthdate, @Nullable String base64Image, @Nullable String imageMimeType, @NonNull SharingScope sharingScope) {
        ConsentSignature consent = this.storeLocalConsent(subpopulationGuid, name, birthdate, base64Image, imageMimeType, sharingScope);
        return this.uploadConsent(subpopulationGuid, consent);
    }

    private Single<UserSessionInfo> uploadConsent(@NonNull String subpopulationGuid, @NonNull ConsentSignature consent) {
        return Single.just((Object)consent).flatMap(consentSignature -> RxUtils.toBodySingle(this.getAuthStateReference().get().forConsentedUsersApi.createConsentSignature(subpopulationGuid, consentSignature)).doOnSuccess(userSessionInfo -> {
            this.accountDAO.setUserSessionInfo((UserSessionInfo)userSessionInfo);
            this.consentDAO.removeConsent(subpopulationGuid);
        }).doOnError(e -> logger.info("Couldn't upload consent to Bridge, subpopulationGuid: " + subpopulationGuid, e)));
    }

    public Observable<UserSessionInfo> uploadLocalConsents() {
        Observable subpopulations = Observable.from(this.consentDAO.listConsents()).cache();
        return subpopulations.map(this.consentDAO::getConsent).zipWith(subpopulations, (consentSignature, subpopulation) -> this.uploadConsent((String)subpopulation, (ConsentSignature)consentSignature)).flatMap(Single::toObservable);
    }

    public ConsentSignature storeLocalConsent(@NonNull String subpopulationGuid, @NonNull String name, @Nullable LocalDate birthdate, @Nullable String base64Image, @Nullable String imageMimeType, @NonNull SharingScope sharingScope) {
        Preconditions.checkNotNull((Object)subpopulationGuid);
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)sharingScope);
        ConsentSignature consentSignature = new ConsentSignature().name(name).birthdate(birthdate).imageData(base64Image).imageMimeType(imageMimeType).scope(sharingScope);
        this.storeLocalConsent(subpopulationGuid, consentSignature);
        return consentSignature;
    }

    public void storeLocalConsent(@NonNull String subpopulationGuid, @NonNull ConsentSignature consentSignature) {
        Preconditions.checkNotNull((Object)subpopulationGuid);
        Preconditions.checkNotNull((Object)consentSignature);
        logger.debug("Saving consent locally, subpopulationGuid: " + subpopulationGuid);
        this.consentDAO.putConsent(subpopulationGuid, consentSignature);
    }

    @NonNull
    public Single<ConsentSignature> getConsent(@NonNull String subpopulationGuid) {
        Preconditions.checkNotNull((Object)subpopulationGuid);
        return RxUtils.toBodySingle(this.getAuthStateReference().get().forConsentedUsersApi.getConsentSignature(subpopulationGuid)).onErrorResumeNext(throwable -> {
            if (throwable instanceof EntityNotFoundException) {
                return Single.just((Object)this.consentDAO.getConsent(subpopulationGuid));
            }
            return Single.error((Throwable)throwable);
        });
    }

    @Nullable
    public ConsentSignature retrieveLocalConsent(@NonNull String subpopulationGuid) {
        Preconditions.checkNotNull((Object)subpopulationGuid);
        return this.consentDAO.getConsent(subpopulationGuid);
    }

    @NonNull
    public Completable withdrawAll(@Nullable String reason) {
        return RxUtils.toBodySingle(this.getAuthStateReference().get().forConsentedUsersApi.withdrawFromStudy(new Withdrawal().reason(reason))).toCompletable();
    }

    @NonNull
    public Completable withdrawConsent(@NonNull String subpopulationGuid, @Nullable String reason) {
        Preconditions.checkNotNull((Object)subpopulationGuid);
        return RxUtils.toBodySingle(this.getAuthStateReference().get().forConsentedUsersApi.withdrawConsentFromSubpopulation(subpopulationGuid, new Withdrawal().reason(reason))).toCompletable();
    }

    public static interface AuthenticationEventListener {
        public void onSignedOut(String var1);

        public void onSignedIn(String var1);
    }

    public static final class AuthStateHolder {
        @NonNull
        public final ForConsentedUsersApi forConsentedUsersApi;
        @Nullable
        final UserSessionInfoProvider userSessionInfoProvider;

        public AuthStateHolder(@NonNull ForConsentedUsersApi forConsentedUsersApi, @Nullable UserSessionInfoProvider userSessionInfoProvider) {
            this.forConsentedUsersApi = forConsentedUsersApi;
            this.userSessionInfoProvider = userSessionInfoProvider;
        }
    }
}

