/*
 * Decompiled with CFR 0.152.
 */
package org.sagebionetworks.bridge.android.di;

import android.content.Context;
import android.net.TrafficStats;
import com.facebook.stetho.okhttp3.StethoInterceptor;
import com.google.common.collect.Lists;
import dagger.Module;
import dagger.Provides;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.net.SocketFactory;
import org.sagebionetworks.bridge.android.BridgeConfig;
import org.sagebionetworks.bridge.android.R;
import org.sagebionetworks.bridge.android.di.BridgeStudyScope;
import org.sagebionetworks.bridge.android.util.okhttp.DelegatingSocketFactory;
import org.sagebionetworks.bridge.data.AndroidStudyUploadEncryptor;
import org.sagebionetworks.bridge.rest.ApiClientProvider;
import org.sagebionetworks.bridge.rest.api.PublicApi;

@Module
public class BridgeServiceModule {
    @Provides
    @BridgeStudyScope
    SocketFactory getSocketFactory() {
        return new DelegatingSocketFactory(SocketFactory.getDefault()){

            @Override
            protected Socket configureSocket(Socket socket) throws IOException {
                TrafficStats.tagSocket((Socket)socket);
                return socket;
            }
        };
    }

    @Provides
    @BridgeStudyScope
    ApiClientProvider getApiClientProvider(Context applicationContext, BridgeConfig bridgeConfig, SocketFactory socketFactory) {
        List appInterceptors = Collections.emptyList();
        ArrayList networkInterceptors = Lists.newArrayList();
        if (applicationContext.getResources().getBoolean(R.bool.osb_stetho_debug_bridge)) {
            networkInterceptors.add(new StethoInterceptor());
        }
        return new ApiClientProvider(bridgeConfig.getBaseUrl(), bridgeConfig.getUserAgent(), bridgeConfig.getAcceptLanguage(), bridgeConfig.getStudyId(), socketFactory, (List)networkInterceptors, appInterceptors);
    }

    @Provides
    @BridgeStudyScope
    static PublicApi providePublicApi(ApiClientProvider apiClientProvider) {
        return (PublicApi)apiClientProvider.getClient(PublicApi.class);
    }

    @Provides
    @BridgeStudyScope
    AndroidStudyUploadEncryptor getAndroidStudyUploadEncryptor(BridgeConfig bridgeConfig) {
        try {
            return new AndroidStudyUploadEncryptor(bridgeConfig.getPublicKey());
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create StudyUploadEncryptor", e);
        }
    }
}

