/*
 * Decompiled with CFR 0.152.
 */
package org.sagebionetworks.bridge.android.manager;

import android.content.Context;
import dagger.internal.DoubleCheck;
import dagger.internal.InstanceFactory;
import dagger.internal.Preconditions;
import javax.inject.Provider;
import okhttp3.OkHttpClient;
import org.sagebionetworks.bridge.android.BridgeConfig;
import org.sagebionetworks.bridge.android.di.BridgeStudyComponent;
import org.sagebionetworks.bridge.android.manager.ActivityManager;
import org.sagebionetworks.bridge.android.manager.ActivityManager_Factory;
import org.sagebionetworks.bridge.android.manager.AppConfigManager;
import org.sagebionetworks.bridge.android.manager.AuthenticationManager;
import org.sagebionetworks.bridge.android.manager.AuthenticationManager_Factory;
import org.sagebionetworks.bridge.android.manager.BridgeManagerProvider;
import org.sagebionetworks.bridge.android.manager.ParticipantRecordManager;
import org.sagebionetworks.bridge.android.manager.ParticipantRecordManager_Factory;
import org.sagebionetworks.bridge.android.manager.SurveyManager;
import org.sagebionetworks.bridge.android.manager.SurveyManager_Factory;
import org.sagebionetworks.bridge.android.manager.UploadManager;
import org.sagebionetworks.bridge.android.manager.UploadManager_Factory;
import org.sagebionetworks.bridge.android.manager.dao.AccountDAO;
import org.sagebionetworks.bridge.android.manager.dao.ConsentDAO;
import org.sagebionetworks.bridge.android.manager.dao.UploadDAO;
import org.sagebionetworks.bridge.data.AndroidStudyUploadEncryptor;
import org.sagebionetworks.bridge.rest.ApiClientProvider;

public final class DaggerBridgeManagerProvider
implements BridgeManagerProvider {
    private final BridgeStudyComponent bridgeStudyComponent;
    private final Context applicationContext;
    private Provider<BridgeConfig> getBridgeConfigProvider;
    private Provider<ApiClientProvider> getApiClientProvider;
    private Provider<AccountDAO> getAccountDaoProvider;
    private Provider<ConsentDAO> getConsentDaoProvider;
    private Provider<AuthenticationManager> authenticationManagerProvider;
    private Provider<Context> applicationContextProvider;
    private Provider<ActivityManager> activityManagerProvider;
    private Provider<ParticipantRecordManager> participantRecordManagerProvider;
    private Provider<SurveyManager> surveyManagerProvider;
    private Provider<AndroidStudyUploadEncryptor> getStudyUploadEncryptorProvider;
    private Provider<UploadDAO> getUploadDAOProvider;
    private Provider<OkHttpClient> getS3OkHttp3ClientProvider;
    private Provider<UploadManager> uploadManagerProvider;

    private DaggerBridgeManagerProvider(BridgeStudyComponent bridgeStudyComponentParam, Context applicationContextParam) {
        this.bridgeStudyComponent = bridgeStudyComponentParam;
        this.applicationContext = applicationContextParam;
        this.initialize(bridgeStudyComponentParam, applicationContextParam);
    }

    public static BridgeManagerProvider.Builder builder() {
        return new Builder();
    }

    private void initialize(BridgeStudyComponent bridgeStudyComponentParam, Context applicationContextParam) {
        this.getBridgeConfigProvider = new org_sagebionetworks_bridge_android_di_BridgeStudyComponent_getBridgeConfig(bridgeStudyComponentParam);
        this.getApiClientProvider = new org_sagebionetworks_bridge_android_di_BridgeStudyComponent_getApiClientProvider(bridgeStudyComponentParam);
        this.getAccountDaoProvider = new org_sagebionetworks_bridge_android_di_BridgeStudyComponent_getAccountDao(bridgeStudyComponentParam);
        this.getConsentDaoProvider = new org_sagebionetworks_bridge_android_di_BridgeStudyComponent_getConsentDao(bridgeStudyComponentParam);
        this.authenticationManagerProvider = DoubleCheck.provider((Provider)AuthenticationManager_Factory.create(this.getBridgeConfigProvider, this.getApiClientProvider, this.getAccountDaoProvider, this.getConsentDaoProvider));
        this.applicationContextProvider = InstanceFactory.create((Object)applicationContextParam);
        this.activityManagerProvider = DoubleCheck.provider((Provider)ActivityManager_Factory.create(this.authenticationManagerProvider, this.applicationContextProvider));
        this.participantRecordManagerProvider = DoubleCheck.provider((Provider)ParticipantRecordManager_Factory.create(this.getAccountDaoProvider, this.authenticationManagerProvider));
        this.surveyManagerProvider = DoubleCheck.provider((Provider)SurveyManager_Factory.create(this.authenticationManagerProvider));
        this.getStudyUploadEncryptorProvider = new org_sagebionetworks_bridge_android_di_BridgeStudyComponent_getStudyUploadEncryptor(bridgeStudyComponentParam);
        this.getUploadDAOProvider = new org_sagebionetworks_bridge_android_di_BridgeStudyComponent_getUploadDAO(bridgeStudyComponentParam);
        this.getS3OkHttp3ClientProvider = new org_sagebionetworks_bridge_android_di_BridgeStudyComponent_getS3OkHttp3Client(bridgeStudyComponentParam);
        this.uploadManagerProvider = DoubleCheck.provider((Provider)UploadManager_Factory.create(this.authenticationManagerProvider, this.getStudyUploadEncryptorProvider, this.getUploadDAOProvider, this.getS3OkHttp3ClientProvider));
    }

    @Override
    public AccountDAO getAccountDao() {
        return (AccountDAO)Preconditions.checkNotNull((Object)this.bridgeStudyComponent.getAccountDao(), (String)"Cannot return null from a non-@Nullable component method");
    }

    @Override
    public ActivityManager getActivityManager() {
        return (ActivityManager)this.activityManagerProvider.get();
    }

    @Override
    public ApiClientProvider getApiClientProvider() {
        return (ApiClientProvider)Preconditions.checkNotNull((Object)this.bridgeStudyComponent.getApiClientProvider(), (String)"Cannot return null from a non-@Nullable component method");
    }

    @Override
    public AppConfigManager getAppConfigManager() {
        return (AppConfigManager)Preconditions.checkNotNull((Object)this.bridgeStudyComponent.getAppConfigManager(), (String)"Cannot return null from a non-@Nullable component method");
    }

    @Override
    public Context getApplicationContext() {
        return this.applicationContext;
    }

    @Override
    public AuthenticationManager getAuthenticationManager() {
        return (AuthenticationManager)this.authenticationManagerProvider.get();
    }

    @Override
    public BridgeConfig getBridgeConfig() {
        return (BridgeConfig)Preconditions.checkNotNull((Object)this.bridgeStudyComponent.getBridgeConfig(), (String)"Cannot return null from a non-@Nullable component method");
    }

    @Override
    public ConsentDAO getConsentDao() {
        return (ConsentDAO)Preconditions.checkNotNull((Object)this.bridgeStudyComponent.getConsentDao(), (String)"Cannot return null from a non-@Nullable component method");
    }

    @Override
    public ParticipantRecordManager getParticipantManager() {
        return (ParticipantRecordManager)this.participantRecordManagerProvider.get();
    }

    @Override
    public AndroidStudyUploadEncryptor getStudyUploadEncryptor() {
        return (AndroidStudyUploadEncryptor)Preconditions.checkNotNull((Object)this.bridgeStudyComponent.getStudyUploadEncryptor(), (String)"Cannot return null from a non-@Nullable component method");
    }

    @Override
    public SurveyManager getSurveyManager() {
        return (SurveyManager)this.surveyManagerProvider.get();
    }

    @Override
    public UploadManager getUploadManager() {
        return (UploadManager)this.uploadManagerProvider.get();
    }

    private static class org_sagebionetworks_bridge_android_di_BridgeStudyComponent_getS3OkHttp3Client
    implements Provider<OkHttpClient> {
        private final BridgeStudyComponent bridgeStudyComponent;

        org_sagebionetworks_bridge_android_di_BridgeStudyComponent_getS3OkHttp3Client(BridgeStudyComponent bridgeStudyComponent) {
            this.bridgeStudyComponent = bridgeStudyComponent;
        }

        public OkHttpClient get() {
            return (OkHttpClient)Preconditions.checkNotNull((Object)this.bridgeStudyComponent.getS3OkHttp3Client(), (String)"Cannot return null from a non-@Nullable component method");
        }
    }

    private static class org_sagebionetworks_bridge_android_di_BridgeStudyComponent_getUploadDAO
    implements Provider<UploadDAO> {
        private final BridgeStudyComponent bridgeStudyComponent;

        org_sagebionetworks_bridge_android_di_BridgeStudyComponent_getUploadDAO(BridgeStudyComponent bridgeStudyComponent) {
            this.bridgeStudyComponent = bridgeStudyComponent;
        }

        public UploadDAO get() {
            return (UploadDAO)Preconditions.checkNotNull((Object)this.bridgeStudyComponent.getUploadDAO(), (String)"Cannot return null from a non-@Nullable component method");
        }
    }

    private static class org_sagebionetworks_bridge_android_di_BridgeStudyComponent_getStudyUploadEncryptor
    implements Provider<AndroidStudyUploadEncryptor> {
        private final BridgeStudyComponent bridgeStudyComponent;

        org_sagebionetworks_bridge_android_di_BridgeStudyComponent_getStudyUploadEncryptor(BridgeStudyComponent bridgeStudyComponent) {
            this.bridgeStudyComponent = bridgeStudyComponent;
        }

        public AndroidStudyUploadEncryptor get() {
            return (AndroidStudyUploadEncryptor)Preconditions.checkNotNull((Object)this.bridgeStudyComponent.getStudyUploadEncryptor(), (String)"Cannot return null from a non-@Nullable component method");
        }
    }

    private static class org_sagebionetworks_bridge_android_di_BridgeStudyComponent_getConsentDao
    implements Provider<ConsentDAO> {
        private final BridgeStudyComponent bridgeStudyComponent;

        org_sagebionetworks_bridge_android_di_BridgeStudyComponent_getConsentDao(BridgeStudyComponent bridgeStudyComponent) {
            this.bridgeStudyComponent = bridgeStudyComponent;
        }

        public ConsentDAO get() {
            return (ConsentDAO)Preconditions.checkNotNull((Object)this.bridgeStudyComponent.getConsentDao(), (String)"Cannot return null from a non-@Nullable component method");
        }
    }

    private static class org_sagebionetworks_bridge_android_di_BridgeStudyComponent_getAccountDao
    implements Provider<AccountDAO> {
        private final BridgeStudyComponent bridgeStudyComponent;

        org_sagebionetworks_bridge_android_di_BridgeStudyComponent_getAccountDao(BridgeStudyComponent bridgeStudyComponent) {
            this.bridgeStudyComponent = bridgeStudyComponent;
        }

        public AccountDAO get() {
            return (AccountDAO)Preconditions.checkNotNull((Object)this.bridgeStudyComponent.getAccountDao(), (String)"Cannot return null from a non-@Nullable component method");
        }
    }

    private static class org_sagebionetworks_bridge_android_di_BridgeStudyComponent_getApiClientProvider
    implements Provider<ApiClientProvider> {
        private final BridgeStudyComponent bridgeStudyComponent;

        org_sagebionetworks_bridge_android_di_BridgeStudyComponent_getApiClientProvider(BridgeStudyComponent bridgeStudyComponent) {
            this.bridgeStudyComponent = bridgeStudyComponent;
        }

        public ApiClientProvider get() {
            return (ApiClientProvider)Preconditions.checkNotNull((Object)this.bridgeStudyComponent.getApiClientProvider(), (String)"Cannot return null from a non-@Nullable component method");
        }
    }

    private static class org_sagebionetworks_bridge_android_di_BridgeStudyComponent_getBridgeConfig
    implements Provider<BridgeConfig> {
        private final BridgeStudyComponent bridgeStudyComponent;

        org_sagebionetworks_bridge_android_di_BridgeStudyComponent_getBridgeConfig(BridgeStudyComponent bridgeStudyComponent) {
            this.bridgeStudyComponent = bridgeStudyComponent;
        }

        public BridgeConfig get() {
            return (BridgeConfig)Preconditions.checkNotNull((Object)this.bridgeStudyComponent.getBridgeConfig(), (String)"Cannot return null from a non-@Nullable component method");
        }
    }

    private static final class Builder
    implements BridgeManagerProvider.Builder {
        private BridgeStudyComponent bridgeStudyComponent;
        private Context applicationContext;

        private Builder() {
        }

        @Override
        public Builder applicationContext(Context context) {
            this.applicationContext = (Context)Preconditions.checkNotNull((Object)context);
            return this;
        }

        @Override
        public Builder bridgeStudyComponent(BridgeStudyComponent bridgeStudyComponent) {
            this.bridgeStudyComponent = (BridgeStudyComponent)Preconditions.checkNotNull((Object)bridgeStudyComponent);
            return this;
        }

        @Override
        public BridgeManagerProvider build() {
            Preconditions.checkBuilderRequirement((Object)this.bridgeStudyComponent, BridgeStudyComponent.class);
            Preconditions.checkBuilderRequirement((Object)this.applicationContext, Context.class);
            return new DaggerBridgeManagerProvider(this.bridgeStudyComponent, this.applicationContext);
        }
    }
}

